#!/bin/sh

DIR=/nmt/apps
APP_DIR=/share/Apps

install()
{
    if [ -d $DIR/server ];then
        cd $DIR/server
        if [ ! -d $APP_DIR/AppInit/websites ];then
            mkdir -p $APP_DIR/AppInit/websites
        fi
        cd $DIR
        if [ -f $APP_DIR/lighttpd-nmt/lighttpd.tar ];then
            tar xvf $APP_DIR/lighttpd-nmt/lighttpd.tar
            cd $DIR/etc
            cat init_nmt|sed 's|case "$1" in|/nmt/apps/etc/lighttpd.sh "$1"\ncase "$1" in|g' > init_nmt.new
            mv -f init_nmt.new init_nmt
            chmod 775 init_nmt
        else
            echo "Error while extracting lighttpd.tar"
            exit 1
        fi
    else
        exit 1
    fi
}

uninstall()
{
    if [ -d $DIR/server ];then
        cd $DIR/server
        rm -f lighttpd lighttpd-angel
        cd $DIR/etc
        rm -rf lighttpd lighttpd.sh 
        cat init_nmt|sed '/\/nmt\/apps\/etc\/lighttpd.sh "$1"/d' > init_nmt.new
        mv -f init_nmt.new init_nmt
        chmod 775 init_nmt
        cd $DIR/lib
        rm -rf lighttpd 
    else
        exit 1
    fi

}

case "$1" in
    install)
    install
    ;;

    uninstall)
    uninstall
    ;;
esac
