#! /bin/sh

INSTALL_ROOT=/share/Apps/MPD
NAME=mpd
DAEMON=${INSTALL_ROOT}/bin/${NAME}
DESC="Music Player Daemon"
MPDCONF=${INSTALL_ROOT}/mpd/mpd.conf
PIDFILE=/var/run/${NAME}.pid
PATH=${INSTALL_ROOT}/bin:$PATH
export LD_LIBRARY_PATH=${INSTALL_ROOT}/lib:$LD_LIBRARY_PATH

test -x $DAEMON || exit 0

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet --pidfile $PIDFILE \
		--exec $DAEMON $MPDCONF
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 --pidfile $PIDFILE  --name $NAME
	echo "$NAME."
	;;
  reload|restart)
        stop
        sleep 1
        start
  ;;
  *)
	echo "Usage: $0 {start|stop|restart|reload}" >&2
	exit 1
	;;
esac

exit 0
