<?php
// +-----------------------------------------------------------------------+
// |                                                                       |
// | THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   |
// | "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     |
// | LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR |
// | A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  |
// | OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, |
// | SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT      |
// | LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, |
// | DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY |
// | THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   |
// | (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE |
// | OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  |
// |                                                                       |
// +-----------------------------------------------------------------------+

if (is_readable("_include/functions.php"))
    include "_include/functions.php";
else
    include "functions.php";

global $tmpdir;
ini_set("session.save_path", $tmpdir);
ini_set("error_reporting", "E_ERROR");
session_start();
session_cache_limiter('nocache');
header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past

if (isset($_GET["type"]))
    $type = $_GET['type'];
else
    $type = "DETAIL_POSTER";

if (isset($_GET["imdbid"]))
    $imdbid = $_GET["imdbid"];
else
    $imdbid = "tt0111257";

if (isset($_GET["image"]))
    $image = $_GET['image'];
else {
    if ($type == "DETAIL_POSTER")
        $image = "_img/no-poster.jpg";
    else
        $image = "_img/no-fanart.jpg";
}

if ($type == 'DETAIL_POSTER')
    $text = 'Poster';
else if ($type == 'THUMBNAIL')
    $text = 'Thumbnail';
else if ($type == 'WALLPAPER')
    $text = 'Wallpaper';
$APIKEY = "b626260be86175272e48fa6347e58100";

$data = shell_exec("wget http://api.themoviedb.org/2.1/Movie.getImages/en/xml/" . $APIKEY . "/" . $imdbid . " -qO-");
$xml_parser = xml_parser_create();
xml_parse_into_struct($xml_parser, $data, $vals, $index);
xml_parser_free($xml_parser);
$i = 0;
$img_array[0] = $image;
foreach ($vals as $img_data) {
    if ($type == 'DETAIL_POSTER' || $type == 'THUMBNAIL') {
        if ($img_data['tag'] == 'IMAGE' && $img_data['attributes']['SIZE'] == 'cover')
            $img_array[++$i] = $img_data['attributes']['URL'];
    }
    else if ($type == 'WALLPAPER') {
        if ($img_data['tag'] == 'IMAGE' && $img_data['attributes']['SIZE'] == 'thumb' && $prev_tag['tag'] == 'BACKDROP')
            $img_array[++$i] = $img_data['attributes']['URL'];
    }
    $prev_tag = $img_data;
}
?>
<head>
    <title>Edit Image</title>
    <script type="text/javascript" src="../_js/imageflow/imageflow.js"></script>
    <link rel="stylesheet" href="../_js/imageflow/imageflow.packed.css" type="text/css"/>

</head>
<body style="background-color:#000;width:100%; height:100%; margin:0px; padding:0px; overflow:hidden;"
      onkeydown="checkKey();">
<div id="imageFlow" class="imageflow">
<?php
    for ($j = 0; $j < count($img_array); $j++) {
    print("<img src='" . $img_array[$j] . "' longdesc='" . $img_array[$j] . "' />\n");
}
    ?>
</div>
<SCRIPT TYPE="text/javascript">
    var imageFlow = new ImageFlow();
    imageFlow.init({ ImageFlowID: 'imageFlow',
        imageFocusM: 1.5,
<?php
    if ($type == 'WALLPAPER')
        print("aspectRatio: 3.0,\n");
    ?>
    onClick: function() {
        parent.setImage(this.url, '<?php echo $type;?>');
    } });
</script>
</body>
