<?php
// +-----------------------------------------------------------------------+
// |                                                                       |
// | THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   |
// | "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     |
// | LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR |
// | A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  |
// | OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, |
// | SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT      |
// | LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, |
// | DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY |
// | THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   |
// | (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE |
// | OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  |
// |                                                                       |
// +-----------------------------------------------------------------------+

if (is_readable("_include/functions.php"))
    include "_include/functions.php";
else
    include "functions.php";

global $tmpdir, $timezone_offset, $utildir;
global $download_db;
ini_set("session.save_path", $tmpdir);
session_start();

//XML HEADER

//include XML Header (as response will be in xml format)
if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
    header("Content-type: application/xhtml+xml");
} else {
    header("Content-type: text/xml");
}
print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
?>

<?php
if (isset($_GET['xml']) && $_GET['xml'] == 'IMDBform') {
    print("<items>\n");
    print("<item type='settings' position='absolute' labelWidth='400' inputWidth='420' width='400'/>\n");
    print("<item type='label' labelWidth='100' labelLeft='220' labelTop='10' label='Title:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;'/>\n");
    print("<item type='input' name='TITLE' inputLeft='335' inputTop='10' inputWidth='300' style='height: 24px;' readonly='1'/>\n");
    print("<item type='label' labelWidth='100' labelLeft='645' labelTop='10' label='Certification:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='select' name='PARENTAL_RATING' inputLeft='755' inputTop='10' inputWidth='90' style='height: 24px;' disabled='true'/>\n");
    print("<item type='imgbutton' title='Refresh Parental Rating' name='refreshParentalRating' inputWidth='24' inputLeft='850' inputTop='10' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='label' labelWidth='80' labelLeft='875' labelTop='10' label='Released:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;'/>\n");
    print("<item type='calendar' dateFormat='%Y-%m-%d' serverDateFormat='%Y-%m-%d' name='RELEASE_DATE' inputLeft='965' inputTop='10' inputWidth='120' style='height: 24px;' readonly='1' value='' />\n");
    print("<item type='imgbutton' title='Refresh Release Date' name='refreshReleaseDate' inputWidth='24' inputLeft='1090' inputTop='10' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='image' name='THUMBNAIL' labelTop='10' labelWidth='100' labelHeight='148' style='font-weight:normal;border-style: solid; border-color: white;border-width:1px;background-size: 100%;color:white;' src='_img/no-poster.jpg' href='javascript:editImage(\"THUMBNAIL\");' title='Click here to change the Thumbnail'/>\n");
    print("<item type='image' name='DETAIL_POSTER' labelTop='10' labelLeft='112' labelWidth='100' labelHeight='148' style='font-weight:normal;border-style: solid; border-color: white;border-width:1px;background-size: 100%;' src='_img/no-poster.jpg'  href='javascript:editImage(\"DETAIL_POSTER\");' title='Click here to change the Detail Poster'/>\n");
    print("<item type='image' name='WALLPAPER' labelTop='170' labelWidth='212' labelHeight='119' style='font-weight:normal;border-style: solid; border-color: white;border-width:1px;background-size: 100%;' src='_img/no-fanart.jpg' href='javascript:editImage(\"WALLPAPER\");' title='Click here to change the Wallpaper'/>\n");
    print("<item type='label' labelWidth='100' labelLeft='220' labelTop='50' label='Synopsis:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;'/>\n");
    print("<item type='input' name='CONTENT' inputTop='50' inputLeft='335' inputWidth='580' rows='4' readonly='1'/>\n");
    print("<item type='imgbutton' title='Refresh Synopsis' name='refreshSynopsis' inputWidth='24' inputLeft='920' inputTop='60' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='label' labelWidth='100' labelLeft='220' labelTop='135' label='IMDb ID:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='input' name='TTID' inputLeft='335' inputTop='135' inputWidth='80' style='height: 24px;' readonly='1'/>\n");
    print("<item type='label' labelWidth='100' labelLeft='435' labelTop='135' label='Show Type:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='select' name='SHOW_TYPE' inputLeft='545' inputTop='135' inputWidth='120' style='height: 24px;' disabled='true'/>\n");
    print("<item type='label' labelWidth='80' labelLeft='665' labelTop='135' label='Sort Key:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='select' name='NAME' inputLeft='755' inputTop='135' inputWidth='120' style='height: 24px;' disabled='true' />\n");
    print("<item type='block' name='genregrid' inputWidth='120' inputLeft='335' inputTop='175' style='height:88px;position:absolute;overflow:hidden;'/>\n");
    print("<item type='imgbutton' title='Add Genre' name='addGenre' inputWidth='24' inputLeft='460' inputTop='180' image='_img/add_24.png' imagedis='_img/add_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Refresh Genre' name='refreshGenre' inputWidth='24' inputLeft='460' inputTop='210' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Remove Genre' name='removeGenre' inputWidth='24' inputLeft='460' inputTop='240' image='_img/remove_24.png' imagedis='_img/remove_24_dis.png' style='position:absolute;' />\n");
    print("<item type='block' name='keywordgrid' inputWidth='120' inputLeft='545' inputTop='175' style='height:88px;position:absolute;overflow:hidden;'/>\n");
    print("<item type='imgbutton' title='Add Keyword' name='addKeyword' inputWidth='24' inputLeft='670' inputTop='180' image='_img/add_24.png' imagedis='_img/add_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Refresh Keyword' name='refreshKeyword' inputWidth='24' inputLeft='670' inputTop='210' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Remove Keyword' name='removeKeyword' inputWidth='24' inputLeft='670' inputTop='240' image='_img/remove_24.png' imagedis='_img/remove_24_dis.png' style='position:absolute;' />\n");
    print("<item type='block' name='castgrid' inputWidth='120' inputLeft='755' inputTop='175' style='height:88px;position:absolute;overflow:hidden;'/>\n");
    print("<item type='imgbutton' title='Add Cast' name='addCast' inputWidth='24' inputLeft='880' inputTop='180' image='_img/add_24.png' imagedis='_img/add_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Refresh Cast' name='refreshCast' inputWidth='24' inputLeft='880' inputTop='210' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Remove Cast' name='removeCast' inputWidth='24' inputLeft='880' inputTop='240' image='_img/remove_24.png' imagedis='_img/remove_24_dis.png' style='position:absolute;' />\n");
    print("<item type='block' name='directorgrid' inputWidth='120' inputLeft='965' inputTop='175' style='height:88px;position:absolute;overflow:hidden;'/>\n");
    print("<item type='imgbutton' title='Add Director' name='addDirector' inputWidth='24' inputLeft='1090' inputTop='180' image='_img/add_24.png' imagedis='_img/add_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Refresh Director' name='refreshDirector' inputWidth='24' inputLeft='1090' inputTop='210' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Remove Director' name='removeDirector' inputWidth='24' inputLeft='1090' inputTop='240' image='_img/remove_24.png' imagedis='_img/remove_24_dis.png' style='position:absolute;' />\n");
    print("<item type='block' name='subgrid' inputWidth='120' inputLeft='965' inputTop='53' style='height:88px;position:absolute;overflow:hidden;'/>\n");
    print("<item type='imgbutton' title='Add Subtitle' name='addSubtitle' inputWidth='24' inputLeft='1090' inputTop='60' image='_img/add_24.png' imagedis='_img/add_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Refresh Subtitle' name='refreshSubtitle' inputWidth='24' inputLeft='1090' inputTop='90' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='imgbutton' title='Remove Subtitle' name='removeSubtitle' inputWidth='24' inputLeft='1090' inputTop='120' image='_img/remove_24.png' imagedis='_img/remove_24_dis.png' style='position:absolute;' />\n");
    print("<item type='label' labelWidth='100' labelLeft='220' labelTop='275' label='Search String:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;'/>\n");
    print("<item type='input' name='SEARCH_TITLE' inputLeft='335' inputTop='275' inputWidth='300' style='height: 24px;' readonly='1'/>\n");
    print("<item type='label' labelWidth='100' labelLeft='220' labelTop='305' label='Movie Name:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;'/>\n");
    print("<item type='label' name='PATH' labelLeft='335' labelTop='304' labelWidth='800' style='height: 24px;border:0px;background-color:#000;color: #87a418;'/>\n");
    print("<item type='label' name='season_label' labelWidth='100' labelLeft='1085' labelTop='10' label='Season:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='input' name='SEASON' inputLeft='1195' inputTop='10' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='label' name='episode_label' labelWidth='100' labelLeft='1085' labelTop='50' label='Episode:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='input' name='EPISODE' inputLeft='1195' inputTop='50' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='label' name='total_label' labelWidth='100' labelLeft='1085' labelTop='90' label='Total:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='input' name='TOTAL_ITEM' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='label' labelWidth='100' labelLeft='645' labelTop='275' label='Rating:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='input' name='RATING' inputLeft='755' inputTop='275' inputWidth='90' style='height: 24px;' readonly='1'/>\n");
    print("<item type='imgbutton' title='Refresh Rating' name='refreshRating' inputWidth='24' inputLeft='850' inputTop='275' image='_img/refresh_24.png' imagedis='_img/refresh_24_dis.png' style='position:absolute;' />\n");
    print("<item type='hidden' name='DRIVE_PATH' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='GENRE_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='DIRECTOR_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='CAST_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='SUBTITLE_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='LANGUAGE' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='KEYWORD_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='MEDIAINFO_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='SYNOPSIS_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='VIDEO_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='SHOW_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='POSTER_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='THUMBNAIL_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='WALLPAPER_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='GROUPS_CHANGED' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='FPS' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='VIDEO_CODEC' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='WIDTH' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='HEIGHT' inputLeft='1195' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='RESOLUTION' inputLeft='1175' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='SYSTEM' inputLeft='1175' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='ASPECT_RATIO' inputLeft='1175' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='SIZE' inputLeft='1175' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='CREATE_TIME' inputLeft='1175' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("<item type='hidden' name='RUNTIME' inputLeft='1175' inputTop='90' inputWidth='40' style='height: 24px;'/>\n");
    print("</items>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'editVAform') {
    print('<items>');
    print('<item type="settings" position="absolute" labelWidth="400" inputWidth="420"/> ');
    print("<item type='label' name='label' labelWidth='50' labelLeft='20' labelTop='20' label='Genre:' style='text-align: right; font: 14px/14px \"Arial\", sans-serif;color: #6e6e6e;;'/>\n");
    print("<item type='combo' name='myCombo' inputLeft='100' inputTop='20' inputWidth='150' style='height: 20px;'>\n");
    print("<option text='' value=''/>\n");
    print('</item>');
    print('<item type="separator" inputLeft="-20" labelTop="70" inputTop="70" inputWidth="400"/> ');
    print('</items>');
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getComboData') {
    if (isset($_GET['source']))
        $drivepath = $_GET["source"];
    else
        $drivepath = LastBrowsed();

    if (isset($_GET['version']))
        $version = $_GET['version'];
    else
        $version = '1.8.0';

    print("<complete>\n");
    $dbh = new PDO('sqlite:' . $drivepath . 'nmj_database/media.db');

    if ($_GET["type"] == "Genre") {
        if ($version == '1.8.0') {
            $sql = 'SELECT DISTINCT VALUE FROM VIDEO_ATTR WHERE TYPE="GENRE" ';
            if (isset($_GET['mask']) && $_GET['mask'] != '')
                $sql .= ' AND VALUE LIKE "' . $_GET['mask'] . '%"';
            $sql .= ' ORDER BY VALUE';
            $id = 'VALUE';
        }
        else {
            $sql = 'SELECT DISTINCT NAME FROM VIDEO_GENRES ';
            if (isset($_GET['mask']) && $_GET['mask'] != '')
                $sql .= ' WHERE NAME LIKE "' . $_GET['mask'] . '%"';
            $sql .= ' ORDER BY NAME';
            $id = 'NAME';
        }
    }
    else if ($_GET["type"] == "MPAA") {
        if ($version == '1.8.0') {
            $sql = 'SELECT DISTINCT PARENTAL_RATING FROM VIDEO_GROUP WHERE SHOW_ID!="NULL"';
            if (isset($_GET['mask']))
                $sql .= ' AND PARENTAL_RATING LIKE "' . $_GET['mask'] . '%"';
            $sql .= ' ORDER BY PARENTAL_RATING';
            $id = 'PARENTAL_RATING';
        }
        else {
            $sql = 'SELECT DISTINCT PARENTAL_CONTROL FROM SHOWS WHERE SHOWS_ID!=""';
            if (isset($_GET['mask']))
                $sql .= ' AND PARENTAL_CONTROL LIKE "' . $_GET['mask'] . '%"';
            $sql .= ' ORDER BY PARENTAL_CONTROL';
            $id = 'PARENTAL_CONTROL';
        }
    }
    else if ($_GET["type"] == "Keyword") {
        if ($version == '1.8.0') {
            $sql = 'SELECT DISTINCT VALUE FROM VIDEO_ATTR WHERE TYPE="KEYWORD"';
            if (isset($_GET['mask']))
                $sql .= ' AND VALUE LIKE "' . $_GET['mask'] . '%"';
            $sql .= ' ORDER BY VALUE LIMIT  0,50 ';
            $id = 'VALUE';
        }
        else {
            $sql = 'SELECT DISTINCT KEYWORD FROM KEYWORDS';
            if (isset($_GET['mask']))
                $sql .= ' WHERE KEYWORD LIKE "' . $_GET['mask'] . '%"';
            $sql .= ' ORDER BY KEYWORD LIMIT  0,50 ';
            $id = 'KEYWORD';
        }
    }
    else if ($_GET["type"] == "Cast" || $_GET["type"] == "Director") {
        if ($version == '1.8.0') {
            $sql = 'SELECT DISTINCT NAME FROM VIDEO_PERSON';
            if (isset($_GET['mask']))
                $sql .= ' WHERE NAME LIKE "' . $_GET['mask'] . '%"';
            $sql .= ' ORDER BY NAME LIMIT  0,50 ';
            $id = 'NAME';
        }
        else {
            $sql = 'SELECT DISTINCT NAME FROM VIDEO_PERSONS';
            if (isset($_GET['mask']))
                $sql .= ' WHERE NAME LIKE "' . $_GET['mask'] . '%"';
            $sql .= ' ORDER BY NAME LIMIT  0,50 ';
            $id = 'NAME';
        }
    }

    foreach ($dbh->query($sql) as $combo) {
        print("<option value='" . $combo[$id] . "'><![CDATA[" . $combo[$id] . "]]></option>\n");
    }
    $dbh = NULL;
    print("</complete>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getTTdata') {
    $imdbid = $_GET["imdbid"];
    if (isset($_GET['datasource']))
        $datasource = $_GET['datasource'];
    else
        $datasource = "imdb";

    if ($datasource == 'imdb')
        $nmj_data = getIMDBdata($imdbid);
    else if ($datasource == 'tmdb')
        $nmj_data = getTMDBdata($imdbid);

    print("<data>\n");
    foreach ($nmj_data as $key => $value)
        print("<" . $key . "><![CDATA[" . $value . "]]></" . $key . ">\n");
    print("<ERROR>0</ERROR>\n");
    print("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'searchIMDB') {
    $search_title = $_GET['search_title'];

    $result = searchIMDB($search_title);
    print("<data>\n");
    $count = preg_match("|tt\d{7}|isU", $result, $output);
    if ($result == "No Matches") {
        print("<ERROR>1</ERROR>\n");
        print("<message><![CDATA[No valid match found in IMDb.]]></message>\n");
    }
    else if ($count == 1) {
        $nmj_data = getIMDBdata($result);
        foreach ($nmj_data as $key => $value)
            print("<" . $key . "><![CDATA[" . $value . "]]></" . $key . ">\n");
        print("<ERROR>0</ERROR>\n");
    }
    else {
        $html_data = arraytoHTML($result);
        print("<ERROR>2</ERROR>\n");
        print("<message><![CDATA[" . $html_data . "]]></message>\n");
    }
    print("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'searchTMDB') {
    $search_title = $_GET['search_title'];
    $APIKEY = "b626260be86175272e48fa6347e58100";

    print("<data>\n");
    $command = "wget 'http://api.themoviedb.org/2.1/Movie.search/en/xml/" . $APIKEY . "/" . $search_title . "' -qO-";
    $data = shell_exec($command);
    $xml_parser = xml_parser_create();
    xml_parse_into_struct($xml_parser, $data, $vals, $index);
    xml_parser_free($xml_parser);
    if ($vals[3]['value'] == 1) {
        foreach ($vals as $tmdb_data) {
            if ($tmdb_data['tag'] == 'ID')
                $nmj_data['TTID'] = $tmdb_data['value'];
            else if ($tmdb_data['tag'] == 'NAME')
                $nmj_data['TITLE'] = $tmdb_data['value'];
            else if ($tmdb_data['tag'] == 'OVERVIEW')
                $nmj_data['CONTENT'] = $tmdb_data['value'];
            else if ($tmdb_data['tag'] == 'RATING')
                $nmj_data['RATING'] = $tmdb_data['value'];
            else if ($tmdb_data['tag'] == 'CERTIFICATION')
                $nmj_data['PARENTAL_RATING'] = $tmdb_data['value'];
            else if ($tmdb_data['tag'] == 'RELEASED')
                $nmj_data['RELEASE_DATE'] = $tmdb_data['value'];
            else if ($tmdb_data['tag'] == 'KEYWORD')
                $keyword[] = $tmdb_data['attributes']['NAME'];
            else if ($tmdb_data['tag'] == 'PERSON' && $tmdb_data['attributes']['JOB'] == 'Director')
                $director[] = $tmdb_data['attributes']['NAME'];
            else if ($tmdb_data['tag'] == 'PERSON')
                $cast[] = $tmdb_data['attributes']['NAME'];
        }
        if (isset($keyword))
            $nmj_data['KEYWORD'] = implode("#", $keyword);
        if (isset($cast))
            $nmj_data['CAST'] = implode("#", $cast);
        if (isset($director))
            $nmj_data['DIRECTOR'] = implode("#", $director);
        $nmj_data['SHOW_TYPE'] = 3;
        print("<ERROR>0</ERROR>\n");
    }
    else if ($vals[3]['value'] > 1) {
        $html_data = '<h3>Search results for "' . $search_title . '"</h3> ';
        $count = 0;
        foreach ($vals as $tmdb_data) {
            if ($tmdb_data['tag'] == 'NAME')
                $movie[$count] = array_push_assoc($movie[$count], "NAME", $tmdb_data['value']);
            if ($tmdb_data['tag'] == 'ALTERNATIVE_NAME')
                $movie[$count] = array_push_assoc($movie[$count], "ALTERNATIVE_NAME", $tmdb_data['value']);
            if ($tmdb_data['tag'] == 'ID')
                $movie[$count] = array_push_assoc($movie[$count], "ID", $tmdb_data['value']);
            if ($tmdb_data['tag'] == 'IMAGE' && $tmdb_data['attributes']['SIZE'] == 'thumb' && $tmdb_data['attributes']['TYPE'] == 'poster')
                $movie[$count] = array_push_assoc($movie[$count], "URL", $tmdb_data['attributes']['URL']);
            if ($tmdb_data['tag'] == 'RELEASED')
                $movie[$count] = array_push_assoc($movie[$count], "RELEASED", $tmdb_data['value']);
            if ($tmdb_data['tag'] == 'MOVIE' && $tmdb_data['type'] == 'close')
                $count++;
        }
        $html_data .= arraytoHTML($movie);
        print("<ERROR>2</ERROR>\n");
        print("<message><![CDATA[" . $html_data . "]]></message>\n");
    }
    else {
        print("<ERROR>1</ERROR>\n");
        print("<message>Nothing found.</message>\n");
    }
    foreach ($nmj_data as $key => $value)
        print("<" . $key . "><![CDATA[" . $value . "]]></" . $key . ">\n");

    print("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getAllImages') {
    $imdbid = $_GET['imdbid'];

    $image_data = getImageFromTMDB($imdbid);
    print("<data>\n");
    print("<ERROR>0</ERROR>\n");
    print("<THUMBNAIL>" . $image_data['poster'][0] . "</THUMBNAIL>\n");
    print("<DETAIL_POSTER>" . $image_data['poster'][0] . "</DETAIL_POSTER>\n");
    print("<WALLPAPER>" . $image_data['wallpaper'][0] . "</WALLPAPER>\n");
    print("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMediaInfo') {
    if (isset($_GET['source']))
        $drivepath = $_GET["source"];
    else
        $drivepath = LastBrowsed();

    $media = $_GET['media'];

    print("<data>\n");
    print("<ERROR>0</ERROR>\n");
    $media_data = getMediaInfo($drivepath, $media);
    foreach ($media_data as $key => $value)
        print("<" . $key . "><![CDATA[" . $value . "]]></" . $key . ">\n");
    print("</data>\n");
} else if (isset ($_GET['xml']) && $_GET['xml'] == 'getDVTree') {
    $ratings = array("0-1","1-2","2-3","3-4","4-5","5-6","6-7","7-8","8-9","9-10");
    if (isset($_GET['source']))
        $drivepath = $_GET["source"];
    else
        $drivepath = LastBrowsed();

    if (isset($_GET['version']))
        $version = $_GET['version'];
    else
        $version = '1.8.0';

    $dbh = new PDO('sqlite:' . $drivepath . 'nmj_database/media.db');
    if ($_GET['type'] == 'Genre') {
        if ($version == '1.8.0') {
            $sql = 'SELECT DISTINCT VALUE FROM VIDEO_ATTR WHERE TYPE="GENRE" ';
            $sql .= ' ORDER BY VALUE';
            $id = 'VALUE';
        }
        else {
            $sql = 'SELECT DISTINCT NAME FROM VIDEO_GENRES ';
            $sql .= ' ORDER BY NAME';
            $id = 'NAME';
        }
    }
    else if ($_GET['type'] == 'Movie') {
        if ($version == '1.8.0')
            $sql = 'SELECT NAME FROM VIDEO_GROUP_NAME ORDER BY NAME';
        else
            $sql = 'SELECT NAME FROM SHOW_GROUPS ORDER BY NAME';
        $id = 'NAME';
    }
    else if ($_GET['type'] == 'ParentalRating') {
        if ($version == '1.8.0')
            $sql = 'SELECT DISTINCT PARENTAL_RATING FROM VIDEO_GROUP WHERE SHOW_ID!="NULL"';
        else
            $sql = 'SELECT DISTINCT PARENTAL_CONTROL AS PARENTAL_RATING FROM SHOWS ORDER BY PARENTAL_CONTROL';
        $id = 'PARENTAL_RATING';
    }
    else if ($_GET['type'] == 'ReleaseDate') {
        if ($version == '1.8.0')
            $sql = 'SELECT DISTINCT substr(RELEASE_DATE,0,4) FROM SHOW ORDER BY RELEASE_DATE';
        else
            $sql = 'SELECT DISTINCT substr(RELEASE_DATE,0,4) FROM SHOWS ORDER BY RELEASE_DATE';
        $id = 'substr(RELEASE_DATE,0,4)';
    }
    else if ($_GET['type'] == 'Director') {
        if ($version == '1.8.0') {
            $sql = 'SELECT DISTINCT VALUE FROM VIDEO_ATTR WHERE TYPE="DIRECTOR" ';
            $sql .= ' ORDER BY VALUE';
            $id = 'VALUE';
        }
        else {
            $sql = 'SELECT DISTINCT SHOWS_PERSONS.PERSONS_ID,VIDEO_PERSONS.NAME ';
            $sql.= 'FROM SHOWS_PERSONS,VIDEO_PERSONS WHERE ';
            $sql.= 'SHOWS_PERSONS.PERSON_TYPE="DIRECTOR" AND ';
            $sql.= 'VIDEO_PERSONS.ID=SHOWS_PERSONS.PERSONS_ID ';
            $sql.= 'ORDER BY VIDEO_PERSONS.NAME';
            $id = 'NAME';
        }
    }
    print("<tree id='0'>\n");
    print("<item text='All " . $_GET['type'] . "s' id='All " . $_GET['type'] . "s' child='1' im0='folderClosed.gif' im1='folderOpen.gif' im2='folderClosed.gif' select='1' open='1'>\n");
    if ($_GET['type'] != 'Rating') {
        foreach ($dbh->query($sql) as $value) {
            if ($value[$id] == '') $value[$id] = 'BLANK';
                    print("<item text='" . $value[$id] . "' id='" . $value[$id] . "' child='0' im0='folderClosed.gif' im1='folderOpen.gif' im2='folderClosed.gif'></item>\n");
        }
    }
    else {
        foreach ($ratings as $rating)
            print("<item text='" . $rating . "' id='" . $rating . "' child='0' im0='folderClosed.gif' im1='folderOpen.gif' im2='folderClosed.gif'></item>\n");
    }
    $dbh = NULL;
    print ("</item>\n");
    print ("</tree>\n");
} else if (isset ($_GET['xml']) && $_GET['xml'] == 'getDirTree') {
    echo "<tree id=\"0\">\n";

    echo "<item text='My Device' id='topnode' child='1' im0='popcorn.png' im1='popcorn.png' im2='popcorn.png' select='1' open='1'>\n";
    if (php_uname('s') != "SunOS")
        $result = shell_exec("mount|grep -v sigm");
    else
        $result = file_get_contents($datadir . "/.devices");

    $count = preg_match_all("|/(.*) on /(.*) |Ui", $result, $drive_data);

    for ($i = 0; $i < count($drive_data[0]); $i++) {
        $drive = explode(" ", $drive_data[0][$i]);
        print('<item text="' . basename($drive[2]) . ' on ' . dirname($drive[2]) . '" id="' . $drive[2] . '/" child="1" im0="drive.png" im1="drive.png" im2="drive.png"/>\n');
    }
    print ("</item>\n");
    print ("</tree>\n");
} else if (isset($_GET["id"]) && $_GET["id"] != "topnode") {
    $id = $_GET["id"];
    $fileFullPath = $id;
    print('<tree id="' . htmlspecialchars($id) . '">' . "\n");

    $files = scan_dir($fileFullPath);
    if ($files != false && count($files) > 0) {
        foreach ($files as $file) {
            $dirFullPath = $fileFullPath . $file;
            if (is_dir($dirFullPath)) {
                if ($file == "." || $file == "..") {
                    //output item
                }
                else {
                    $no_dir = 0;
                    $subfiles = scan_dir($dirFullPath);
                    if ($subfiles != false && count($subfiles) > 0) {
                        foreach ($subfiles as $subfile) {
                            $subdirFullPath = $dirFullPath . '/' . $subfile;
                            if (is_dir($subdirFullPath))
                                $no_dir++;
                        }
                    }
                    if ($no_dir > 2)
                        $child = 1;
                    else
                        $child = 0;
                    print('<item text="' . htmlspecialchars($file) . '" id="' . htmlspecialchars($dirFullPath) . '/" child="' . $child . '" im0="folderClosed.gif" im1="folderOpen.gif" im2="folderClosed.gif"></item>' . "\n");
                }
            }
        }
    }
    print ("</tree>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'dirBrowseform') {
    print('<items><item type="settings" position="absolute" inputWidth="420" inputHeight="350" />');
    print('<item type="label" labelWidth="250" label="Select A Drive To Open NMJ Database..." style="font-weight:normal;"/>');
    print("<item type='block' name='treeBox' inputWidth='320' inputTop='25' style='width:300;height:250;background-color:white;border:1px solid #727272;margin:2px 2px 2px 7px;overflow: hidden;'/>\n");
    print('<item type="separator" inputLeft="-20" labelTop="70" inputTop="300" inputWidth="500"/></items>');
} else if (isset($_GET['xml']) && ($_GET['xml'] == 'updateGenre' || $_GET['xml'] == 'updateKeyword'
                                           || $_GET['xml'] == 'updateDirector' || $_GET['xml'] == 'updateSynopsis'
                                           || $_GET['xml'] == 'updateCast' || $_GET['xml'] == 'updateReleaseDate'
                                           || $_GET['xml'] == 'updateParentalRating' || $_GET['xml'] == 'updateRating')
        ) {
    if (isset($_GET['imdbid']))
        $imdbid = $_GET["imdbid"];

    if (isset($_GET['media']))
        $media = $_GET["media"];

    if (isset($_GET['showid']))
        $showid = $_GET["showid"];

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];
    else
        $drivepath = LastBrowsed();

    if (isset($_GET['datasource']))
        $datasource = $_GET['datasource'];
    else
        $datasource = "imdb";

    if ($datasource == 'imdb')
        $nmj_data = getIMDBdata($imdbid);
    else if ($datasource == 'tmdb')
        $nmj_data = getTMDBdata($imdbid);

    print("<data>\n");
    print("<ERROR>0</ERROR>\n");
    if ($_GET['xml'] == 'updateGenre')
        print("<GENRE><![CDATA[" . $nmj_data['GENRE'] . "]]></GENRE>\n");
    else if ($_GET['xml'] == 'updateKeyword')
        print("<KEYWORD><![CDATA[" . $nmj_data['KEYWORD'] . "]]></KEYWORD>\n");
    else if ($_GET['xml'] == 'updateCast')
        print("<CAST><![CDATA[" . $nmj_data['CAST'] . "]]></CAST>\n");
    else if ($_GET['xml'] == 'updateDirector')
        print("<DIRECTOR><![CDATA[" . $nmj_data['DIRECTOR'] . "]]></DIRECTOR>\n");
    else if ($_GET['xml'] == 'updateSynopsis')
        print("<CONTENT><![CDATA[" . $nmj_data['CONTENT'] . "]]></CONTENT>\n");
    else if ($_GET['xml'] == 'updateReleaseDate')
        print("<RELEASE_DATE><![CDATA[" . $nmj_data['RELEASE_DATE'] . "]]></RELEASE_DATE>\n");
    else if ($_GET['xml'] == 'updateParentalRating')
        print("<PARENTAL_RATING><![CDATA[" . $nmj_data['PARENTAL_RATING'] . "]]></PARENTAL_RATING>\n");
    else if ($_GET['xml'] == 'updateRating')
        print("<RATING><![CDATA[" . $nmj_data['RATING'] . "]]></RATING>\n");
    print("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMovies') {
    //define variables from incoming values
    if (isset($_GET["start"]))
        $posStart = $_GET['start'];
    else
        $posStart = 0;

    if (isset($_GET["count"]))
        $count = $_GET['count'];
    else
        $count = 20;

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];
    else
        $drivepath = LastBrowsed();

    if (isset($_GET['dhx_filter']))
        $filters = $_GET['dhx_filter'];

    if (isset($_GET['dhx_no_header']))
        $no_header = $_GET['dhx_no_header'];

    if (isset($_GET['version']))
        $version = $_GET['version'];

    if (file_exists($drivepath . 'nmj_database/media.db')) {
        if ($drivepath != LastBrowsed())
            SetLastBrowsed($drivepath);
        $dbh = new PDO('sqlite:' . $drivepath . 'nmj_database/media.db');
        shell_exec("cd " . $homedir . "../; ln -s " . $drivepath . " .");

        if (!isset($version)) {
            $sql = 'SELECT VERSION FROM DB_VERSION ';
            $result = DBQuery($dbh, $sql);
            $version = $result->fetchColumn();
        }

        if ($posStart == 0) {
            if ($version == '1.8.0')
                $sql = 'SELECT COUNT(*) FROM SHOW WHERE SHOW_TYPE!=0';
            else
                $sql = 'SELECT COUNT(*) FROM SHOWS WHERE TITLE_TYPE != 2 AND TITLE_TYPE !=3 AND TITLE_TYPE!=5';
            $result = DBQuery($dbh, $sql);
            $totalCount = $result->fetch();
            if ($version == '1.8.0')
                $sql = 'SELECT NAME FROM VIDEO_GROUP_NAME ORDER BY NAME';
            else
                $sql = 'SELECT NAME FROM SHOW_GROUPS ORDER BY NAME';
            $count=0;
            foreach ($dbh->query($sql) as $newrow)
                $vg_names[$count++] = $newrow[0];

            $count=0;
            if ($version == '1.8.0')
                $sql = 'SELECT DISTINCT PARENTAL_RATING FROM VIDEO_GROUP ORDER BY PARENTAL_RATING';
            else
                $sql = 'SELECT DISTINCT PARENTAL_CONTROL FROM SHOWS ORDER BY PARENTAL_CONTROL';
            foreach ($dbh->query($sql) as $newrow)
                $pr_names[$count++] = $newrow[0];
        }
        else
            $totalCount[0] = 0;

        if ($version == '1.8.0')
            $sql = 'SELECT SHOW_ID FROM SHOW ';
        else
            $sql = 'SELECT ID AS SHOW_ID FROM SHOWS ';

        $i = 0;
        if ($version == '1.8.0')
            $filt[$i++] = ' SHOW_TYPE != 0';
        else
            $filt[$i++] = ' TITLE_TYPE != 2 AND TITLE_TYPE !=3 AND TITLE_TYPE!=5';
        if (isset($filters)) {
            foreach ($filters as $key => $filter) {
                if ($filter != '') {
                    if ($key == 0)
                        $filt[$i++] = ' TITLE LIKE "%' . $filter . '%" ';
                    else if ($key == 4)
                        if ($version == '1.8.0')
                            $filt[$i++] = ' RELEASE_DATE LIKE "%' . $filter . '%" ';
                        else
                            $filt[$i++] = ' YEAR LIKE "' . $filter . '%" ';
                    else if ($key == 11)
                        if ($version == '1.8.0')
                            $filt[$i++] = ' PARENTAL_RATING LIKE "' . $filter . '%" ';
                        else
                            $filt[$i++] = ' PARENTAL_CONTROL LIKE "' . $filter . '%" ';
                }
            }
        }
        if (isset($filt))
            $sql .= " WHERE " . implode(" AND ", $filt);

        $sql .= ' LIMIT ' . $posStart . ',' . $count;
        print("<data pos='" . $posStart . "' total_count='" . $totalCount[0] . "'>\n");
        foreach ($dbh->query($sql) as $show_row) {
            $nmj_data = loadNMJData($dbh, $show_row['SHOW_ID'], $drivepath, $version);

            // Print XML
            print('    <item id="' . $nmj_data['VIDEO_ID'] . '">' . "\n");
            foreach ($nmj_data as $key => $value) {
                if ($key == 'CONTENT')
                    $value = html_entity_decode(str_replace('&apos;', '&#39;', $value), ENT_QUOTES);
                else if ($key == 'TITLE' || $key == 'SEARCH_TITLE')
                    $value = htmlspecialchars_decode($value);
                else if ($key == 'THUMBNAIL' || $key == 'WALLPAPER' || $key == 'DETAIL_POSTER')
                    $value = ($value) ? basename($drivepath) . '/' . $value : $value;
                print("        <" . $key . "><![CDATA[" . $value . "]]></" . $key . ">\n");
            }
            if (isset($vg_names))
                print("<VG_NAMES><![CDATA[" . htmlspecialchars(implode(",", $vg_names)) . "]]></VG_NAMES>\n");
            if (isset($pr_names))
                print("<PR_NAMES><![CDATA[" . htmlspecialchars(implode(",", $pr_names)) . "]]></PR_NAMES>\n");
            print("    </item>\n");

        }
        print("</data>\n");
    }
    else {
        print("<data>\n");
        print("</data>\n");
    }
    // close the database connection
    $dbh = NULL;
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getDataView') {
    //define variables from incoming values
    if (isset($_GET["posStart"]))
        $posStart = $_GET['posStart'];
    else
        $posStart = 0;

    if (isset($_GET["count"]))
        $count = $_GET['count'];
    else
        $count = 40;

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];
    else
        $drivepath = LastBrowsed();

    if (isset($_GET['version']))
        $version = $_GET['version'];
    else
        $version = '1.8.0';

    if (file_exists($drivepath . 'nmj_database/media.db')) {
        $dbh = new PDO('sqlite:' . $drivepath . 'nmj_database/media.db');

        if ($posStart == 0) {
            if ($_GET['type'] == 'Genre' && $_GET['tid'] != "Genre") {
                if ($version == '1.8.0') {
                    $sql = 'SELECT COUNT(*) FROM VIDEO_ATTR WHERE TYPE="GENRE" AND ';
                    $sql.= 'VALUE="' . $_GET['tid'] . '" AND SHOW_ID!=""';
                }
                else {
                    $sql = 'SELECT COUNT(SHOWS_GENRES.SHOWS_ID),VIDEO_GENRES.ID FROM VIDEO_GENRES,';
                    $sql.= 'SHOWS_GENRES WHERE VIDEO_GENRES.NAME="' . $_GET['tid'] . '" ';
                    $sql.= 'AND SHOWS_GENRES.GENRES_ID=VIDEO_GENRES.ID';
                }
            }
            else if ($_GET['type'] == 'Movie' && $_GET['tid'] != "Movie") {
                if ($version == '1.8.0') {
                    $sql = 'SELECT VIDEO_GROUP_NAME_ID FROM VIDEO_GROUP_NAME WHERE NAME="' . $_GET['tid'] . '"';
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);
                    $sql = 'SELECT COUNT(*) FROM VIDEO_GROUP WHERE VIDEO_GROUP_NAME_ID=' . $row['VIDEO_GROUP_NAME_ID'];
                 }
                 else {
                    $sql = 'SELECT COUNT(SHOW_GROUPS_SHOWS.SHOWS_ID),SHOW_GROUPS.NAME FROM ';
                    $sql.= 'SHOW_GROUPS_SHOWS,SHOW_GROUPS WHERE ';
                    $sql.= 'SHOW_GROUPS.ID=SHOW_GROUPS_SHOWS.GROUPS_ID AND ';
                    $sql.= 'SHOW_GROUPS.NAME="'.$_GET['tid'].'"';
                 }
            }
            else if ($_GET['type'] == 'ParentalRating' && $_GET['tid'] != "ParentalRating") {
                if ($version == '1.8.0')
                    $sql = 'SELECT COUNT(*) FROM SHOW WHERE PARENTAL_RATING="' . $_GET['tid'] . '"';
                else
                    $sql = 'SELECT COUNT(ID) AS SHOWS_ID FROM SHOWS WHERE PARENTAL_CONTROL="' . $_GET['tid'] . '"';
            }
            else if ($_GET['type'] == 'Rating' && $_GET['tid'] != "Rating") {
                $rating = explode("-",$_GET['tid']);
                if ($version == '1.8.0')
                    $sql = 'SELECT COUNT(*) FROM SHOW WHERE RATING>='.$rating[0].' AND RATING<='.$rating[1];
                else
                    $sql = 'SELECT COUNT(ID) AS SHOWS_ID FROM SHOWS WHERE RATING>='.$rating[0].' AND RATING<='.$rating[1];
            }
            else if ($_GET['type'] == 'ReleaseDate' && $_GET['tid'] != "ReleaseDate") {
                if ($version == '1.8.0')
                    $sql = 'SELECT COUNT(*) FROM SHOW WHERE RELEASE_DATE LIKE "' . $_GET['tid'] . '%"';
                else
                    $sql = 'SELECT COUNT(ID) AS SHOWS_ID FROM SHOWS WHERE RELEASE_DATE LIKE "' . $_GET['tid'] . '%"';
            }
            else if ($_GET['type'] == 'Director' && $_GET['tid'] != "Director") {
                if ($version == '1.8.0')
                    $sql = 'SELECT COUNT(*) FROM VIDEO_ATTR WHERE TYPE="DIRECTOR" AND VALUE="' . $_GET['tid'] . '" AND SHOW_ID!=""';
                else {
                    $sql = 'SELECT COUNT(SHOWS_PERSONS.SHOWS_ID),VIDEO_PERSONS.ID FROM ';
                    $sql.= 'SHOWS_PERSONS,VIDEO_PERSONS WHERE ';
                    $sql.= 'VIDEO_PERSONS.NAME="'.$_GET['tid'].'" AND ';
                    $sql.= 'VIDEO_PERSONS.ID=SHOWS_PERSONS.PERSONS_ID';
                }
            }
            else
                $sql = 'SELECT COUNT(*) FROM SHOW';

            if ($version == '1.8.0')
                $sql .= ' ORDER BY SHOW_ID';
            else
                $sql .= ' ORDER BY SHOWS_ID';
            $result = DBQuery($dbh, $sql);
            $totalCount = $result->fetch();
        }
        else
            $totalCount[0] = 0;

        if ($_GET['type'] == 'Genre' && $_GET['tid'] != "Genre"){
            if ($version == '1.8.0') {
                $sql = 'SELECT SHOW_ID FROM VIDEO_ATTR WHERE TYPE="GENRE" AND ';
                $sql.= 'VALUE="' . $_GET['tid'] . '" AND SHOW_ID!=""';
            }
            else {
                $sql = 'SELECT VIDEO_GENRES.ID,SHOWS_GENRES.SHOWS_ID AS SHOW_ID FROM VIDEO_GENRES,';
                $sql.= 'SHOWS_GENRES WHERE VIDEO_GENRES.NAME="' . $_GET['tid'] . '" ';
                $sql.= 'AND SHOWS_GENRES.GENRES_ID=VIDEO_GENRES.ID';
            }
        }
        else if ($_GET['type'] == 'Movie' && $_GET['tid'] != "Movie") {
            if ($version == '1.8.0') {
                $sql = 'SELECT VIDEO_GROUP_NAME_ID FROM VIDEO_GROUP_NAME WHERE NAME="' . $_GET['tid'] . '"';
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                $sql = 'SELECT SHOW_ID FROM VIDEO_GROUP WHERE VIDEO_GROUP_NAME_ID=' . $row['VIDEO_GROUP_NAME_ID'];
            }
            else {
                $sql = 'SELECT SHOW_GROUPS_SHOWS.SHOWS_ID AS SHOW_ID,SHOW_GROUPS.NAME FROM ';
                $sql.= 'SHOW_GROUPS_SHOWS,SHOW_GROUPS WHERE ';
                $sql.= 'SHOW_GROUPS.ID=SHOW_GROUPS_SHOWS.GROUPS_ID AND ';
                $sql.= 'SHOW_GROUPS.NAME="'.$_GET['tid'].'"';
            }
        }
        else if ($_GET['type'] == 'ParentalRating' && $_GET['tid'] != "ParentalRating") {
            if ($_GET['tid'] == 'BLANK')
                $_GET['tid'] = '';
            if ($version == '1.8.0')
                $sql = 'SELECT SHOW_ID FROM SHOW WHERE PARENTAL_RATING="' . $_GET['tid'] . '"';
            else
                $sql = 'SELECT ID AS SHOW_ID FROM SHOWS WHERE PARENTAL_CONTROL="' . $_GET['tid'] . '"';
        }
        else if ($_GET['type'] == 'Rating' && $_GET['tid'] != "Rating") {
            $rating = explode("-",$_GET['tid']);
            if ($version == '1.8.0')
                $sql = 'SELECT SHOW_ID FROM SHOW WHERE RATING>='.$rating[0].' AND RATING<='.$rating[1];
            else
                $sql = 'SELECT ID AS SHOW_ID FROM SHOWS WHERE RATING>='.$rating[0].' AND RATING<='.$rating[1];
        }
        else if ($_GET['type'] == 'ReleaseDate' && $_GET['tid'] != "ReleaseDate") {
            if ($version == '1.8.0')
                $sql = 'SELECT SHOW_ID FROM SHOW WHERE RELEASE_DATE LIKE "' . $_GET['tid'] . '%"';
            else
                $sql = 'SELECT ID AS SHOW_ID FROM SHOWS WHERE RELEASE_DATE LIKE "' . $_GET['tid'] . '%"';
        }
        else if ($_GET['type'] == 'Director' && $_GET['tid'] != "Director") {
            if ($version == '1.8.0')
                $sql = 'SELECT SHOW_ID FROM VIDEO_ATTR WHERE TYPE="DIRECTOR" AND VALUE="' . $_GET['tid'] . '" AND SHOW_ID!=""';
            else {
                $sql = 'SELECT SHOWS_PERSONS.SHOWS_ID AS SHOW_ID,VIDEO_PERSONS.ID FROM ';
                $sql.= 'SHOWS_PERSONS,VIDEO_PERSONS WHERE ';
                $sql.= 'VIDEO_PERSONS.NAME="'.$_GET['tid'].'" AND ';
                $sql.= 'VIDEO_PERSONS.ID=SHOWS_PERSONS.PERSONS_ID';
            }
        }
        else 
            $sql = 'SELECT SHOW_ID FROM SHOW ';

        $sql .= ' LIMIT ' . $posStart . ',' . $count;
        print("<data pos='" . $posStart . "' total_count='" . $totalCount[0] . "'>\n");
        foreach ($dbh->query($sql) as $show_row) {
            if ($version == '1.8.0') {
                $sql = 'SELECT SHOW_ID, TITLE, THUMBNAIL, RELEASE_DATE ';
                $sql .= 'FROM SHOW WHERE SHOW_ID=' . $show_row['SHOW_ID'];
            }
            else {
                $sql = 'SELECT SHOWS.ID AS SHOW_ID, SHOWS.TITLE, SHOWS.RELEASE_DATE, ';
                $sql .= 'VIDEO_POSTERS.THUMBNAIL FROM SHOWS,VIDEO_POSTERS ';
                $sql .= 'WHERE SHOWS.ID=' . $show_row['SHOW_ID'] .' AND ';
                $sql .= 'VIDEO_POSTERS.ID='.$show_row['SHOW_ID'];
            }
            $result = DBQuery($dbh, $sql);
            $nmj_data = $result->fetch(PDO::FETCH_ASSOC);

            // Print XML
            print('    <item id="' . $nmj_data['SHOW_ID'] . '">' . "\n");
            foreach ($nmj_data as $key => $value) {
                if ($key == 'TITLE')
                    $value = htmlspecialchars_decode($value);
                else if ($key == 'THUMBNAIL')
                    $value = ($value) ? basename($drivepath) . '/' . $value : $value;
                print("        <" . $key . "><![CDATA[" . $value . "]]></" . $key . ">\n");
            }
            print("    </item>\n");

        }
        print("</data>\n");
    }
    else {
        print("<data>\n");
        print("</data>\n");
    }
    // close the database connection
    $dbh = NULL;
} else if (isset($_GET['xml']) && $_GET['xml'] == 'updateMovies') {
    $message = '';
    if (isset($_GET['source']))
        $drivepath = $_GET["source"];
    else
        $drivepath = LastBrowsed();

    if (isset($_POST['ids'])) {
        $ids = $_POST['ids'];
        $nmj_data = array();

        foreach ($_POST as $key => $value) {
            $details = explode("_", $key, 2);
            if (sizeof($details) == 1) continue;
            $name = $details[1];
            $nmj_data[$name] = $value;
        }

        $mode = $nmj_data["!nativeeditor_status"];
        $id = $nmj_data["id"];
        if (is_writable($drivepath . 'nmj_database/media.db')) {
            $dbh = new PDO('sqlite:' . $drivepath . 'nmj_database/media.db');
            //PrintArray($nmj_data);
            switch ($mode) {
                case "inserted":
                    handleNMJData($dbh, $nmj_data, $mode);
                    $action = "insert";
                    break;
                case "updated":
                    handleNMJData($dbh, $nmj_data, $mode);
                    $action = "update";
                    break;
                case "deleted":
                    $nmj_data = loadNMJData($dbh, $id, $drivepath);
                    handleNMJData($dbh, $nmj_data, $mode);
                    $action = "delete";
                    break;
            }
        }
        else {
            $action = "error";
            $message = "Cannot Write on readonly Database.";
        }

        print("<data>\n");
        print('<action type="' . $action . '" sid="' . $id . '" tid="' . $id . '">' . $message . '</action>');
        print("</data>\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'updateDataView') {
    $message = '';
    if (isset($_GET['source']))
        $drivepath = $_GET["source"];
    else
        $drivepath = LastBrowsed();

    if (isset($_GET['type']))
        $type = $_GET["type"];

    if (isset($_GET['mode']))
        $mode = $_GET["mode"];

    if (isset($_GET['ids'])) {
        $ids = $_GET['ids'];

        if (isset($_GET['genre']))
            $genre = $_GET['genre'];

        $showids = explode(",", $ids);

        if (is_writable($drivepath . 'nmj_database/media.db')) {
            $dbh = new PDO('sqlite:' . $drivepath . 'nmj_database/media.db');
            switch ($mode) {
                case "inserted":
                    break;
                case "updated":
                    break;
                case "remove":
                    for ($i = 0; $i < count($showids); $i++) {
                        if ($type == "Genre") {
                            $sql = 'DELETE FROM VIDEO_ATTR WHERE SHOW_ID=' . $showids[$i] . ' AND ';
                            $sql .= 'TYPE="GENRE" AND VALUE="' . $genre . '"';
                            DBQuery($dbh, $sql);
                            $sql = 'DELETE FROM VIDEO_GENRE WHERE VIDEO_SHOW_ID=' . $showids[$i] . ' AND ';
                            $sql .= 'GENRE="' . $genre . '"';
                            DBQuery($dbh, $sql);
                            $sql = 'SELECT VIDEO_ID FROM VIDEO WHERE SHOW_ID=' . $showids[$i];
                            $result = DBQuery($dbh, $sql);
                            $row = $result->fetch(PDO::FETCH_ASSOC);
                            if (isset($row['VIDEO_ID'])) {
                                $sql = 'DELETE FROM VIDEO_ATTR WHERE VIDEO_ID=' . $row['VIDEO_ID'] . ' AND ';
                                $sql .= 'TYPE="GENRE" AND VALUE="' . $genre . '"';
                                DBQuery($dbh, $sql);
                            }
                        }
                    }
                    break;
            }
        }
        else {
            $action = "error";
            $message = "Cannot Write on readonly Database.";
        }

        print("<data>\n");
        print("<ERROR>0</ERROR>\n");
        print("</data>\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'updateCategory') {
    $message = '';
    if (isset($_GET['source']))
        $drivepath = $_GET["source"];
    else
        $drivepath = LastBrowsed();

    if (isset($_GET['type']))
        $type = $_GET["type"];

    if (isset($_GET['mode']))
        $mode = $_GET["mode"];

    if (isset($_GET['value']))
        $value = $_GET['value'];

    if (is_writable($drivepath . 'nmj_database/media.db')) {
        $dbh = new PDO('sqlite:' . $drivepath . 'nmj_database/media.db');
            switch ($mode) {
                case "inserted":
                    break;
                case "updated":
                    break;
                case "deleted":
                    if ($type == "Genre") {
                        $sql = 'DELETE FROM VIDEO_ATTR WHERE SHOW_ID=' . $showids[$i] . ' AND ';
                        $sql .= 'TYPE="GENRE" AND VALUE="' . $genre . '"';
                        DBQuery($dbh, $sql);
                        $sql = 'DELETE FROM VIDEO_GENRE WHERE VIDEO_SHOW_ID=' . $showids[$i] . ' AND ';
                        $sql .= 'GENRE="' . $genre . '"';
                        DBQuery($dbh, $sql);
                        $sql = 'SELECT VIDEO_ID FROM VIDEO WHERE SHOW_ID=' . $showids[$i];
                        $result = DBQuery($dbh, $sql);
                        $row = $result->fetch(PDO::FETCH_ASSOC);
                        if (isset($row['VIDEO_ID'])) {
                            $sql = 'DELETE FROM VIDEO_ATTR WHERE VIDEO_ID=' . $row['VIDEO_ID'] . ' AND ';
                            $sql .= 'TYPE="GENRE" AND VALUE="' . $genre . '"';
                            DBQuery($dbh, $sql);
                        }
                    }
                    break;
            }
    }
    else {
        $action = "error";
        $message = "Cannot Write on readonly Database.";
    }

    print("<data>\n");
    print("<ERROR>0</ERROR>\n");
    print("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getUnused') {
    print("<data>\n");
    //$files = shell_exec("find /My_Book/ > ".$tmpdir."/list_of_files");
    $lof = file($tmpdir."/list_of_files");
    foreach ($lof as $line){
        if (file_exists($line)){
            print_r($line);
        }
    }
    print("</data>\n");
print_r($files);
}
?>
