function eXcell_passw(cell) {
    if (cell) {
        this.cell = cell;
        this.grid = this.cell.parentNode.grid
    }
    ;
    this.edit = function() {
        this.cell.innerHTML = "";
        this.cell.atag = "INPUT";
        this.val = this.getValue();
        this.obj = document.createElement(this.cell.atag);
        this.obj.style.height = (this.cell.offsetHeight - (_isIE ? 6 : 4)) + "px";
        this.obj.className = "dhx_combo_edit";
        this.obj.type = "text";
        this.obj.wrap = "soft";
        this.obj.style.textAlign = this.cell.align;
        this.obj.onclick = function(e) {
            (e || event).cancelBubble = true
        };
        this.obj.onmousedown = function(e) {
            (e || event).cancelBubble = true
        };
        this.obj.value = this.cell._rval
        this.cell.appendChild(this.obj);
        if (_isFF) {
            this.obj.style.overflow = "visible";
            if ((this.grid.multiLine) && (this.obj.offsetHeight >= 18) && (this.obj.offsetHeight < 40)) {
                this.obj.style.height = "36px";
                this.obj.style.overflow = "scroll"
            }
        }
        ;
        this.obj.onselectstart = function(e) {
            if (!e)e = event;
            e.cancelBubble = true;
            return true
        };
        this.obj.focus()
        this.obj.focus()


    };
    this.getValue = function() {
        return this.cell._rval
    };
    this.setValue = function(val) {
        var str = "*****";
        if (val != "none")this.cell.innerHTML = str; else this.cell.innerHTML = val;
        this.cell._rval = val
    };
    this.detach = function() {
        this.setValue(this.obj.value);
        return this.val != this.getValue()
    }
}
;
eXcell_passw.prototype = new eXcell;

function eXcell_ra_str(cell) {
    if (cell) {
        this.base = eXcell_ra;
        this.base(cell)
        this.grid = cell.parentNode.grid;
    }
}
eXcell_ra_str.prototype = new eXcell_ch;
eXcell_ra_str.prototype.setValue = function(val) {
    this.cell.style.verticalAlign = "middle";//nb:to center checkbox in line
    if (val) {
        val = val.toString()._dhx_trim();
        if ((val == "false") || (val == "0")) val = "";
    }
    if (val) {
        if (this.grid.rowsAr[this.cell.parentNode.idd])
            for (var i = 0; i < this.grid._cCount; i++) {
                if (i !== this.cell._cellIndex) {
                    var cell = this.grid.cells(this.cell.parentNode.idd, i);
                    if ((cell.cell._cellType || this.grid.cellType[cell.cell._cellIndex]) != "ra_str") continue;
                    if (cell.getValue())
                        cell.setValue("0");
                }
            }
        val = "1";
        this.cell.chstate = "1";
    } else {
        val = "0";
        this.cell.chstate = "0"
    }
    this.setCValue("<img src='" + this.grid.imgURL + "radio_chk" + val + ".gif' onclick='new eXcell_ra_str(this.parentNode).changeState()'>", this.cell.chstate);
}

// Filesize eXcell Formatter
function eXcell_fs(cell) {
    if (cell) {
        this.cell = cell;
        this.grid = this.cell.parentNode.grid;
    }
    this.edit = function() {
    }
    this.isDisabled = function() {
        return true;
    }
    this.setValue = function(val) {
        if (val != 0) {
            this.setCValue(PrintSize(val));
        }
        else
            this.setCValue("");
    }
}
eXcell_fs.prototype = new eXcell;    // nest all other methods from base class

// Elapsed & Left time eXcell Formatter
function eXcell_tm(cell) {
    if (cell) {
        this.cell = cell;
        this.grid = this.cell.parentNode.grid;
    }
    this.edit = function() {
    }
    this.isDisabled = function() {
        return true;
    }
    this.setValue = function(val) {
        if (val != 0)
            this.setCValue(setTime(val));
        else
            this.setCValue("");
    }
}
eXcell_tm.prototype = new eXcell;    // nest all other methods from base class

// Speed eXcell Formatter
function eXcell_sd(cell) {
    if (cell) {
        this.cell = cell;
        this.grid = this.cell.parentNode.grid;
    }
    this.edit = function() {
    }
    this.isDisabled = function() {
        return true;
    }
    this.setValue = function(val) {
        if (val != 0) {
            this.setCValue(PrintSpeed(val));
        }
        else
            this.setCValue("");
    }
}
eXcell_sd.prototype = new eXcell;    // nest all other methods from base class

function setTime(time) {
    var hours = Math.floor(time / 3600);
    var minutes = Math.floor(time / 60) - (hours * 60);
    var seconds = time - (hours * 3600) - (minutes * 60);

    if (hours < 10) {
        hours = "0" + hours;
    }
    if (minutes < 10) {
        minutes = "0" + minutes;
    }
    if (seconds < 10) {
        seconds = "0" + seconds;
    }
    return hours + ":" + minutes + ":" + seconds;
}

function PrintSize(size) {
    if (size < 1024 && size >= 0) size = size + " bytes";
    else if (size >= 1024 && size < 1048576) size = roundNumber(size / 1024, 2) + " KB";
    else if (size >= 1048576 && size < 1073741824) size = roundNumber(size / 1024 / 1024, 2) + " MB";
    else if (size >= 1073741824) size = roundNumber(size / 1024 / 1024 / 1024, 2) + " GB";
    return size;
}

function PrintSpeed(size) {
    if (size < 1024 && size >= 0) size = size + " B/s";
    else if (size >= 1024 && size < 1048576) size = roundNumber(size / 1024, 2) + " KB/s";
    else if (size >= 1048576) size = roundNumber(size / 1024 / 1024, 2) + " MB/s";
    return size;
}

function roundNumber(num, dec) {
    var result = Math.round(Math.round(num * Math.pow(10, dec + 1)) / Math.pow(10, 1)) / Math.pow(10, dec);
    return result;
}
