/*input*/
dhtmlXForm.prototype.items.input.doAttachEvents = function(item) {

    item.childNodes[1].childNodes[0].onblur = function() {
        if (item._value != this.value) {
            if (item.checkEvent("onBeforeChange")) if (item.callEvent("onBeforeChange", [this._idd, item._value, this.value]) !== true) {
                // restore
                this.value = item._value;
                return;
            }
            // accepted
            item._value = this.value;
            item.callEvent("onChange", [this._idd, this.value]);
        }
    }

    item.childNodes[1].childNodes[0].onkeypress = function(e) {
        if (e.charCode == 13) { // ENTER pressed !
            if (item._value != this.value) { // Validation check
                if (item.checkEvent("onBeforeChange")) if (item.callEvent("onBeforeChange", [this._idd, item._value, this.value]) !== true) {
                    // restore
                    this.value = item._value;
                    return;
                }
                // accepted
                item._value = this.value;
                item.callEvent("onChange", [this._idd, this.value]);
            }

            item.callEvent("onEnterPressed", [this._idd,this.value]);
        }
    }
    item.childNodes[1].childNodes[0].onkeyup = function(e) {
            if (item._value != this.value) { // Validation check
                if (item.checkEvent("onBeforeChange")) if (item.callEvent("onBeforeChange", [this._idd, item._value, this.value]) !== true) {
                    // restore
                    this.value = item._value;
                    return;
                }
                // accepted
                item._value = this.value;
                item.callEvent("onModified", [this._idd,this.value]);
            }
        }
}

/* password */
dhtmlXForm.prototype.items.password = {

    render: function(item, data) {

        item._type = "pw";
        item._enabled = true;

        this.doAddLabel(item, data);
        this.doAddInput(item, data, "INPUT", "PASSWORD", true, true, "dhxlist_txt_textarea");
        this.doAttachEvents(item);

        item._value = (data.value || "");
        item.childNodes[1].childNodes[0].value = item._value;

        return this;

    }
};

(function() {
    for (var a in {doAddLabel:1,doAddInput:1,doAttachEvents:1,destruct:1,doUnloadNestedLists:1,setText:1,getText:1,setValue:1,getValue:1,enable:1,disable:1,setWidth:1,setReadonly:1,isReadonly:1,setFocus:1,getInput:1})
        dhtmlXForm.prototype.items.password[a] = dhtmlXForm.prototype.items.input[a];
})();

/* separator */
dhtmlXForm.prototype.items.separator = {
    render: function(item, data) {
        item._type = "sp";

        item._width = data.width;

        item._enabled = true;
        item._checked = true; // required for authoCheck

        item.className = data.position + (typeof(data.className) == "string" ? " " + data.className : "");

        var f = document.createElement("DIV");
        f.className = "dhxlist_txt_label";

        item.appendChild(f);

        if (!isNaN(data.inputLeft)) f.style.left = parseInt(data.inputLeft) + "px";
        f.style.backgroundColor = '#FFFFFF';
        f.style.border = '1px solid #727272';
        if (!isNaN(data.inputTop)) f.style.top = parseInt(data.inputTop) + "px";
        if (data.inputWidth != "auto") if (!isNaN(data.inputWidth)) f.style.width = parseInt(data.inputWidth) + "px";

        return this;
    },

    destruct: function(item) {

        item._checked = null;
        item._enabled = null;
        item._idd = null;
        item._type = null;
        item._width = null;

        item.onselectstart = null;

        item._addSubListNode = null;
        item._autoCheck = null;
        item.callEvent = null;
        item.checkEvent = null;
        item.getForm = null;
        item = null;
    },
    enable: function(item) {
        item._is_enabled = true;
    },
    disable: function(item) {
        item._is_enabled = false;
    },

    setWidth: function(item, width) {
        item.childNodes[0].style.width = width + "px";
        item._width = width;
    },

    getWidth: function(item) {
        return item._width;
    }

};

/* imgbutton */
dhtmlXForm.prototype.items.imgbutton = {
    render: function(item, data) {
        item._type = "imgbt";
        item._width = data.width;
        item._height = data.height;
        item._cmd = data.command;
        item._name = data.name;

        item._enabled = true;
        item._checked = true; // required for authoCheck

        item.className = data.position + (typeof(data.className) == "string" ? " " + data.className : "");

        var f = document.createElement("BUTTON");
        f.className = "dhxlist_img_button";

        item.appendChild(f);

        if (!isNaN(data.inputLeft)) f.style.left = parseInt(data.inputLeft) + "px";
        if (!isNaN(data.inputTop)) f.style.top = parseInt(data.inputTop) + "px";
        if (data.inputWidth != "auto") if (!isNaN(data.inputWidth)) f.style.width = parseInt(data.inputWidth) + "px";
        if (data.style) f.style.cssText += data.style;
        if (data.title) f.title = data.title;
        if (data.name) f.id = data.name;
        if (data.name) f.name = data.name;
        f.setAttribute("img", data.image);
        f.setAttribute("imgdis", data.imagedis);
        this.doAttachEvents(item);
        return this;
    },

    destruct: function(item) {

        item._checked = null;
        item._enabled = null;
        item._idd = null;
        item._type = null;
        item._width = null;

        item.onselectstart = null;

        item._addSubListNode = null;
        item._autoCheck = null;
        item.callEvent = null;
        item.checkEvent = null;
        item.getForm = null;
        item = null;
    },
    enable: function(item) {
        item.childNodes[0].style.backgroundImage = 'url(' + item.childNodes[0].getAttribute("img") + ')';
        item.childNodes[0].disabled = false;

    },
    disable: function(item) {
        item.childNodes[0].style.backgroundImage = 'url(' + item.childNodes[0].getAttribute("imgdis") + ')';
        item.childNodes[0].disabled = true;
    },

    setWidth: function(item, width) {
        item.childNodes[0].style.width = width + "px";
        item._width = width;
    },

    getWidth: function(item) {
        return item._width;
    },
    doAttachEvents: function(item) {

        var t = item.childNodes[0];
        var that = this;

        t.onclick = function() {
            item.callEvent("onButtonClick", [t.name, t.cmd]);
        }
        t.onkeydown = function() {
            that.doOnChange(this);
        }
        t.onchange = function() { // needed for safari/chrome
            that.doOnChange(this);
        }
    }
};
(function() {
    for (var a in {doUnloadNestedLists:1})dhtmlXForm.prototype.items.imgbutton[a] = dhtmlXForm.prototype.items.checkbox[a];
})();

dhtmlXForm.prototype.items.image = {
    render: function(item, data) {
        item._type = "img";
        item._enabled = true;
        item._checked = true;
        item._name = data.name;
    var t = document.createElement("DIV");
    t.className = "dhxlist_txt_label2"+(data._isTopmost?" topmost":""); 
    var h = document.createElement("A");
    if (data.href != undefined) {h.href = '#';h.setAttribute('onclick',data.href);};
    if (data.title != undefined) h.title = data.title;
    t.appendChild(h);
    var i = document.createElement("IMG");
    i.src = data.src;
    if (!isNaN(data.labelWidth)) i.style.width = parseInt(data.labelWidth)+"px";
    if (!isNaN(data.labelHeight)) i.style.height = parseInt(data.labelHeight)+"px";
    h.appendChild(i);
    item.appendChild(t);
    item._initsrc = data.src;
    if (data.hidden == true)this.hide(item);
    if (data.disabled == true)this.userDisable(item);
    if (!isNaN(data.labelWidth)) t.style.width = parseInt(data.labelWidth)+"px";
    if (!isNaN(data.labelHeight)) t.style.height = parseInt(data.labelHeight)+"px";
    if (!isNaN(data.labelLeft)) t.style.left = parseInt(data.labelLeft)+"px";
    if (!isNaN(data.labelTop)) t.style.top = parseInt(data.labelTop)+"px";
    if (data.style) t.style.cssText += data.style;return this;
    },
 
    destruct: function(item) {
        this.doUnloadNestedLists(item);item._autoCheck = null;item._enabled = null;item._type = null;item.callEvent = null;item.checkEvent = null;item.getForm = null;item.onselectstart = null;item.parentNode.removeChild(item);item = null;
    },
 
    enable: function(item) {
        if (item.cover)
            if (!item._enabled){
                item.cover.style.display = "none";
                item._enabled=true;
            }
    },
 
    disable: function(item) {
        if (!item.cover) {
            item.cover = document.createElement("DIV");
            item.cover.className = "dhx_image_cover";
            item.cover.style.width = parseInt(item.childNodes[0].style.width)+6+'px';
            item.cover.style.height = parseInt(item.childNodes[0].style.height)+6+'px';
            item.cover.style.top = parseInt(item.childNodes[0].style.top)+2+'px';
            item.cover.style.left = parseInt(item.childNodes[0].style.left)+2+'px';
            item.appendChild(item.cover);
        }
        if (item._enabled){
            item.cover.style.display = "inline-block";
            item._enabled = false;
        }
    },

    setValue: function(item, image) {if(image)item.childNodes[0].childNodes[0].childNodes[0].src = image;else item.childNodes[0].childNodes[0].childNodes[0].src = item._initsrc},

    getValue: function(item) {return item.childNodes[0].childNodes[0].childNodes[0].src;},
};
dhtmlXForm.prototype.items.image.doUnloadNestedLists = dhtmlXForm.prototype.items.checkbox.doUnloadNestedLists;
