#!/usr/local/bin/php
<?php
if(is_readable("_include/config.php"))
    include "_include/config.php";
else
    include "config.php";

if(is_readable("_include/functions.php"))
    include "_include/functions.php";
else
    include "functions.php";

if(is_readable("_include/preg_find.php"))
    include "_include/preg_find.php";
else
    include "preg_find.php";


if ( $argc == 2 && $argv[1] == "rebuild_movie_nfo" )
    $rebuild_movie_nfo=1;
else
    $rebuild_movie_nfo=0;

if ( $argc == 2 && $argv[1] == "rebuild_media_nfo" )
    $rebuild_media_nfo=1;
else
    $rebuild_media_nfo=0;

LoadPreferences();
$count=0;
$movie_names=findMovies($video_folder);
$movie_nfo_missing=array();
$media_nfo_missing=array();
$count=0;
foreach ($movie_names as $movie_name) {
    $nfo_fullpath=$nfo_folder[0]."/".$movie_name['name'].".nfo";
    if (file_exists($nfo_fullpath) && filesize($nfo_fullpath) != 0) {
        if ($rebuild_movie_nfo == 1){
            $fp = fopen($nfo_fullpath, "r");
            $xdata = fread($fp, filesize($nfo_fullpath));
            $xml_parser = xml_parser_create();
            xml_parse_into_struct($xml_parser, $xdata, $vals, $index);
            xml_parser_free($xml_parser);
            foreach ($vals as $xml_elem) {
                if ($xml_elem['tag'] == 'ID' && (! isset($xml_elem['attributes'])))
                    $movie_nfo_missing[$count]['imdbid'] = $xml_elem['value'];
            }
            $movie_nfo_missing[$count]['nfo'] = $nfo_fullpath;
            $movie_nfo_missing[$count]['id'] = $movie_name['id'];
            $movie_nfo_missing[$count++]['name'] = $movie_name['name'];
        }
    }
    else {
        $movie_nfo_missing[$count]['nfo'] = $nfo_folder[0]."/".$movie_name['name'].".nfo";
        $movie_nfo_missing[$count]['id'] = $movie_name['id'];
        $movie_nfo_missing[$count++]['name'] = $movie_name['name'];
    }
}
if (count($movie_nfo_missing) == 0)
    echo "All NFO's already Built. Use rebuild_movie_nfo as option to rebuild NFO's.\n";
else
    echo "Building NFO's for ".count($movie_nfo_missing)." files.\n";

foreach ($movie_nfo_missing as $movie_name) {
    if (! isset($movie_name['imdbid'])) {
        echo "Searching IMDB...\n";
        $imdbid=searchIMDB($movie_name['name']);

        if ($imdbid == "No Matches") {
            echo "No Matches.\n";
        }
        else
            echo "IMDB ID ".$imdbid." found.\n";
    }
    else
        $imdbid=$movie_name['imdbid'];

    if (isset($imdbid)) {
        echo "Retrieving data from IMDB for ".$imdbid."\n";
        if (!is_writable($movie_name['nfo']))
            echo "Write Access denied for ".basename($movie_name['nfo'])."\n";
        else
            buildNFO($imdbid, $movie_name['nfo'], $movie_name['id']);
    }
}

foreach ($media_nfo_missing as $movie_name) {
    echo "Building MediaInfo for ".basename($movie_name['nfo'])."\n";
    if (!is_writable($movie_name['nfo']))
        echo "Write Access denied for ".basename($movie_name['nfo'])."\n";
    else
        buildMediaNFO($movie_name['nfo'], $movie_name['id']);
}
