#!/bin/sh
Input_File=$1
nfo_folder=`cat _data/preferences.txt|grep nfo_folder|cut -d'=' -f2`
nfos_folder=`cat _data/preferences.txt|grep nfos_folder|cut -d'=' -f2`
skin=`cat _data/preferences.txt|grep skin|cut -d'=' -f2`
jukebox_location=`cat _data/preferences.txt|grep jukebox_location|cut -d'=' -f2`
thumbnail_location=`echo ${jukebox_location}/${skin}`
utildir=`cat _include/config.php|grep '"utildir"] ='|cut -d'"' -f4`

PATH=$PATH:/usr/local/bin:${utildir}bin/
export PATH

LD_LIBRARY_PATH=$LD_LIBRARY_PATH:${utildir}lib/
export LD_LIBRARY_PATH

CONVERT=${utildir}/bin/convert

if [ ! -d ${thumbnail_location} ];then
    mkdir ${thumbnail_location}
fi

FileSize ()
{
  if [ -f "$1" ] ; then
    SIZE=`ls -ld "$1" | awk '{print $5}'`
    echo $SIZE
  else
    echo 0
  fi
}

Thumb_File=`echo ${Input_File}|sed "s|${nfos_folder}/|Jukebox/posters/|g"`
Large_File=`echo ${Input_File}|sed 's|.jpg|_large.png|g'|sed "s|${nfos_folder}/|${thumbnail_location}/|g"`
Small_File=`echo ${Input_File}|sed 's|.jpg|_small.png|g'|sed "s|${nfos_folder}/|${thumbnail_location}/|g"`

Input_Size=`FileSize $Input_File`
Thumbnail_Size=`FileSize $Thumb_File`
Rebuild_Required="no"
if [ $Input_Size -ne $Thumbnail_Size ];then
    cp $Input_File ${Thumb_File}
    Rebuild_Required="yes"
fi

if [ ! -f ${thumbnail_location}/skin.properties ];then
    cp djb/skins/${skin}/skin.properties ${thumbnail_location}/
fi

thumbnails_width=`cat djb/skins/${skin}/skin.properties|grep thumbnails.width|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
thumbnails_height=`cat djb/skins/${skin}/skin.properties|grep thumbnails.height|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`

posters_width=`cat djb/skins/${skin}/skin.properties|grep posters.width|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
posters_height=`cat djb/skins/${skin}/skin.properties|grep posters.height|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`

t_reflectionHeight=`cat djb/skins/${skin}/skin.properties|grep thumbnails.reflectionHeight=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'|tr -d '.'`
p_reflectionHeight=`cat djb/skins/${skin}/skin.properties|grep posters.reflectionHeight=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'|tr -d '.'`
if [ "$t_reflectionHeight" = "" ];then
    t_reflectionHeight=125
fi
if [ "$p_reflectionHeight" = "" ];then
    p_reflectionHeight=125
fi
t_normalize=`cat djb/skins/${skin}/skin.properties|grep thumbnails.normalize|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
p_normalize=`cat djb/skins/${skin}/skin.properties|grep posters.normalize|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
if [ "$t_normalize" = "" ];then
    t_normalize=true
fi
if [ "$p_normalize" = "" ];then
    p_normalize=false
fi

t_reflection=`cat djb/skins/${skin}/skin.properties|grep thumbnails.reflection=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
p_reflection=`cat djb/skins/${skin}/skin.properties|grep posters.reflection=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`

t_logoHD=`cat djb/skins/${skin}/skin.properties|grep thumbnails.logoHD=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
p_logoHD=`cat djb/skins/${skin}/skin.properties|grep posters.logoHD=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`

t_logoTV=`cat djb/skins/${skin}/skin.properties|grep thumbnails.logoTV=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
p_logoTV=`cat djb/skins/${skin}/skin.properties|grep posters.logoTV=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`

t_logoSet=`cat djb/skins/${skin}/skin.properties|grep thumbnails.logoSet=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
p_logoSet=`cat djb/skins/${skin}/skin.properties|grep posters.logoSet=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
if [ "$t_logoSet" = "" ];then
    t_logoSet=false
fi
if [ "$p_logoSet" = "" ];then
    p_logoSet=false
fi

t_language=`cat djb/skins/${skin}/skin.properties|grep thumbnails.language=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
p_language=`cat djb/skins/${skin}/skin.properties|grep posters.language=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
if [ "$p_language" = "" ];then
    p_language=false
fi

t_perspective=`cat djb/skins/${skin}/skin.properties|grep thumbnails.perspective=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
p_perspective=`cat djb/skins/${skin}/skin.properties|grep posters.perspective=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`

t_perspectiveTop=`cat djb/skins/${skin}/skin.properties|grep thumbnails.perspectiveTop=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'|tr -d '.'`
t_perspectiveBottom=`cat djb/skins/${skin}/skin.properties|grep thumbnails.perspectiveBottom=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'|tr -d '.'`
p_perspectiveTop=`cat djb/skins/${skin}/skin.properties|grep posters.perspectiveTop=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'|tr -d '.'`
p_perspectiveBottom=`cat djb/skins/${skin}/skin.properties|grep posters.perspectiveBottom=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'|tr -d '.'`

t_perspectiveDirection=`cat djb/skins/${skin}/skin.properties|grep thumbnails.perspectiveDirection=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
p_perspectiveDirection=`cat djb/skins/${skin}/skin.properties|grep posters.perspectiveDirection=|grep -v '#'|cut -d'=' -f2|sed 's|
||g'`
if [ "$t_perspectiveTop" = "" ];then
    t_perspectiveTop=30
fi
if [ "$t_perspectiveBottom" = "" ];then
    t_perspectiveBottom=30
fi
if [ "$p_perspectiveTop" = "" ];then
    p_perspectiveTop=30
fi
if [ "$p_perspectiveBottom" = "" ];then
    p_perspectiveBottom=30
fi
if [ "$t_perspectiveDirection" = "" ];then
    t_perspectiveDirection=right
fi
if [ "$p_perspectiveDirection" = "" ];then
    p_perspectiveDirection=right
fi

buildSThumbs() {
    # Small Thumbnails
    #
    ${CONVERT} ${Input_File} ${Small_File}

    #Resize
    if [ "$t_normalize" = "true" ];then
        ${CONVERT} $Small_File -resize ${thumbnails_width}x${thumbnails_height}\! $Small_File
    else
        ${CONVERT} $Small_File -resize ${thumbnails_width}x${thumbnails_height}\! $Small_File
    fi

    if [ "$t_reflection" = "true" ];then
        #One more copy
        ${CONVERT} $Small_File _tmp/bottom.png

        #Make it opaque
        mogrify -alpha on -channel o -evaluate set 50% -fill rgba\(0,0,0,0\) -opaque rgb\(0,0,0\) _tmp/bottom.png

        crop=`expr $thumbnails_height \*  $t_reflectionHeight \/ 1000`
        crop2=`expr $crop + 2`
        y=`expr $thumbnails_height - $crop`

        #Take portion of Image
        ${CONVERT} _tmp/bottom.png -crop ${thumbnails_width}x${crop}+0+${y} _tmp/cropped.png
        ${CONVERT} _tmp/cropped.png \( -size ${thumbnails_width}x${crop} gradient: -negate \) -alpha off -compose copy_opacity -composite _tmp/cropped2.png
        ${CONVERT} _tmp/cropped2.png -flip _tmp/flipped.png
        composite -blend 0x40 _scripts/null.png _tmp/flipped.png -matte _tmp/flipped2.png
        ${CONVERT} -size ${thumbnails_width}x${crop2} xc:none _tmp/blank.png
        composite -gravity south _tmp/flipped2.png _tmp/blank.png _tmp/bottom2.png
        ${CONVERT} $Small_File _tmp/bottom2.png -append $Small_File
    fi
    if [ "$t_perspective" = "true" ];then
        persTop=`expr ${thumbnails_height} \* $t_perspectiveTop \/ 1000`
        persBot=`expr ${thumbnails_height} \* $t_perspectiveBottom \/ 1000`
        LGDIF2=`expr ${thumbnails_height} - $persTop`
        if [ "$t_perspectiveDirection" = "right" ];then
            ${CONVERT} $Small_File -virtual-pixel transparent -distort Perspective "0,0,0,0  0,${thumbnails_height},0,${thumbnails_height}  ${thumbnails_width},0,${thumbnails_width},${persBot}  ${thumbnails_width},${thumbnails_height},${thumbnails_width},${LGDIF2}" $Small_File
        else
            ${CONVERT} $Small_File -virtual-pixel transparent -distort Perspective "0,0,0,${persBot}  0,${thumbnails_height},0,${LGDIF2} ${thumbnails_width},0,${thumbnails_width},0  ${thumbnails_width},${thumbnails_height},${thumbnails_width},${thumbnails_width}" $Small_File
        fi
    fi
}

buildLThumbs() {
    # Large Thumbnails
    #
    ${CONVERT} $Input_File $Large_File

    if [ "$t_normalize" = "true" ];then
        ${CONVERT} $Large_File -resize ${posters_width}x${posters_height}\! $Large_File
    else
        ${CONVERT} $Large_File -resize ${posters_width}x${posters_height} $Large_File
    fi

    if [ "$t_reflection" = "true" ];then
        ${CONVERT} $Large_File _tmp/bottom.png
        mogrify -alpha on -channel o -evaluate set 50% -fill rgba\(0,0,0,0\) -opaque rgb\(0,0,0\) _tmp/bottom.png

        crop=`expr $posters_height \* $p_reflectionHeight \/ 1000`
        crop2=`expr $crop + 2`
        y=`expr $posters_height - $crop`
        ${CONVERT} _tmp/bottom.png -crop ${posters_width}x${crop}+0+${y} _tmp/cropped.png
        ${CONVERT} _tmp/cropped.png \( -size ${posters_width}x${crop} gradient: -negate \) -alpha off -compose copy_opacity -composite _tmp/cropped2.png
        ${CONVERT} _tmp/cropped2.png -flip _tmp/flipped.png
        composite -blend 0x60 _scripts/null.png _tmp/flipped.png -matte _tmp/flipped2.png
        ${CONVERT} -size ${posters_width}x${crop2} xc:none _tmp/blank.png
        composite -gravity south _tmp/flipped2.png _tmp/blank.png _tmp/bottom2.png
        ${CONVERT} $Large_File _tmp/bottom2.png -append $Large_File
    fi

    if [ "$p_perspective" = "true" ];then
        persTop=`expr ${posters_height} \* $p_perspectiveTop \/ 1000`
        persBot=`expr ${posters_height} \* $p_perspectiveBottom \/ 1000`
        LGDIF2=`expr ${posters_height} - $persTop`
        if [ "$t_perspectiveDirection" = "right" ];then
            ${CONVERT} $Large_File -virtual-pixel transparent -distort Perspective "0,0,0,0  0,$posters_height,0,$posters_height  $posters_width,0,$posters_width,$persBot  $posters_width,$posters_height,$posters_width,$LGDIF2" $Large_File
        else
            ${CONVERT} $Large_File -virtual-pixel transparent -distort Perspective "0,0,0,${persBot}  0,$posters_height,0,${LGDIF2}  $posters_width,0,$posters_width,0  $posters_width,$posters_height,$posters_width,$posters_width" $Large_File
        fi
    fi
}

cmp -s djb/skins/${skin}/skin.properties ${thumbnail_location}/skin.properties
status=$?
if [ $status -ne 0 ];then
    buildSThumbs
    buildLThumbs
fi

if [ ! -f $Small_File ];then
    buildSThumbs
elif [ "$Rebuild_Required" = "yes" ];then
    buildSThumbs
fi
if [ ! -f $Large_File ];then
    buildLThumbs
elif [ "$Rebuild_Required" = "yes" ];then
    buildLThumbs
fi
rm -f _tmp/bottom2.png _tmp/bottom.png _tmp/flipped.png _tmp/flipped2.png _tmp/cropped.png _tmp/cropped2.png _tmp/blank.png
