<?php
// +-----------------------------------------------------------------------+
// |                                                                       |
// | THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   |
// | "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     |
// | LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR |
// | A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  |
// | OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, |
// | SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT      |
// | LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, |
// | DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY |
// | THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   |
// | (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE |
// | OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  |
// |                                                                       |
// +-----------------------------------------------------------------------+

if (is_readable("_include/config.php"))
    include "_include/config.php";
else
    include "config.php";

function LoadPreferences()
{
    global $datadir;
    if (file_exists($datadir . '/preferences.txt')) {
        $handle = fopen($datadir . '/preferences.txt', 'r');
        while (($data = fgetcsv($handle, 1000, "=")) != FALSE) {
            $output = explode(",", $data[1]);
            $GLOBALS[$data[0]] = $output;
        }
        fclose($handle);
    }
}

function LastBrowsed()
{
    global $datadir;
    if (file_exists($datadir . '/last_browsed') && filesize($datadir . '/last_browsed') > 0) {
        $filestring = file_get_contents($datadir . '/last_browsed');
        $filearray = explode("\n", $filestring);
        return $filearray[0];
    }
}

function SetLastBrowsed($dir)
{
    global $datadir;
    if (is_writable($datadir)) {
        file_put_contents($datadir . "/last_browsed", $dir);
    }
}

function searchIMDB($string)
{
    foreach ($skip_keywords as $skip_key) {
        $string = str_replace($skip_key, "", strtoupper($string));
        $string = str_replace("..", ".", $string);
    }

    $search = array(".", "-", "_", "[", "]", "(", ")", "  ");
    $replace = array(" ", " ", " ", " ", " ", " ", " ", " ");
    $string = trim(str_replace($search, $replace, $string));
    for ($i = 1950; $i < 3000; $i++)
        $string = str_replace($i, "(" . $i . ")", $string);
    $string = explode(")", $string);
    if (count($string) > 1)
        $string = $string[0] . ")";
    else
        $string = $string[0];

    $command = "wget -q 'http://www.imdb.com/find?s=tt&q=" . $string . "&x=0&y=0' -qO-";
    $imdb_content = shell_exec($command);
    if (stristr($imdb_content, "No Matches."))
        return "No Matches";
    else
        return getIMDBid($imdb_content);
}

function array_push_assoc($array, $key, $value)
{
    $array[$key] = $value;
    return $array;
}

function scan_dir($dir)
{
    $dh = opendir($dir);
    while (false !== ($filename = readdir($dh))) {
        $files[] = $filename;
    }
    sort($files);
    return $files;
}

function getXMLSafe($input)
{
    return html_entity_decode(str_replace('&#x27;', '&#39;', str_replace('&apos;', '&#39;', $input)), ENT_QUOTES);
    //return str_replace("&#039;", "&apos;", htmlentities(html_entity_decode($input), ENT_QUOTES));
    //return str_replace("&#039;", "'", $input);
}

function setXMLSafe($input)
{
    return str_replace("&#039;", "&apos;", htmlentities($input, ENT_QUOTES));
}

function setNMJSafe($input)
{
    return str_replace("&#039;", "&apos;", utf8_encode(htmlentities($input, ENT_QUOTES)));
}

function getNMJSafe($input)
{
    $input = str_replace("&#x27;", "&apos;", $input);
    return htmlentities(html_entity_decode($input, ENT_QUOTES));
}

function getIMDBdata($imdbid)
{
    global $tmpdir;

    LoadPreferences();
    $nmj_data = array();
    $director = array();
    $actor = array();
    if (file_exists($tmpdir . "/cache." . $imdbid) && filesize($tmpdir . "/cache." . $imdbid) > 0)
        $imdb_content = file_get_contents($tmpdir . "/cache." . $imdbid);
    else {
        $command = "wget 'http://www.imdb.com/title/" . $imdbid . "/' -qO-";
        $imdb_content = preg_replace('~(\r|\n|\r\n)~', '', shell_exec($command));
        file_put_contents($tmpdir . "/cache." . $imdbid, $imdb_content);
    }

    $IMDB_TITLE = '~og:title" content="(.*) \((.*)\)"~Ui';
    $IMDB_CAST = '~<td class="name">\s+<a\s+href="/name/nm(\d+)/">(.*)</a>\s+</td~Ui';
    $IMDB_GENRE = '~<a href="/genre/(.*)"~Ui';
    $IMDB_KEYWORD = '~<a href="/keyword/(.*)">(.*)</a>~isU';
    $IMDB_MPAA = '~<a href="/mpaa">MPAA</a>\)</h4>(.*)</div>~isU';
    $IMDB_RELEASE_DATE = '~Release Date:</h4>(.*)(<span|</div>)~Ui';
    $IMDB_RATING = '~<span class="rating-rating"><span class="value".*?>(\d+\.\d+)</span>~Ui';
    $IMDB_PLOT = '~<p itemprop="description">(.*)</p></p>~Ui';
    $IMDB_FULL_PLOT = '~<h2>Storyline</h2><p>(.*)(<em class="nobr">|</p>)~Ui';
    $IMDB_DIRECTOR = '~<h4 class="inline">\s+(Director|Directors):\s+</h4>(.*)</div>~Ui';
    $IMDB_CREATOR = '~<h4 class="inline">\s+(Creator|Creators):\s+</h4>(.*)</div><div~Ui';
    $IMDB_DIRECTORS = '~Directed by</a></h5>(.*)</table>~Ui';
    $IMDB_NAME = '~href="(fullcredits#directors|/name/nm(\d+)/)"(?:\s>|\s+itemprop="\w+">|>)(.*)</a>~Ui';
    $IMDB_EPISODE = '~<div class="article episode-nav"\s+>\s+<strong>(.*)</strong>~isU';

    //imdbid
    $nmj_data = array_push_assoc($nmj_data, "TTID", $imdbid);

    // Title
    $strReturn = matchRegex($imdb_content, $IMDB_TITLE, 1);
    $nmj_data = array_push_assoc($nmj_data, "TITLE", getXMLSafe(trim($strReturn)));

    $strReturn = matchRegex($imdb_content, $IMDB_TITLE, 2);
    if (preg_match('~(TV series|TV Series|TV mini-series)~Ui', $strReturn))
        $nmj_data = array_push_assoc($nmj_data, "SHOW_TYPE", "TV Show");
    else
        $nmj_data = array_push_assoc($nmj_data, "SHOW_TYPE", "Movie");

    // Movie Rating
    $strReturn = matchRegex($imdb_content, $IMDB_RATING, 1);
    if (isset($strReturn))
        $nmj_data = array_push_assoc($nmj_data, "RATING", trim($strReturn));
    else
        $nmj_data = array_push_assoc($nmj_data, "RATING", 0);

    // Find Episode No
    $strReturn = matchRegex($imdb_content, $IMDB_EPISODE, 1);
    if (isset($strReturn))
        $nmj_data = array_push_assoc($nmj_data, "EPISODE", trim($strReturn));
    else
        $nmj_data = array_push_assoc($nmj_data, "EPISODE", '');

    // Plot
    $strContainer = matchRegex($imdb_content, $IMDB_PLOT, 1);
    if (isset($strContainer)) {
        $strReturn = preg_match("|See full summary|", $strContainer);
        if ($strReturn == 1)
            $strContainer = matchRegex($imdb_content, $IMDB_FULL_PLOT, 1);
        $nmj_data = array_push_assoc($nmj_data, "CONTENT", getXMLSafe(trim(strip_tags($strContainer))));
    }
    else
        $nmj_data = array_push_assoc($nmj_data, "CONTENT", "");

    // Release Date
    $strReturn = matchRegex($imdb_content, $IMDB_RELEASE_DATE, 1);
    if (isset($strReturn)) {
        $reldate = explode("(", strip_tags($strReturn));
        $nmj_data = array_push_assoc($nmj_data, "RELEASE_DATE", date("Y-m-d", strtotime($reldate[0])));
    }
    else
        $nmj_data = array_push_assoc($nmj_data, "RELEASE_DATE", date("9999-01-01"));

    // Genre
    $arrReturned = matchRegex($imdb_content, $IMDB_GENRE);
    if (count($arrReturned[1]))
        foreach ($arrReturned[1] as $i => $strName)
            $genre[] = trim(strip_tags($strName));
    if (isset($genre))
        $nmj_data = array_push_assoc($nmj_data, "GENRE", implode("#", $genre));

    // Director
    $strContainer = matchRegex($imdb_content, $IMDB_DIRECTOR, 2);
    $arrReturned = matchRegex($strContainer, $IMDB_NAME);

    if ($arrReturned[1][count($arrReturned[1]) - 1] == "fullcredits#directors") {
        $command = "wget 'http://www.imdb.com/title/" . $imdbid . "/fullcredits' -qO-";
        $full_directors = preg_replace('~(\r|\n|\r\n)~', '', shell_exec($command));
        $strContainer = matchRegex($full_directors, $IMDB_DIRECTORS, 1);
        $arrReturned = matchRegex($strContainer, $IMDB_NAME);
    }

    if (count($arrReturned[3]))
        foreach ($arrReturned[3] as $i => $strName)
            $director[] = trim(strip_tags($strName));
    if (isset($director))
        $nmj_data = array_push_assoc($nmj_data, "DIRECTOR", implode("#", $director));

    // Cast
    $arrReturned = matchRegex($imdb_content, $IMDB_CAST);
    if (count($arrReturned[2]))
        foreach ($arrReturned[2] as $i => $strName)
            $actor[] = str_replace("&#39;", "'", trim(strip_tags($strName)));
    if (isset($actor))
        $nmj_data = array_push_assoc($nmj_data, "CAST", implode("#", $actor));

    // Keyword
    $arrReturned = matchRegex($imdb_content, $IMDB_KEYWORD);
    if (count($arrReturned[1]))
        foreach ($arrReturned[1] as $i => $strName)
            $keyword[] = trim($strName);
    if (isset($keyword))
        $nmj_data = array_push_assoc($nmj_data, "KEYWORD", implode("#", $keyword));

    // MPAA
    $strReturn = matchRegex($imdb_content, $IMDB_MPAA, 1);
    if (isset($strReturn)) {
        $mpaa_rating = explode(" ", strip_tags($strReturn));
        $nmj_data = array_push_assoc($nmj_data, "PARENTAL_RATING", trim($mpaa_rating[1]));
    }
    else
        $nmj_data = array_push_assoc($nmj_data, "PARENTAL_RATING", "");

    return ($nmj_data);
}

function getTMDBdata($imdbid)
{
    global $tmpdir;

    $APIKEY = "b626260be86175272e48fa6347e58100";

    $count = preg_match("|tt\d{7}|isU", $imdbid, $result);
    if ($count > 0) {
        $command = "wget 'http://api.themoviedb.org/2.1/Movie.imdbLookup/en/xml/" . $APIKEY . "/" . $imdbid . "' -qO-";
        $data = shell_exec($command);
        $xml_parser = xml_parser_create();
        xml_parse_into_struct($xml_parser, $data, $vals, $index);
        xml_parser_free($xml_parser);
        foreach ($vals as $tmdb_data) {
            if ($tmdb_data['tag'] == 'ID')
                $nmj_data['TTID'] = $tmdb_data['value'];
        }
    }
    else
        $nmj_data['TTID'] = $imdbid;

    if (file_exists($tmpdir . "/cache." . $nmj_data['TTID']) && filesize($tmpdir . "/cache." . $nmj_data['TTID']) > 0)
        $data = file_get_contents($tmpdir . "/cache." . $nmj_data['TTID']);
    else {
        $command = "wget 'http://api.themoviedb.org/2.1/Movie.getInfo/en/xml/" . $APIKEY . "/" . $nmj_data['TTID'] . "' -qO-";
        $data = shell_exec($command);
        file_put_contents($tmpdir . "/cache." . $nmj_data['TTID'], $data);
    }
    $xml_parser = xml_parser_create();
    xml_parse_into_struct($xml_parser, $data, $vals, $index);
    xml_parser_free($xml_parser);
    foreach ($vals as $tmdb_data) {
        if ($tmdb_data['tag'] == 'NAME')
            $nmj_data['TITLE'] = $tmdb_data['value'];
        else if ($tmdb_data['tag'] == 'OVERVIEW')
            $nmj_data['CONTENT'] = $tmdb_data['value'];
        else if ($tmdb_data['tag'] == 'RATING')
            $nmj_data['RATING'] = $tmdb_data['value'];
        else if ($tmdb_data['tag'] == 'CERTIFICATION')
            $nmj_data['PARENTAL_RATING'] = $tmdb_data['value'];
        else if ($tmdb_data['tag'] == 'RELEASED')
            $nmj_data['RELEASE_DATE'] = $tmdb_data['value'];
        else if ($tmdb_data['tag'] == 'KEYWORD')
            $keyword[] = $tmdb_data['attributes']['NAME'];
        else if ($tmdb_data['tag'] == 'PERSON' && $tmdb_data['attributes']['JOB'] == 'Director')
            $director[] = $tmdb_data['attributes']['NAME'];
        else if ($tmdb_data['tag'] == 'PERSON')
            $cast[] = $tmdb_data['attributes']['NAME'];
        else if ($tmdb_data['tag'] == 'CATEGORY')
            $genre[] = $tmdb_data['attributes']['NAME'];
    }
    $nmj_data['KEYWORD'] = implode("#", $keyword);
    $nmj_data['CAST'] = implode("#", $cast);
    $nmj_data['DIRECTOR'] = implode("#", $director);
    $nmj_data['GENRE'] = implode("#", $genre);

    return $nmj_data;
}

function getMediaInfo($drivepath, $media)
{
    LoadPreferences();
    $med_data = array();
    if (file_exists("/usr/local/bin/mediainfo") && is_executable("/usr/local/bin/mediainfo")) {
        $command = "/usr/local/bin/mediainfo --Full --Output=XML";
        $cmd = $command . " \"" . $drivepath . $media . "\"";
        $media_output = shell_exec($cmd);

        $xml_parser = xml_parser_create();
        xml_parse_into_struct($xml_parser, $media_output, $vals, $index);
        xml_parser_free($xml_parser);
        foreach ($vals as $xml_elem) {
            if ($xml_elem['tag'] == 'FORMAT' && $med_data['SYSTEM'] == '')
                $med_data = array_push_assoc($med_data, "SYSTEM", $xml_elem['value']);
            if ($xml_elem['tag'] == 'WIDTH' && $med_data['WIDTH'] == '')
                $med_data = array_push_assoc($med_data, "WIDTH", $xml_elem['value']);
            if ($xml_elem['tag'] == 'HEIGHT' && $med_data['HEIGHT'] == '')
                $med_data = array_push_assoc($med_data, "HEIGHT", $xml_elem['value']);
            if ($xml_elem['tag'] == 'FRAME_RATE' && $med_data['FPS'] == '')
                $med_data = array_push_assoc($med_data, "FPS", clean_num($xml_elem['value']));
            if ($xml_elem['tag'] == 'DISPLAY_ASPECT_RATIO')
                $med_data = array_push_assoc($med_data, "ASPECT_RATIO", $xml_elem['value']);
            if ($xml_elem['tag'] == 'WRITING_LIBRARY_NAME' && $med_data['VIDEO_CODEC'] == '')
                $med_data = array_push_assoc($med_data, "VIDEO_CODEC", $xml_elem['value']);
            if ($xml_elem['tag'] == 'CODECS_VIDEO' && $med_data['VIDEO_CODEC'] == '')
                $med_data = array_push_assoc($med_data, "VIDEO_CODEC", $xml_elem['value']);
            if ($xml_elem['tag'] == 'FILE_SIZE' && $med_data['SIZE'] == '')
                $med_data = array_push_assoc($med_data, "SIZE", (float)$xml_elem['value']);
            if ($xml_elem['tag'] == 'DURATION' && $med_data['RUNTIME'] == '')
                $med_data = array_push_assoc($med_data, "RUNTIME", floor($xml_elem['value'] / 1000));
            if ($xml_elem['tag'] == 'TEXT_LANGUAGE_LIST')
                $sub_data = str_replace(" / ", "#", $xml_elem['value']);
        }
    }

    if ($med_data['HEIGHT'] != '' && $med_data['WIDTH'] != '')
        $med_data = array_push_assoc($med_data, "RESOLUTION", $med_data['WIDTH'] . 'x' . $med_data['HEIGHT']);

    $med_data = array_push_assoc($med_data, "CREATE_TIME", date("Y-m-d H:i:s"));

    $media_woe_fpath = substr($drivepath . $media, 0, strrpos($drivepath . $media, "."));
    $media_woe = substr($media, 0, strrpos($media, "."));

    if (file_exists($media_woe_fpath . ".srt")) {
        $sub_data[count($sub_data)] = $media_woe . ".srt";
    }
    if (file_exists($media_woe_fpath . ".ssa")) {
        $sub_data[count($sub_data)] = $media_woe . ".ssa";
    }
    if (file_exists($media_woe_fpath . ".sub")) {
        $sub_data[count($sub_data)] = $media_woe . ".sub";
    }
    if (file_exists($media_woe_fpath . ".idx")) {
        $sub_data[count($sub_data)] = $media_woe . ".idx";
    }

    $med_data = array_push_assoc($med_data, "SUBTITLE", implode("#", $sub_data));

    return ($med_data);
}

function handleNMJData($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        case "inserted":
            // Insert VIDEO_PERSON
            $nmj_data['castid'] = handleVideoPerson($dbh, $nmj_data, "insert");

            // Insert SHOW N VIDEO
            $nmj_data['SHOW_ID'] = handleShow($dbh, $nmj_data, "insert");
            $nmj_data['VIDEO_ID'] = handleVideo($dbh, $nmj_data, "insert");
            handleMediaInfo($dbh, $nmj_data, "update");

            $nmj_data['p_sql_data'] = getPosterData($nmj_data);
            handleImages($dbh, $nmj_data, "updated");

            $nmj_data['t_sql_data'] = getThumbnailData($nmj_data);
            handleShowThumbnail($dbh, $nmj_data, "update");
            handleVideoThumbnail($dbh, $nmj_data, "update");

            $nmj_data['w_sql_data'] = getWallpaperData($nmj_data);
            handleShowWallpaper($dbh, $nmj_data, "update");
            handleVideoWallpaper($dbh, $nmj_data, "update");

            // Insert VIDEO_ATTR
            handleSubtitle($dbh, $nmj_data, "insert");
            handleGenre($dbh, $nmj_data, "insert");
            if ($nmj_data['KEYWORD'] != '')
                handleKeyword($dbh, $nmj_data, "insert");
            if ($nmj_data['DIRECTOR'] != '')
                handleDirector($dbh, $nmj_data, "insert");

            if (isset($nmj_data['synopsis']))
                handleVideoSynopsis($dbh, $nmj_data, "insert");

            if ( (!isset($nmj_data['GROUPS_ID'])) || $nmj_data['GROUPS_ID'] == '')
                $nmj_data = handleVideoGroupName($dbh, $nmj_data, "insert");
            handleVideoGroup($dbh, $nmj_data, "insert");
            break;
        case "updated":
            // Insert VIDEO_PERSON
            if ($nmj_data['CAST_CHANGED'] == 1)
                $nmj_data = handleVideoPerson($dbh, $nmj_data, $mode);

            if (basename($nmj_data['DETAIL_POSTER']) == 'no-poster.jpg')
                $nmj_data['DETAIL_POSTER'] = '';
            if (basename($nmj_data['THUMBNAIL']) == 'no-poster.jpg')
                $nmj_data['THUMBNAIL'] = '';
            if (basename($nmj_data['WALLPAPER']) == 'no-fanart.jpg')
                $nmj_data['WALLPAPER'] = '';

            // Update Show Poster
            $nmj_data = setImageData($nmj_data);

            // Update Video
            if ($nmj_data['VIDEO_CHANGED'] == 1)
                handleVideo($dbh, $nmj_data, $mode);
            if ($nmj_data['POSTER_CHANGED'] == 1 || $nmj_data['THUMBNAIL_CHANGED'] == 1 ||
                            $nmj_data['WALLPAPER_CHANGED'] == 1)
                handleImages($dbh, $nmj_data, $mode);
            if ($nmj_data['SHOW_CHANGED'] == 1)
                handleShow($dbh, $nmj_data, $mode);

            // Update Video Synopsis
            if ($nmj_data['SYNOPSIS_CHANGED'] == 1)
                handleVideoSynopsis($dbh, $nmj_data, $mode);
            if ($nmj_data['GROUPS_CHANGED'] == 1)
                handleVideoGroup($dbh, $nmj_data, $mode);
            if ($nmj_data['GENRE_CHANGED'] == 1)
                handleGenre($dbh, $nmj_data, $mode);
            if ($nmj_data['KEYWORD_CHANGED'] == 1)
                handleKeyword($dbh, $nmj_data, $mode);
            if ($nmj_data['DIRECTOR_CHANGED'] == 1)
                handleDirector($dbh, $nmj_data, $mode);
            if ($nmj_data['SUBTITLE_CHANGED'] == 1)
                handleSubtitle($dbh, $nmj_data, $mode);

            if ($nmj_data['MEDIAINFO_CHANGED'] == 1)
                handleMediaInfo($dbh, $nmj_data, $mode);

            break;
        case "deleted":
            // Delete SHOW N VIDEO
            handleImages($dbh, $nmj_data, $mode);

            handleVideo($dbh, $nmj_data, $mode);
            handleShow($dbh, $nmj_data, $mode);

            handleSubtitle($dbh, $nmj_data, $mode);
            handleGenre($dbh, $nmj_data, $mode);
            handleKeyword($dbh, $nmj_data, $mode);
            handleDirector($dbh, $nmj_data, $mode);

            handleVideoSynopsis($dbh, $nmj_data, $mode);
            handleVideoGroup($dbh, $nmj_data, $mode);
            break;
    }
}

function getIMDBid($imdb_content)
{
    $imdb_content = str_replace("\n\r", "", $imdb_content);
    $imdb_content = str_replace("\r\n", "", $imdb_content);
    $imdb_content = str_replace("\n", "", $imdb_content);
    $imdb_content = str_replace("\r", "", $imdb_content);
    $no_popular_titles = 0;
    $exact_matches = 0;
    $movie = array();

    $result = preg_match("|<title>(.*)</title>|Ui", $imdb_content, $output);
    if ($result > 0) {
        if ($output[1] != "IMDb Title Search") {
            $result = preg_match("|<link rel=\"canonical\" href=\"http://www.imdb.com/title/(.*)/(.*)/>|Ui",
                                 $imdb_content, $output);
            if ($result > 0)
                return (strip_tags($output[1]));
        }
    }

    $result = preg_match("|<p><b>Popular Titles</b>(.*)</table>|Ui", $imdb_content, $output);
    if ($result > 0) {
        $result = preg_match_all("|<img src=\"(.*)\"(.*)<a href=\"/title/(.*)/(.*);\">(.*)</a> \((\d{4})\)(.*)</td></tr>|sUi", $output[0], $titles);
        if ($result > 0) {
            for ($i = 0; $i < count($titles[0]); $i++) {
                $movie[$i] = array_push_assoc($movie[$i], "ID", $titles[3][$i]);
                $movie[$i] = array_push_assoc($movie[$i], "NAME", str_replace('&#x22;', '"', $titles[5][$i]));
                $aka = explode("aka", strip_tags(trim(str_replace('&#x22;', '"', $titles[7][$i]))));
                $movie[$i] = array_push_assoc($movie[$i], "ALTERNATIVE_NAME", trim($aka[2]));
                $movie[$i] = array_push_assoc($movie[$i], "RELEASED", strip_tags(trim($titles[6][$i])));
                //if (strip_tags(trim($titles[1][$i])) == "/images/b.gif")
                $image = "";
                //else
                //$image = str_replace("_SY30_SX23_","_SX92_",strip_tags(trim($titles[1][$i])));
                $movie[$i] = array_push_assoc($movie[$i], "URL", $image);
            }
        }
    }

    $result = preg_match("|<p><b>Titles \(Exact Matches(.*)</table>|Ui", $imdb_content, $output);
    if ($result > 0) {
        $result = preg_match_all("|<img src=\"(.*)\"(.*)<a href=\"/title/(.*)/(.*);\">(.*)</a> \((\d{4}).*\)(.*)</td></tr>|sUi", $output[0], $titles);
        if ($result > 0) {
            $j = count($movie);
            for ($i = 0; $i < count($titles[0]); $i++) {
                $movie[$j + $i] = array_push_assoc($movie[$j + $i], "ID", $titles[3][$i]);
                $movie[$j + $i] = array_push_assoc($movie[$j + $i], "NAME", str_replace('&#x22;', '"', $titles[5][$i]));
                $aka = explode("aka", strip_tags(trim(str_replace('&#x22;', '"', $titles[7][$i]))));
                $movie[$j + $i] = array_push_assoc($movie[$j + $i], "ALTERNATIVE_NAME", trim($aka[1]));
                $movie[$j + $i] = array_push_assoc($movie[$j + $i], "RELEASED", strip_tags(trim($titles[6][$i])));
                //if (strip_tags(trim($titles[1][$i])) == "/images/b.gif")
                $image = "";
                //else
                //$image = str_replace("_SY30_SX23_","_SX92_",strip_tags(trim($titles[1][$i])));
                $movie[$j + $i] = array_push_assoc($movie[$j + $i], "URL", $image);
            }
        }
    }
    if (!isset($movie))
        return "No Matches";
    else if (count($movie) == 1)
        return $movie[0]['ID'];
    else
        return $movie;
}

function sec2hms($sec, $padHours = false)
{
    // start with a blank string
    $hms = "";

    // do the hours first: there are 3600 seconds in an hour, so if we divide
    // the total number of seconds by 3600 and throw away the remainder, we're
    // left with the number of hours in those seconds
    $hours = intval(intval($sec) / 3600);

    // add hours to $hms (with a leading 0 if asked for)
    $hms .= ($padHours)
            ? str_pad($hours, 2, "0", STR_PAD_LEFT) . "h:"
            : $hours . "h:";

    // dividing the total seconds by 60 will give us the number of minutes
    // in total, but we're interested in *minutes past the hour* and to get
    // this, we have to divide by 60 again and then use the remainder
    $minutes = intval(($sec / 60) % 60);

    // add minutes to $hms (with a leading 0 if needed)
    $hms .= str_pad($minutes, 2, "0", STR_PAD_LEFT) . "m:";

    // seconds past the minute are found by dividing the total number of seconds
    // by 60 and using the remainder
    $seconds = intval($sec % 60);

    // add seconds to $hms (with a leading 0 if needed)
    $hms .= str_pad($seconds, 2, "0", STR_PAD_LEFT) . "s";

    // done!
    return $hms;

}

function sec2hm($sec, $padHours = false)
{
    // start with a blank string
    $hm = "";

    // do the hours first: there are 3600 seconds in an hour, so if we divide
    // the total number of seconds by 3600 and throw away the remainder, we're
    // left with the number of hours in those seconds
    $hours = intval(intval($sec) / 3600);

    if ($hours > 1)
        $hrtxt = "hrs ";
    else
        $hrtxt = "hr ";

    // add hours to $hm (with a leading 0 if asked for)
    $hm .= ($padHours)
            ? str_pad($hours, 2, "0", STR_PAD_LEFT) . $hrtxt
            : $hours . $hrtxt;

    // dividing the total seconds by 60 will give us the number of minutes
    // in total, but we're interested in *minutes past the hour* and to get
    // this, we have to divide by 60 again and then use the remainder
    $minutes = intval(($sec / 60) % 60);

    // add minutes to $hm (with a leading 0 if needed)
    $hm .= str_pad($minutes, 2, "0", STR_PAD_LEFT) . "min";

    // done!
    return $hm;

}

function DBQuery($dbh, $sql)
{
    //file_put_contents("sql.txt", $sql . "\n", FILE_APPEND);
    $result = $dbh->query($sql);
    $err = $dbh->errorInfo();
    if (!$result) {
        $dbh = NULL;
        print($sql . "\n");
        die($err[2]);
    }
    else {
        return $result;
    }
}

// Function to Add/Delete/Edit Genre
function handleGenre($dbh, $nmj_data, $mode)
{
    if (isset($nmj_data['GENRE']))
        $genres = explode("#", $nmj_data['GENRE']);
    switch ($mode) {
        case "inserted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                for ($i = 0; $i < count($genres); $i++) {
                    if (isset($genres[$i])) {
                        if ($nmj_data['VIDEO_ID'] != '') {
                            $sql = 'INSERT INTO VIDEO_ATTR VALUES(NULL,' . $nmj_data['VIDEO_ID'] . ',NULL,';
                            $sql .= '"GENRE","' . $genres[$i] . '",';
                            $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                        }
                        if ($nmj_data['SHOW_ID'] != '') {
                            $sql = 'INSERT INTO VIDEO_ATTR VALUES(NULL,NULL,' . $nmj_data['SHOW_ID'] . ',';
                            $sql .= '"GENRE","' . $genres[$i] . '",';
                            $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);

                            $sql = 'INSERT INTO VIDEO_GENRE VALUES(NULL,' . $nmj_data['SHOW_ID'] . ',';
                            $sql .= '"' . $genres[$i] . '",1,NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                        }
                    }
                }
            }
            else {
                if ($nmj_data['SHOW_TYPE'] != 2 || $nmj_data['SHOW_TYPE'] != 3 ||
				$nmj_data['SHOW_TYPE'] != 4) {
                    for ($i = 0; $i < count($genres); $i++) {
                        $sql = 'SELECT ID FROM VIDEO_GENRES WHERE NAME="' . $genres[$i].'"';
                        $result = DBQuery($dbh, $sql);
                        $row = $result->fetch(PDO::FETCH_ASSOC);
                        if (!isset($row['ID'])) {
                            $sql = 'INSERT INTO VIDEO_GENRES VALUES(NULL,"' . $genres[$i] . '",';
                            $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                            $row['ID'] = $dbh->lastInsertId();
                        }
                        if (isset($row['ID'])) {
                            $sql = 'INSERT INTO SHOWS_GENRES VALUES(NULL,' . $row['ID'] . ',';
                            $sql .= $nmj_data['SHOW_ID'].',NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                        }
                    }
                }
            }
            break;
        case "updated":
            handleGenre($dbh, $nmj_data, "deleted");
            handleGenre($dbh, $nmj_data, "inserted");
            break;
        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'DELETE FROM VIDEO_ATTR WHERE SHOW_ID=' . $nmj_data['SHOW_ID'] . ' AND ';
                    $sql .= 'TYPE="GENRE"';
                    DBQuery($dbh, $sql);
                    $sql = 'DELETE FROM VIDEO_GENRE WHERE VIDEO_SHOW_ID=' . $nmj_data['SHOW_ID'];
                    DBQuery($dbh, $sql);
                }
                if ($nmj_data['VIDEO_ID'] != '') {
                    $sql = 'DELETE FROM VIDEO_ATTR WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'] . ' AND ';
                    $sql .= 'TYPE="GENRE"';
                    DBQuery($dbh, $sql);
                }
            }
            else {
               $sql = 'DELETE FROM SHOWS_GENRES WHERE SHOWS_ID=' . $nmj_data['SHOW_ID'];
               DBQuery($dbh, $sql);
            }
            break;
    }
}

// Function to Add/Edit/Delete Keyword
function handleKeyword($dbh, $nmj_data, $mode)
{
    $keywords = explode("#", $nmj_data['KEYWORD']);
    switch ($mode) {
        case "inserted":
            // Insert KEYWORD
            if ($nmj_data['VERSION'] == '1.8.0') {
                for ($i = 0; $i < count($keywords); $i++) {
                    if ($nmj_data['SHOW_TYPE'] != 0) {
                        $sql = 'INSERT INTO VIDEO_ATTR VALUES(NULL,' . $nmj_data['VIDEO_ID'] . ',NULL,';
                        $sql .= '"KEYWORD","' . $keywords[$i] . '",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                        $sql = 'INSERT INTO VIDEO_ATTR VALUES(NULL,NULL,' . $nmj_data['SHOW_ID'] . ',';

                        $sql .= '"KEYWORD","' . $keywords[$i] . '",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
            }
            else {
                if ($nmj_data['SHOW_TYPE'] != 2 || $nmj_data['SHOW_TYPE'] != 3 ||
				$nmj_data['SHOW_TYPE'] != 4) {
                    for ($i = 0; $i < count($keywords); $i++) {
                        $sql = 'SELECT ID FROM KEYWORDS WHERE KEYWORD="' . $keywords[$i].'"';
                        $result = DBQuery($dbh, $sql);
                        $row = $result->fetch(PDO::FETCH_ASSOC);
                        if (!isset($row['ID'])) {
                            $sql = 'INSERT INTO KEYWORDS VALUES(NULL,"' . $keywords[$i] . '",';
                            $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                            $row['ID'] = $dbh->lastInsertId();
                        }
                        if (isset($row['ID'])) {
                            $sql = 'INSERT INTO SHOWS_KEYWORDS VALUES(NULL,' . $row['ID'] . ',';
                            $sql .= $nmj_data['SHOW_ID'].',NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                        }
                    }
                }
            }
            break;
        case "updated":
            handleKeyword($dbh, $nmj_data, "deleted");
            handleKeyword($dbh, $nmj_data, "inserted");
            break;
        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if ($nmj_data['SHOW_TYPE'] != 0) {
                    $sql = 'DELETE FROM VIDEO_ATTR WHERE SHOW_ID=' . $nmj_data['SHOW_ID'] . ' AND ';
                    $sql .= 'TYPE="KEYWORD"';
                    DBQuery($dbh, $sql);

                    $sql = 'DELETE FROM VIDEO_ATTR WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'] . ' AND ';
                    $sql .= 'TYPE="KEYWORD"';
                    DBQuery($dbh, $sql);
                }
            }
            else {
               $sql = 'DELETE FROM SHOWS_KEYWORDS WHERE SHOWS_ID=' . $nmj_data['SHOW_ID'];
               DBQuery($dbh, $sql);
            }
            break;
    }
}

// Function to Add/Edit/Delete Director
function handleDirector($dbh, $nmj_data, $mode)
{
    $director = explode("#", $nmj_data['DIRECTOR']);
    switch ($mode) {
        case "inserted":
            // Insert DIRECTOR
            if ($nmj_data['VERSION'] == '1.8.0') {
                for ($i = 0; $i < count($director); $i++) {
                    $sql = 'SELECT VIDEO_PERSON_ID FROM "VIDEO_PERSON" WHERE NAME="' . $director[$i] . '"';
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);
                    if (!isset($row['VIDEO_PERSON_ID'])) {
                        $sql = 'INSERT INTO "VIDEO_PERSON" VALUES(NULL,';
                        $sql .= '"' . $director[$i] . '",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                        $row['VIDEO_PERSON_ID'] = $dbh->lastInsertId();
                    }
                    if (isset($row['VIDEO_PERSON_ID'])) {
                        if ($nmj_data['VIDEO_ID'] != '') {
                            $sql = 'INSERT INTO VIDEO_ATTR VALUES(NULL,' . $nmj_data['VIDEO_ID'] . ',NULL,"DIRECTOR",';
                            $sql .= '"' . $director[$i] . '",' . $row['VIDEO_PERSON_ID'] . ',';
                            $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                        }
                        if ($nmj_data['SHOW_ID'] != '') {
                            $sql = 'INSERT INTO VIDEO_ATTR VALUES(NULL,NULL,' . $nmj_data['SHOW_ID'] . ',"DIRECTOR",';
                            $sql .= '"' . $director[$i] . '",' . $row['VIDEO_PERSON_ID'] . ',';
                            $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                        }
                    }
                }
            }
            else {
                for ($i = 0; $i < count($director); $i++) {
                    $sql = 'SELECT ID FROM VIDEO_PERSONS WHERE NAME="' . $director[$i].'"';
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);
                    if (!isset($row['ID'])) {
                        $sql = 'INSERT INTO VIDEO_PERSONS VALUES(NULL,"' . $director[$i] . '",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                        $row['ID'] = $dbh->lastInsertId();
                    }
                    if (isset($row['ID'])) {
                        $sql = 'INSERT INTO SHOWS_PERSONS VALUES(NULL,' . $row['ID'] . ',';
                        $sql .= $nmj_data['SHOW_ID'].',"DIRECTOR",NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
            }
            break;
        case "updated":
            handleDirector($dbh, $nmj_data, "deleted");
            handleDirector($dbh, $nmj_data, "inserted");
            break;
        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'DELETE FROM VIDEO_ATTR WHERE SHOW_ID=' . $nmj_data['SHOW_ID'] . ' AND ';
                    $sql .= 'TYPE="DIRECTOR"';
                    DBQuery($dbh, $sql);
                }
                if ($nmj_data['VIDEO_ID'] != '') {
                    $sql = 'DELETE FROM VIDEO_ATTR WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'] . ' AND ';
                    $sql .= 'TYPE="DIRECTOR"';
                    DBQuery($dbh, $sql);
                }
            }
            else {
               $sql = 'DELETE FROM SHOWS_PERSONS WHERE SHOWS_ID=' . $nmj_data['SHOW_ID'];
               $sql.= ' AND PERSON_TYPE="DIRECTOR"';
               DBQuery($dbh, $sql);
            }
            break;
    }
}

// Function to Add/Edit/Delete VideoAttr
function handleSubtitle($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        // Insert
        case "inserted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if (isset($nmj_data['SUBTITLE']) && $nmj_data['SUBTITLE'] != '') {
                    $subtitle = explode("#", $nmj_data['SUBTITLE']);
                    for ($i = 0; $i < count($subtitle); $i++) {
                        $sql = 'INSERT INTO VIDEO_ATTR VALUES(NULL,';
                        $sql .= $nmj_data['VIDEO_ID'] . ',';
                        $sql .= 'NULL,';
                        $sql .= '"SUBTITLE",';
                        $sql .= '"' . $subtitle[$i] . '",';
                        $sql .= 'NULL,';
                        $sql .= (strpos($subtitle[$i], "/") === false)? '"INTERNAL",' : '"EXTERNAL",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
                $sql = 'SELECT VIDEO_ATTR_ID FROM VIDEO_ATTR WHERE ';
                $sql .= 'VIDEO_ID=' . $nmj_data['VIDEO_ID'] . ' AND TYPE="TITLE_TYPE"';
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                if (!isset($row['VIDEO_ATTR_ID'])) {
                    $sql = 'INSERT INTO VIDEO_ATTR VALUES(NULL,';
                    $sql .= $nmj_data['VIDEO_ID'] . ',';
                    $sql .= 'NULL,';
                    $sql .= '"TITLE_TYPE",';
                    $sql .= '"feature",';
                    $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                }
            }
            else {
                if (isset($nmj_data['SUBTITLE']) && $nmj_data['SUBTITLE'] != '') {
                    $subtitle = explode("#", $nmj_data['SUBTITLE']);
                    for ($i = 0; $i < count($subtitle); $i++) {
                        $sql = 'INSERT INTO VIDEO_SUBTITLES VALUES(NULL,';
                        $sql .= $nmj_data['VIDEO_ID'] . ',';
                        $sql .= (strpos($subtitle[$i], "/") === false)? 'NULL,' : '"'.$subtitle[$i].'",';
                        $sql .= (strpos($subtitle[$i], "/") === false)? '"'.$subtitle[$i].'",' : '"EXTERNAL",';
                        $sql .= '0,';
                        $sql .= '"'.date("Y-m-d H:i:s").'",';
                        $sql .= (strpos($subtitle[$i], "/") === false)? '"INTERNAL",' : '"EXTERNAL",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
            }   
            break;

        // Update
        case "updated":
            handleSubtitle($dbh, $nmj_data, "deleted");
            handleSubtitle($dbh, $nmj_data, "inserted");
            break;

        // Delete GENRE
        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                $sql = 'DELETE FROM VIDEO_ATTR WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'] . ' AND ';
                $sql .= 'TYPE="SUBTITLE"';
                DBQuery($dbh, $sql);
            }
            else {
                $sql = 'DELETE FROM VIDEO_SUBTITLES WHERE VIDEOS_ID=' . $nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            }
            break;
    }
}

function handleMediaInfo($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        case "updated":
            if ($nmj_data['VERSION'] == '1.8.0') {
                // Update Show
                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'UPDATE SHOW SET ';
                    $sql .= 'RESOLUTION="' . $nmj_data['RESOLUTION'] . '",';
                    $sql .= 'WIDTH="' . $nmj_data['WIDTH'] . '",';
                    $sql .= 'HEIGHT="' . $nmj_data['HEIGHT'] . '",';
                    $sql .= 'SYSTEM="' . $nmj_data['SYSTEM'] . '",';
                    $sql .= 'VIDEO_CODEC="' . $nmj_data['VIDEO_CODEC'] . '",';
                    $sql .= 'FPS="' . $nmj_data['FPS'] . '",';
                    $sql .= 'CREATE_TIME="' . $nmj_data['CREATE_TIME'] . '" ';
                    $sql .= ' WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                    DBQuery($dbh, $sql);
                }

                // Update VIDEO
                if ($nmj_data['VIDEO_ID'] != '') {
                    $sql = 'UPDATE VIDEO SET ';
                    $sql .= 'RESOLUTION="' . $nmj_data['RESOLUTION'] . '",';
                    $sql .= 'WIDTH="' . $nmj_data['WIDTH'] . '",';
                    $sql .= 'HEIGHT="' . $nmj_data['HEIGHT'] . '",';
                    $sql .= 'SYSTEM="' . $nmj_data['SYSTEM'] . '",';
                    $sql .= 'VIDEO_CODEC="' . $nmj_data['VIDEO_CODEC'] . '",';
                    $sql .= 'FPS="' . $nmj_data['FPS'] . '",';
                    $sql .= 'CREATE_TIME="' . $nmj_data['CREATE_TIME'] . '",';
                    $sql .= 'RUNTIME="' . $nmj_data['RUNTIME'] . '",';
                    $sql .= 'ASPECT_RATIO="' . $nmj_data['ASPECT_RATIO'] . '",';
                    $sql .= 'SIZE="' . $nmj_data['SIZE'] . '" ';
                    $sql .= ' WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'];
                    DBQuery($dbh, $sql);
                }
            }
            else {
                $sql = 'UPDATE VIDEO_PROPERTIES SET ';
                $sql .= 'RUNTIME=' . $nmj_data['RUNTIME'] . ',';
                $sql .= 'RESOLUTION="' . $nmj_data['RESOLUTION'] . '",';
                $sql .= 'WIDTH="' . $nmj_data['WIDTH'] . '",';
                $sql .= 'HEIGHT="' . $nmj_data['HEIGHT'] . '",';
                $sql .= 'ASPECT_RATIO="' . $nmj_data['ASPECT_RATIO'] . '",';
                $sql .= 'SYSTEM="' . $nmj_data['SYSTEM'] . '",';
                $sql .= 'VIDEO_CODEC="' . $nmj_data['VIDEO_CODEC'] . '",';
                $sql .= 'FPS="' . $nmj_data['FPS'] . '" ';
                $sql .= ' WHERE ID=' . $nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            }
            break;
    }
}

// Function to Add/Edit/Delete Show And Video
function setImageData($nmj_data)
{
    global $optimize_poster, $convert_location;
    global $optimize_wallpaper, $optimize_thumbnail;

    if (isset($nmj_data['DETAIL_POSTER']) && $nmj_data['DETAIL_POSTER'] != '') {
        if (!is_file($nmj_data['DRIVE_PATH'] . $nmj_data['DETAIL_POSTER'])) {
            $poster_url = str_replace("/w185/", "/w500/", $nmj_data['DETAIL_POSTER']);
            if (is_file($nmj_data['DRIVE_PATH'].$nmj_data['PATH']))
                $fname = substr(basename($nmj_data['PATH']), 0, strrpos(basename($nmj_data['PATH']), ".")).".jpg";
            else
                $fname = basename($nmj_data['PATH']).".jpg";
            $poster_fname = "poster_s_" . $nmj_data['SHOW_ID']."_".$fname;
            $nmj_data['DETAIL_POSTER'] = "nmj_database/media/video/poster/" . $poster_fname;
            $command = 'wget -qO- "'. $poster_url.'"|'.$convert_location . ' -  -resize 202 "'.$nmj_data['DRIVE_PATH'].$nmj_data['DETAIL_POSTER'].'"';
            shell_exec($command);
        }
    }
    if (isset($nmj_data['THUMBNAIL']) && $nmj_data['THUMBNAIL'] != '') {
        if (!is_file($nmj_data['DRIVE_PATH'] . $nmj_data['THUMBNAIL'])) {
            $thumb_url = str_replace("/w185/", "/w500/", $nmj_data['THUMBNAIL']);
            if (is_file($nmj_data['DRIVE_PATH'].$nmj_data['PATH']))
                $fname = substr(basename($nmj_data['PATH']), 0, strrpos(basename($nmj_data['PATH']), ".")).".jpg";
            else
                $fname = basename($nmj_data['PATH']).".jpg";
            $thumb_fname = "thumbnail_s_" . $nmj_data['SHOW_ID']."_".$fname;
            $nmj_data['THUMBNAIL'] = "nmj_database/media/video/thumbnail/" . $thumb_fname;
            $command = 'wget -qO- "'. $thumb_url.'"|'.$convert_location . ' -  -resize 124 "'.$nmj_data['DRIVE_PATH'].$nmj_data['THUMBNAIL'].'"';
            shell_exec($command);
        }
    }
    if (isset($nmj_data['WALLPAPER']) && $nmj_data['WALLPAPER'] != '') {
        if (!is_file($nmj_data['DRIVE_PATH'] . $nmj_data['WALLPAPER'])) {
            $wallpaper_url = str_replace("/w300/", "/w1280/", $nmj_data['WALLPAPER']);
            if (!file_exists($nmj_data['DRIVE_PATH'] . "nmj_database/media/video/wallpaper/"))
                mkdir($nmj_data['DRIVE_PATH'] . "nmj_database/media/video/wallpaper/", 0777, true);
            if (is_file($nmj_data['DRIVE_PATH'].$nmj_data['PATH']))
                $fname = substr(basename($nmj_data['PATH']), 0, strrpos(basename($nmj_data['PATH']), ".")).".jpg";
            else
                $fname = basename($nmj_data['PATH']).".jpg";
            $wall_fname = "wallpaper_s_" . $nmj_data['SHOW_ID']."_".$fname;
            $nmj_data['WALLPAPER'] = "nmj_database/media/video/wallpaper/". $wall_fname;
            shell_exec('wget -q ' . $wallpaper_url . ' -O "'.$nmj_data['DRIVE_PATH'].$nmj_data['WALLPAPER'].'"');
        }
    }
    return $nmj_data;
}

// Function to Add/Edit/Delete Show And Video
function handleImages($dbh, $nmj_data, $mode)
{
    global $delete_images;
    switch ($mode) {
        case "updated":
            if ($nmj_data['VERSION'] == '1.8.0') {
                $sql = 'UPDATE SHOW SET DETAIL_POSTER="' . $nmj_data['DETAIL_POSTER'] . '",';
                $sql.= 'THUMBNAIL="' . $nmj_data['THUMBNAIL'] . '",';
                $sql.= 'WALLPAPER="' . $nmj_data['WALLPAPER'] . '" ';
                $sql.= 'WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                DBQuery($dbh, $sql);

                $sql = 'UPDATE VIDEO SET DETAIL_POSTER="' . $nmj_data['DETAIL_POSTER'] . '",';
                $sql.= 'THUMBNAIL="' . $nmj_data['THUMBNAIL'] . '",';
                $sql.= 'WALLPAPER="' . $nmj_data['WALLPAPER'] . '" ';
                $sql.= 'WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            }
            else {
                $sql = 'UPDATE VIDEO_POSTERS SET POSTER="' . $nmj_data['DETAIL_POSTER'] . '",';
                $sql.= 'THUMBNAIL="' . $nmj_data['THUMBNAIL'] . '",';
                $sql.= 'WALLPAPER="' . $nmj_data['WALLPAPER'] . '",';
                $sql.= 'TYPE="1",';
                $sql.= 'CREATE_TIME="'.date("Y-m-d H:i:s").'" ';
                $sql.= 'WHERE ID=' . $nmj_data['SHOW_ID'];
                DBQuery($dbh, $sql);
            }
            break;

        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                $sql = 'UPDATE SHOW SET DETAIL_POSTER="",';
                $sql = 'THUMBNAIL="",';
                $sql = 'WALLPAPER="" ';
                $sql .= 'WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                DBQuery($dbh, $sql);

                $sql = 'UPDATE VIDEO SET DETAIL_POSTER="",';
                $sql = 'THUMBNAIL="",';
                $sql = 'WALLPAPER="" ';
                $sql .= 'WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            }
            else {
                $sql = 'UPDATE VIDEO_POSTERS SET POSTER=NULL,';
                $sql.= 'THUMBNAIL=NULL,';
                $sql.= 'WALLPAPER=NULL,';
                $sql.= 'TYPE=NULL,';
                $sql.= 'CREATE_TIME="'.date("Y-m-d H:i:s").'" ';
                $sql.= 'WHERE ID=' . $nmj_data['SHOW_ID'];
                DBQuery($dbh, $sql);
            }
            if ($delete_images == "yes") {
                if (file_exists($nmj_data['DRIVE_PATH'] . $row['DETAIL_POSTER']))
                    unlink($nmj_data['DRIVE_PATH'] . $row['DETAIL_POSTER']);
                if (file_exists($nmj_data['DRIVE_PATH'] . $row['THUMBNAIL']))
                    unlink($nmj_data['DRIVE_PATH'] . $row['THUMBNAIL']);
                if (file_exists($nmj_data['DRIVE_PATH'] . $row['WALLPAPER']))
                    unlink($nmj_data['DRIVE_PATH'] . $row['WALLPAPER']);
            }
            break;
    }
}

// Function to Add/Edit/Delete Show And Video
function handleShow($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        case "inserted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                $sql = 'INSERT INTO SHOW VALUES(NULL,';
                $sql .= '"' . $nmj_data['TITLE'] . '",';
                $sql .= '"' . $nmj_data['SEARCH_TITLE'] . '",';
                $sql .= 'NULL,1,';
                $sql .= '"' . $nmj_data['RELEASE_DATE'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= '"' . $nmj_data['RATING'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= $nmj_data['PARENTAL_RATING'] . ',';
                $sql .= 'NULL,';
                $sql     .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= $nmj_data['SHOW_TYPE'] . ',';
                $sql .= 'NULL,';
                $sql .= '"' . $nmj_data['CAST_ID'] . '",';
                $sql .= '3,';
                $sql .= '"' . $nmj_data['TTID'] . '",';
                $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
                $showid = $dbh->lastInsertId();
                return $showid;
            }
            else {
                $sql = 'INSERT INTO SHOWS VALUES(NULL,';
                $sql .= '"' . $nmj_data['TITLE'] . '",';
                $sql .= '"' . $nmj_data['SEARCH_TITLE'] . '",';
                $sql .= 'NULL,1,';
                $sql .= '"' . $nmj_data['RELEASE_DATE'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= '"' . $nmj_data['RATING'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= $nmj_data['PARENTAL_RATING'] . ',';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
		$sql .= 'NULL,';
		$sql .= $nmj_data['SHOW_TYPE'] . ',';
                $sql .= 'NULL,';
                $sql .= '"' . $nmj_data['CAST_ID'] . '",';
                $sql .= '3,';
                $sql .= '"' . $nmj_data['TTID'] . '",';
                $sql .= '0,NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
                $showid = $dbh->lastInsertId();
            }
            break;

        // Update
        case "updated":
            // Update Show
            if ($nmj_data['VERSION'] == '1.8.0') {
                $sql = 'UPDATE SHOW SET TITLE="' . $nmj_data['TITLE'] . '",';
                $sql .= 'SEARCH_TITLE="' . $nmj_data['SEARCH_TITLE'] . '",';
                $sql .= 'RELEASE_DATE="' . $nmj_data['RELEASE_DATE'] . '",';
                $sql .= 'RATING="' . $nmj_data['RATING'] . '",';
                $sql .= 'PARENTAL_RATING="' . $nmj_data['PARENTAL_RATING'] . '",';
                $sql .= 'SHOW_TYPE=' . $nmj_data['SHOW_TYPE'] . ',';
                $sql .= 'TOTAL_ITEM=' . $nmj_data['TOTAL_ITEM'] . ',';
                $sql .= 'CAST_ID="' . $nmj_data['CAST_ID'] . '",';
                $sql .= 'TTID="' . $nmj_data['TTID'] . '" WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
            }
            else {
                $sql = 'UPDATE SHOWS SET TITLE="' . $nmj_data['TITLE'] . '",';
                $sql .= 'SEARCH_TITLE="' . $nmj_data['SEARCH_TITLE'] . '",';
                $sql .= 'TOTAL_ITEM=' . $nmj_data['TOTAL_ITEM'] . ',';
                $sql .= 'YEAR="' . $nmj_data['RELEASE_DATE'] . '",';
                $sql .= 'RELEASE_DATE="' . $nmj_data['RELEASE_DATE'] . '",';
                $sql .= 'RATING="' . $nmj_data['RATING'] . '",';
                $sql .= 'PARENTAL_CONTROL="' . $nmj_data['PARENTAL_RATING'] . '",';
                $sql .= 'RUNTIME=' . $nmj_data['RUNTIME'] . ',';
                $sql .= 'UPDATE_STATE=6,';
                $sql .= 'TITLE_TYPE="' . $nmj_data['SHOW_TYPE'] . '",';
                $sql .= 'TTID="' . $nmj_data['TTID'] . '" WHERE ID=' . $nmj_data['SHOW_ID'];
            }
            DBQuery($dbh, $sql);
            break;

        // Delete
        case "deleted":
            // Check any VIDEO is using SHOW_ID
            if ($nmj_data['VERSION'] == '1.8.0') {
                $sql = 'SELECT VIDEO_ID FROM VIDEO WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                if (!isset($row['VIDEO_ID'])) {
                    $sql = 'DELETE FROM SHOW WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                    DBQuery($dbh, $sql);
                }
            }
            else {
                $sql = 'DELETE FROM SHOWS WHERE ID=' . $nmj_data['SHOW_ID'];
                DBQuery($dbh, $sql);
            }
            break;
    }
}

// Function to Add/Edit/Delete Show And Video
function handleVideo($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        case "inserted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if ($nmj_data['SHOW_ID'] != 0) {
                    $sql = 'INSERT INTO VIDEO VALUES(NULL,';
                    $sql .= '"' . $nmj_data['TITLE'] . '",';
                    $sql .= '"' . $nmj_data['SEARCH_TITLE'] . '",';
                    $sql .= '"' . $nmj_data['RELEASE_DATE'] . '",';
                    $sql .= '"' . $nmj_data['PATH'] . '",';
                    $sql .= 'NULL,';
                    $sql .= 'NULL,';
                    $sql .= '0,';
                    $sql .= '"' . $nmj_data['RATING'] . '",';
                    $sql .= 'NULL,';
                    $sql .= 'NULL,';
                    $sql .= 'NULL,';
                    $sql .= 'NULL,';
                    $sql .= '"' . $nmj_data['PARENTAL_RATING'] . '",';
                    $sql .= 'NULL,';
                    $sql .= 'NULL,';
                    $sql .= '0,';
                    $sql .= '0,';
                    $sql .= '0,';
                    $sql .= $nmj_data['SHOW_ID'] . ',';
                    $sql .= '0,';
                    $sql .= 'NULL,';
                    $sql .= 'NULL,';
                    $sql .= '"' . $nmj_data['CAST_ID'] . '",';
                    $sql .= '2,';
                    $sql .= 'NULL,NULL,';
                    $sql .= '"' . $nmj_data['TTID'] . '",';
                    $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
                $videoid = $dbh->lastInsertId();
                return $videoid;
            }
        }
        else {
            $sql = 'INSERT INTO VIDEOS VALUES(NULL,';
            $sql .= '"' . $nmj_data['PATH'] . '",';
            $sql .= 'NULL,';
            $sql .= 'NULL,';
            $sql .= '0,';
            $sql .= '"' . $nmj_data['RATING'] . '",';
            $sql .= 'NULL,';
            $sql .= 'NULL,';
            $sql .= 'NULL,';
            $sql .= 'NULL,';
            $sql .= '"' . $nmj_data['PARENTAL_RATING'] . '",';
            $sql .= 'NULL,';
            $sql .= 'NULL,';
            $sql .= '0,';
            $sql .= '0,';
            $sql .= '0,';
            $sql .= $nmj_data['SHOW_ID'] . ',';
            $sql .= '0,';
            $sql .= 'NULL,';
            $sql .= 'NULL,';
            $sql .= '"' . $nmj_data['CAST_ID'] . '",';
            $sql .= '2,';
            $sql .= 'NULL,NULL,';
            $sql .= '"' . $nmj_data['TTID'] . '",';
            $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
            DBQuery($dbh, $sql);
            $videoid = $dbh->lastInsertId();
            return $videoid;
	}
	break;

        // Update
        case "updated":
            if ($nmj_data['VERSION'] == '1.8.0') {
                // Update VIDEO
                $sql = 'UPDATE VIDEO SET TITLE="' . $nmj_data['TITLE'] . '",';
                $sql .= 'SEARCH_TITLE="' . $nmj_data['SEARCH_TITLE'] . '",';
                $sql .= 'RELEASE_DATE="' . $nmj_data['RELEASE_DATE'] . '",';
                $sql .= 'PATH="' . $nmj_data['PATH'] . '",';
                $sql .= 'RUNTIME="' . $nmj_data['RUNTIME'] . '",';
                $sql .= 'RATING="' . $nmj_data['RATING'] . '",';
                $sql .= 'PARENTAL_RATING="' . $nmj_data['PARENTAL_RATING'] . '",';
                $sql .= 'SHOW_ID=' . $nmj_data['SHOW_ID'] . ',';
                $sql .= 'EPISODE="' . $nmj_data['EPISODE'] . '",';
                $sql .= 'CAST_ID="' . $nmj_data['CAST_ID'] . '",';
                $sql .= 'SEASON="' . $nmj_data['SEASON'] . '",';
                $sql .= 'TTID="' . $nmj_data['TTID'] . '" WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            }
            else {
                $sql = 'UPDATE VIDEOS SET ';
                $sql .= 'PATH="' . $nmj_data['PATH'] . '",';
                $sql .= 'UPDATE_STATE="6",';
                $sql .= 'SIZE=' . $nmj_data['SIZE'];
                $sql .= ' WHERE ID=' . $nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            }
            break;

        // Delete
        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                $sql = 'DELETE FROM VIDEO WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'];
                $sql .= ' AND SHOW_ID=' . $nmj_data['SHOW_ID'];
                DBQuery($dbh, $sql);
            }
            else {
                $sql = 'DELETE FROM VIDEOS WHERE ID='.$nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            }
            break;
    }
}

// Function to Add/Edit/Delete Video Synopsis
function handleVideoSynopsis($dbh, $nmj_data, $mode)
{
    if ($nmj_data['CONTENT'] == '')
        $synopsis = 'NULL';
    else
        $synopsis = '"' . setXMLSafe($nmj_data['CONTENT']) . '"';
    switch ($mode) {
        case "inserted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                // Insert
                if ($nmj_data['VIDEO_ID'] != '') {
                    $sql = 'INSERT INTO VIDEO_SYNOPSIS VALUES(NULL,' . $nmj_data['VIDEO_ID'] . ',NULL,"EN",';
                    $sql .= $synopsis . ',NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                }
                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'INSERT INTO VIDEO_SYNOPSIS VALUES(NULL,NULL,' . $nmj_data['SHOW_ID'] . ',"EN",';
                    $sql .= $synopsis . ',NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                }
            }
            else {
                $sql = 'INSERT INTO SYNOPSISES VALUES('.$nmj_data['SHOW_ID'].',' . $synopsis . ',NULL,';
                $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
            }
            break;

        // Update
        case "updated":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if ($nmj_data['VIDEO_ID'] != '') {
                    $sql = 'SELECT VIDEO_SYNOPSIS_ID FROM VIDEO_SYNOPSIS WHERE ';
                    $sql .= 'VIDEO_ID=' . $nmj_data['VIDEO_ID'];
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);
                    if (isset($row['VIDEO_SYNOPSIS_ID'])) {
                        $sql = 'UPDATE VIDEO_SYNOPSIS SET CONTENT=' . $synopsis . ' ';
                        $sql .= 'WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'];
                        DBQuery($dbh, $sql);
                    }
                    else
                        handleVideoSynopsis($dbh, $nmj_data, "inserted");
                }

                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'SELECT VIDEO_SYNOPSIS_ID FROM VIDEO_SYNOPSIS WHERE ';
                    $sql .= 'SHOW_ID=' . $nmj_data['SHOW_ID'];
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);
                    if (isset($row['VIDEO_SYNOPSIS_ID'])) {
                        $sql = 'UPDATE VIDEO_SYNOPSIS SET CONTENT=' . $synopsis . ' ';
                        $sql .= 'WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                        DBQuery($dbh, $sql);
                    }
                    else
                        handleVideoSynopsis($dbh, $nmj_data, "inserted");
                }
            }
            else {
                $sql = 'SELECT SUMMARY FROM SYNOPSISES WHERE ';
                $sql .= 'ID=' . $nmj_data['SHOW_ID'];
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                if (isset($row['SUMMARY'])) {
                    $sql = 'UPDATE SYNOPSISES SET SUMMARY=' . $synopsis . ' ';
                    $sql .= 'WHERE ID=' . $nmj_data['SHOW_ID'];
                    DBQuery($dbh, $sql);
                }
                else
                    handleVideoSynopsis($dbh, $nmj_data, "inserted");
            }
            break;

        // Delete
        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if ($nmj_data['VIDEO_ID'] != '') {
                    $sql = 'DELETE FROM VIDEO_SYNOPSIS WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'];
                    DBQuery($dbh, $sql);
                }

                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'DELETE FROM VIDEO_SYNOPSIS WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                    DBQuery($dbh, $sql);
                }
            }
            else {
            }
            break;
    }
}

// Function to Add/Delete Video Group Name (i.e. movie by alphabet)
function handleVideoGroupName($dbh, $nmj_data, $mode)
{
    $search = array("A ", "An ", "The ", "Le ", "Les ", "&quot;");
    $replace = array("", "", "", "", "", "");
    if (isset($nmj_data['TITLE']))
        $alphabet = strtoupper(substr(str_replace($search, $replace, $nmj_data['TITLE']), 0, 1));
    switch ($mode) {
        case "inserted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                // Insert
                $sql = 'SELECT VIDEO_GROUP_NAME_ID FROM VIDEO_GROUP_NAME WHERE NAME="' . $alphabet . '"';
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                if (!isset($row['VIDEO_GROUP_NAME_ID'])) {
                    $sql = 'INSERT INTO VIDEO_GROUP_NAME VALUES(NULL,';
                    $sql.= '"' . $alphabet . '","EN",NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                    $nmj_data['GROUPS_ID'] = $dbh->lastInsertId();
                }
                else
                    $nmj_data['GROUPS_ID'] = $row['VIDEO_GROUP_NAME_ID'];
            }
            else {
                $sql = 'SELECT ID FROM SHOW_GROUPS WHERE NAME="' . $alphabet. '"';
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                if (!isset($row['ID'])) {
                    $sql = 'INSERT INTO SHOW_GROUPS VALUES(NULL,';
                    $sql.= '"' . $alphabet . '",NULL,"EN",NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                    $nmj_data['GROUPS_ID'] = $dbh->lastInsertId();
                }
                else
                    $nmj_data['GROUPS_ID'] = $row['ID'];
            }
            return $nmj_data;
            break;
    }
}

// Function to Add/Delete/Edit MPAA
function handleVideoGroup($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        case "inserted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                // Insert
                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'INSERT INTO VIDEO_GROUP VALUES(NULL,' . $nmj_data['GROUPS_ID'] . ',NULL,';
                    $sql .= $nmj_data['SHOW_ID'] . ',"' . $nmj_data['PARENTAL_RATING'] . '",' . $nmj_data['SHOW_TYPE'] . ',';
                    $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                }
            }
            else {
                $sql = 'INSERT INTO SHOW_GROUPS_SHOWS VALUES(NULL,'. $nmj_data['GROUPS_ID'] . ',';
                $sql .= $nmj_data['SHOW_ID'] . ',"' . $nmj_data['SHOW_TYPE'] . '",';
                $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
            }
            break;

        // Update
        case "updated":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'UPDATE VIDEO_GROUP SET PARENTAL_RATING="' . $nmj_data['PARENTAL_RATING'] . '",';
                    $sql .= 'VIDEO_GROUP_NAME_ID=' . $nmj_data['GROUPS_ID'] . ',';
                    $sql .= 'SHOW_TYPE=' . $nmj_data['SHOW_TYPE'] . ' WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                    DBQuery($dbh, $sql);
                }
            }
            else {
                $sql = 'UPDATE SHOW_GROUPS_SHOWS SET GROUPS_ID=' . $nmj_data['GROUPS_ID'] . ',';
                $sql .= 'TITLE_TYPE=' . $nmj_data['SHOW_TYPE'];
                $sql .= ' WHERE SHOWS_ID=' . $nmj_data['SHOW_ID'];
                DBQuery($dbh, $sql);
            }
            break;

        // Delete
        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                if ($nmj_data['SHOW_ID'] != '') {
                    $sql = 'DELETE FROM VIDEO_GROUP WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
                    DBQuery($dbh, $sql);
                }
            }
            else {
                $sql = 'DELETE FROM SHOW_GROUPS_SHOWS WHERE SHOWS_ID=' . $nmj_data['SHOW_ID'];
                DBQuery($dbh, $sql);
            }
            break;
    }
}

// Function to Add/Remove/Edit Person
function handleVideoPerson($dbh, $nmj_data, $mode)
{
    $cast = explode("#", $nmj_data['CAST']);
    $cast_array = array();
    $cast_array[0] = 0;
    switch ($mode) {
        case "inserted":
            // Insert
            if ($nmj_data['VERSION'] == '1.8.0') {
                for ($i = 0; $i < count($cast); $i++) {
                    $actor = str_replace('&#039;', '&apos;', $cast[$i]);
                    $sql = 'SELECT VIDEO_PERSON_ID FROM VIDEO_PERSON WHERE ';
                    $sql .= 'NAME="' . $actor . '"';
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);

                    if (!isset($row['VIDEO_PERSON_ID'])) {
                        $sql = 'INSERT INTO "VIDEO_PERSON" VALUES(NULL,';
                        $sql .= '"' . $actor . '",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                        $cast_array[$i + 1] = $dbh->lastInsertId();
                    }
                    else
                        $cast_array[$i + 1] = $row['VIDEO_PERSON_ID'];
                }

                $sql = 'SELECT VIDEO_PERSON_ID FROM VIDEO_ATTR WHERE SHOW_ID=' . $nmj_data['SHOW_ID'] . ' AND TYPE="DIRECTOR"';
                foreach ($dbh->query($sql) as $row)
                    $cast_array[count($cast_array)] = $row['VIDEO_PERSON_ID'];

                $cast_array[count($cast_array)] = 0;
                $nmj_data['CAST_ID'] = implode(",", $cast_array);
            }
            else {
                for ($i = 0; $i < count($cast); $i++) {
                    $sql = 'SELECT ID FROM VIDEO_PERSONS WHERE ';
                    $sql.= 'NAME="'.$cast[$i].'"';
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);
                    if (!isset($row['ID'])) {
                        $sql = 'INSERT INTO "VIDEO_PERSONS" VALUES(NULL,';
                        $sql .= '"' . $cast[$i] . '",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                        $row['ID'] = $dbh->lastInsertId();
                    }
                    if (isset($row['ID'])) {
                        $sql = 'INSERT INTO SHOWS_PERSONS VALUES(NULL,' . $row['ID'] . ',';
                        $sql .= $nmj_data['SHOW_ID'].',"CAST",NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
            }
            return $nmj_data;
            break;
        case "updated":
            handleVideoPerson($dbh, $nmj_data, "deleted");
            handleVideoPerson($dbh, $nmj_data, "inserted");
            return $nmj_data;
            break;
        case "deleted":
            if ($nmj_data['VERSION'] == '1.8.0') {
                // Do nothing for pre-NMJV2
            }
            else {
               $sql = 'DELETE FROM SHOWS_PERSONS WHERE SHOWS_ID=' . $nmj_data['SHOW_ID'];
               $sql.= ' AND PERSON_TYPE="CAST"';
               DBQuery($dbh, $sql);
            }
            break;
    }
}

function print_version()
{
    global $homedir;
    $appinfo = $homedir . "/version.txt";
    if (file_exists($appinfo)) {
        $data = file_get_contents($appinfo);
        return trim($data);
    }
    else
        return "unknown";
}

function getImageFromTMDB($imdbid)
{
    $API_KEY = "b626260be86175272e48fa6347e58100";

    $command = 'wget -qO- "http://api.themoviedb.org/2.1/Movie.getImages/en/xml/' . $API_KEY . '/' . $imdbid . '"';
    $tmdbxml = shell_exec($command);

    $xml_parser = xml_parser_create();
    xml_parse_into_struct($xml_parser, $tmdbxml, $vals, $index);
    xml_parser_free($xml_parser);

    $i = 0;
    $j = 0;
    $prev_tag = array();
    foreach ($vals as $xml_elem) {
        if ($xml_elem['tag'] == 'IMAGE' && $xml_elem['attributes']['SIZE'] == 'cover')
            $image['poster'][] = $xml_elem['attributes']['URL'];
        else if ($xml_elem['tag'] == 'IMAGE' && $xml_elem['attributes']['SIZE'] == 'thumb' && $prev_tag['tag'] == 'BACKDROP')
            $image['wallpaper'][] = $xml_elem['attributes']['URL'];
        $prev_tag = $xml_elem;
    }
    if (isset($image))
        return $image;
}

function findMovies($input_folder)
{
    LoadPreferences();
    global $file_extensions;
    $count = 0;
    $movie_names = array();
    foreach ($input_folder as $folder) {
        if (file_exists($folder)) {
            $files = preg_find('/./', $folder, PREG_FIND_RECURSIVE);
            if ($files != false && count($files) > 0) {
                foreach ($files as $file) {
                    foreach ($file_extensions as $extension) {
                        if (strtoupper(substr(strrchr($file, "."), 1)) == $extension) {
                            if ($extension == "VOB") {
                                $folder_name = strtoupper(substr(strrchr(dirname($file), "/"), 1));
                                if ($folder_name == "VIDEO_TS") {
                                    $dvd_movie = basename(dirname(dirname($file)));
                                    if (array_search_r(dirname($file), $movie_names) == 0) {
                                        $movie_names[$count]['id'] = dirname($file);
                                        $movie_names[$count++]['name'] = $dvd_movie;
                                    }
                                }
                                else {
                                    $movie_names[$count]['id'] = $file;
                                    $movie_names[$count++]['name'] = substr(basename($file), 0, strrpos(basename($file), "."));
                                }
                            }
                            else if ($extension == "M2TS") {
                                $folder_name = strtoupper(substr(strrchr(dirname($file), "/"), 1));
                                if ($folder_name == "STREAM") {
                                    $parent_folder = basename(dirname(dirname($file)));
                                    if ($parent_folder == "BDMV")
                                        $bd_movie = basename(dirname(dirname(dirname($file))));
                                    else
                                        $bd_movie = basename(dirname(dirname($file)));
                                    if (array_search_r(dirname($file), $movie_names) == 0) {
                                        $movie_names[$count]['id'] = dirname($file);
                                        $movie_names[$count++]['name'] = $bd_movie;
                                    }
                                }
                                else {
                                    $movie_names[$count]['id'] = $file;
                                    $movie_names[$count++]['name'] = substr(basename($file), 0, strrpos(basename($file), "."));
                                }
                            }
                            else {
                                $mov_name = substr(basename($file), 0, strrpos(basename($file), "."));
                                $part_number = strtoupper(substr(strrchr($mov_name, "."), 1));
                                if ($part_number != "CD2" && $part_number != "CD3" &&
                                    $part_number != "CD4"
                                ) {
                                    $movie_names[$count]['id'] = $file;
                                    $movie_names[$count++]['name'] = substr(basename($file), 0, strrpos(basename($file), "."));
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }
    }
    return $movie_names;
}

function readNFOFile($nfofile)
{
    $fp = fopen($nfofile, "r");
    $xdata = fread($fp, filesize($nfofile));
    fclose($fp);
    $xml_parser = xml_parser_create();
    xml_parse_into_struct($xml_parser, $xdata, $vals, $index);
    xml_parser_free($xml_parser);
    $genre_count = 0;
    $actor_count = 0;
    $nfo_array = array();
    $prev_tag = array();
    $director = array();
    $actor = array();

    foreach ($vals as $xml_elem) {
        if ($xml_elem['tag'] == 'TITLE')
            $nfo_array = array_push_assoc($nfo_array, "title", utf8_decode($xml_elem['value']));
        if ($xml_elem['tag'] == 'RATING')
            $nfo_array = array_push_assoc($nfo_array, "rating", $xml_elem['value']);
        if ($xml_elem['tag'] == 'YEAR')
            $nfo_array = array_push_assoc($nfo_array, "year", $xml_elem['value']);
        if ($xml_elem['tag'] == 'OUTLINE')
            $nfo_array = array_push_assoc($nfo_array, "synopsis", $xml_elem['value']);
        if ($xml_elem['tag'] == 'THUMB' && $xml_elem['level'] == 2)
            $nfo_array = array_push_assoc($nfo_array, "poster", $xml_elem['value']);
        if ($xml_elem['tag'] == 'THUMBS')
            $nfo_array = array_push_assoc($nfo_array, "posters", $xml_elem['value']);
        if ($xml_elem['tag'] == 'FANART')
            $nfo_array = array_push_assoc($nfo_array, "wallpaper", $xml_elem['value']);
        if ($xml_elem['tag'] == 'FANARTS')
            $nfo_array = array_push_assoc($nfo_array, "fanarts", $xml_elem['value']);
        if ($xml_elem['tag'] == 'CERTIFICATION') {
            $mpaa = explode(" / ", $xml_elem['value']);
            $arr = preg_grep("|USA:(.*)|", $mpaa);
            $arr = array_values($arr);
            if (count($arr) > 0)
                $mpaa = explode(":", $arr[0]);
            $nfo_array = array_push_assoc($nfo_array, "mpaa", $mpaa[1]);
        }
        if ($xml_elem['tag'] == 'ID') {
            if ($xml_elem['value'] != '') {
                $nfo_array = array_push_assoc($nfo_array, "imdbid", $xml_elem['value']);
            }
        }
        if ($xml_elem['tag'] == 'ID' && array_key_exists('attributes', $xml_elem) && $xml_elem['attributes']['MOVIEDB'] == 'tmdb')
            $nfo_array = array_push_assoc($nfo_array, "tmdbid", $xml_elem['value']);
        if ($xml_elem['tag'] == 'DIRECTOR') {
            $director = array_push_assoc($director, "name", utf8_decode($xml_elem['value']));
            $nfo_array = array_push_assoc($nfo_array, "director", $director);
        }
        if ($xml_elem['tag'] == 'GENRE') {
            $genre[$genre_count++] = $xml_elem['value'];
        }
        if ($xml_elem['tag'] == 'NAME' && $prev_tag == 'ACTOR') {
            $actor[$actor_count] = array_push_assoc($actor[$actor_count], "name", utf8_decode($xml_elem['value']));
            $principal_cast[$actor_count] = utf8_decode($xml_elem['value']);
        }
        if ($xml_elem['tag'] == 'THUMB' && $prev_tag == 'ACTOR') {
            $actor[$actor_count] = array_push_assoc($actor[$actor_count], "thumb", $xml_elem['value']);
            $actor_count++;
        }
        if ($xml_elem['tag'] == 'RELEASEDATE')
            $nfo_array = array_push_assoc($nfo_array, "release_date", date("Y-m-d", strtotime($xml_elem['value'])));
        $prev_tag = $xml_elem['tag'];
    }
    if (count($genre) == 1) {
        $genre = explode(" / ", $genre[0]);
        $nfo_array = array_push_assoc($nfo_array, "genre", $genre);
    }
    else
        $nfo_array = array_push_assoc($nfo_array, "genre", $genre);
    $nfo_array = array_push_assoc($nfo_array, "actor", $actor);
    $nfo_array = array_push_assoc($nfo_array, "principal_cast", $principal_cast);
    return $nfo_array;
}

function PrintArray($array)
{
    $string = '';
    foreach ($array as $key => $value) {
        $string .= $key . " => " . $value . "\n";
    }
    file_put_contents("array.txt", $string, FILE_APPEND);
}

function loadNMJData($dbh, $showid, $drivepath, $version)
{
    $nmj_data = array();
    if ($version == '1.8.0') {
        $sql = 'SELECT TITLE,SEARCH_TITLE,RELEASE_DATE,DETAIL_POSTER,THUMBNAIL,CAST_ID,';
        $sql .= 'RATING,PARENTAL_RATING,WALLPAPER,TOTAL_ITEM,';
        $sql .= 'TTID,SHOW_TYPE,SHOW_ID,WIDTH,HEIGHT,CREATE_TIME ';
        $sql .= 'FROM SHOW WHERE SHOW_ID=' . $showid;
        $sql .= ' ORDER BY SHOW_ID';

        $result = DBQuery($dbh, $sql);
        $SHOW_ROW = $result->fetch(PDO::FETCH_ASSOC);

        $sql = 'SELECT VIDEO_ID,SEASON,EPISODE,FPS,RUNTIME,PATH,';
        $sql .= 'SYSTEM,RESOLUTION,VIDEO_CODEC,';
        $sql .= 'WIDTH,HEIGHT,ASPECT_RATIO ';
        $sql .= 'FROM VIDEO WHERE SHOW_ID=' . $showid;
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        $nmj_data = array_merge($SHOW_ROW, $result_row);

        $sql = 'SELECT CONTENT FROM VIDEO_SYNOPSIS WHERE SHOW_ID=' . $showid;
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        if (!isset($result_row['CONTENT']))
            $result_row['CONTENT'] = '';
        $nmj_data = array_merge($nmj_data, $result_row);

        $sql = 'SELECT VIDEO_GROUP_NAME_ID AS GROUPS_ID FROM VIDEO_GROUP ';
        $sql .= 'WHERE SHOW_ID=' . $showid;
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        $nmj_data = array_merge($nmj_data, $result_row);

        $sql = 'SELECT NAME FROM VIDEO_GROUP_NAME ';
        $sql .= 'WHERE VIDEO_GROUP_NAME_ID=' . $result_row['GROUPS_ID'];
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        $nmj_data = array_merge($nmj_data, $result_row);

        // The below may slow down DB query
        $cast_array = explode(",", $nmj_data['CAST_ID']);
        for ($z = 1; $z < count($cast_array) - 1; $z++) {
            $sql = 'SELECT NAME AS CAST FROM VIDEO_PERSON WHERE VIDEO_PERSON_ID=' . $cast_array[$z];
            $result = $dbh->query($sql);
            $trow = $result->fetch(PDO::FETCH_ASSOC);
            $cast[] = $trow['CAST'];
        }
        $nmj_data['CAST'] = implode("#", $cast);

        $sql = 'SELECT TYPE,VALUE FROM VIDEO_ATTR WHERE SHOW_ID=' . $nmj_data['SHOW_ID'];
        foreach ($dbh->query($sql) as $vattr_row) {
            if ($vattr_row['TYPE'] == 'GENRE')
                $grow[] = $vattr_row['VALUE'];
            else if ($vattr_row['TYPE'] == 'KEYWORD')
                $krow[] = $vattr_row['VALUE'];
            else if ($vattr_row['TYPE'] == 'DIRECTOR')
                $drow[] = $vattr_row['VALUE'];
        }
        $nmj_data['GENRE'] = implode("#", $grow);
        $nmj_data['KEYWORD'] = implode("#", $krow);
        $nmj_data['DIRECTOR'] = implode("#", $drow);

        if ($nmj_data['VIDEO_ID'] != '') {
            $sql = 'SELECT VALUE FROM VIDEO_ATTR WHERE VIDEO_ID=' . $nmj_data['VIDEO_ID'] . ' AND TYPE="SUBTITLE"';
            $result = DBQuery($dbh, $sql);
            $srow = $result->fetchAll(PDO::FETCH_COLUMN);
        }
        if (isset($srow))
        $nmj_data['SUBTITLE'] = implode("#", $srow);
    }
    else {
        $sql = 'SELECT SHOWS_ID AS SHOW_ID,VIDEOS_ID AS VIDEO_ID FROM SHOWS_VIDEOS ';
        $sql .= 'WHERE SHOWS_ID='.$showid;
        $result = DBQuery($dbh, $sql);
        $nmj_data = $result->fetch(PDO::FETCH_ASSOC);

        $sql = 'SELECT SHOWS.TITLE,SHOWS.SEARCH_TITLE,SHOWS.RELEASE_DATE,SHOWS.POSTERS_ID,';
        $sql .= 'SHOWS.RATING,SHOWS.PARENTAL_CONTROL AS PARENTAL_RATING,SHOWS.TOTAL_ITEM,';
        $sql .= 'SHOWS.YEAR,SHOWS.TTID,SHOWS.RUNTIME,SHOWS.TITLE_TYPE AS SHOW_TYPE,';
        $sql .= 'SHOWS.ID,SHOWS.CREATE_TIME,SHOWS.CONTENT_ID,SHOWS.CONTENT_TTID,';
        $sql .= 'SYNOPSISES.SUMMARY AS CONTENT,VIDEO_POSTERS.POSTER AS DETAIL_POSTER,'; 
        $sql .= 'VIDEO_POSTERS.THUMBNAIL,VIDEO_POSTERS.WALLPAPER ';
        $sql .= 'FROM SHOWS,SYNOPSISES,VIDEO_POSTERS ';
        $sql .= 'WHERE SHOWS.ID=' . $nmj_data['SHOW_ID'] .' AND ';
        $sql .= 'SYNOPSISES.ID='.$nmj_data['SHOW_ID'].' AND ';
        $sql .= 'VIDEO_POSTERS.ID='.$nmj_data['SHOW_ID'].' ';
        $sql .= ' ORDER BY SHOWS.ID';

        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        $nmj_data = array_merge($nmj_data, $result_row);

        $sql = 'SELECT GROUPS_ID FROM SHOW_GROUPS_SHOWS ';
        $sql .= 'WHERE SHOWS_ID=' . $nmj_data['SHOW_ID'];
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        $nmj_data = array_merge($nmj_data, $result_row);

        if (is_array($result_row)){
        $sql = 'SELECT NAME FROM SHOW_GROUPS ';
        $sql .= 'WHERE ID=' . $result_row['GROUPS_ID'];
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        $nmj_data = array_merge($nmj_data, $result_row);
        }

        $sql = 'SELECT VIDEOS.SIZE,VIDEOS.PATH,VIDEO_PROPERTIES.RESOLUTION,VIDEO_PROPERTIES.WIDTH,';
        $sql .= 'VIDEO_PROPERTIES.HEIGHT,VIDEO_PROPERTIES.ASPECT_RATIO,VIDEO_PROPERTIES.SYSTEM,';
        $sql .= 'VIDEO_PROPERTIES.VIDEO_CODEC,VIDEO_PROPERTIES.FPS FROM VIDEOS,VIDEO_PROPERTIES ';
        $sql .= 'WHERE VIDEOS.ID=' . $nmj_data['VIDEO_ID'].' AND VIDEO_PROPERTIES.ID='.$nmj_data['VIDEO_ID'];
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        $nmj_data = array_merge($nmj_data, $result_row);

        $sql = 'SELECT PERSONS_ID FROM SHOWS_PERSONS WHERE SHOWS_ID=' . $showid . ' AND PERSON_TYPE="CAST"';
        $cast_array[] = 0;
        foreach ($dbh->query($sql) as $cast_row)
            $cast_array[] = $cast_row['PERSONS_ID'];
        $cast_array[] = 0;

        for ($z = 1; $z < count($cast_array) - 1; $z++) {
            $sql = 'SELECT NAME FROM VIDEO_PERSONS WHERE ID=' . $cast_array[$z];
            $result = $dbh->query($sql);
            $trow = $result->fetch(PDO::FETCH_ASSOC);
            $cast[] = $trow['NAME'];
        }
        $nmj_data['CAST'] = implode("#", $cast);

        $sql = 'SELECT GENRES_ID FROM SHOWS_GENRES WHERE SHOWS_ID=' . $showid;
        foreach ($dbh->query($sql) as $genre_row) {
            $sql = 'SELECT NAME FROM VIDEO_GENRES WHERE ID=' . $genre_row['GENRES_ID'];
            $result = DBQuery($dbh, $sql);
            $grow[] = $result->fetch(PDO::FETCH_COLUMN);
        }
        $nmj_data['GENRE'] = implode("#", $grow);

        $sql = 'SELECT KEYWORDS_ID FROM SHOWS_KEYWORDS WHERE SHOWS_ID=' . $showid;
        foreach ($dbh->query($sql) as $key_row) {
            $sql = 'SELECT KEYWORD FROM KEYWORDS WHERE ID=' . $key_row['KEYWORDS_ID'];
            $result = DBQuery($dbh, $sql);
            $krow[] = $result->fetch(PDO::FETCH_COLUMN);
        }
        $nmj_data['KEYWORD'] = implode("#", $krow);

        $sql = 'SELECT PERSONS_ID FROM SHOWS_PERSONS WHERE SHOWS_ID=' . $showid . ' AND PERSON_TYPE="DIRECTOR"';
        foreach ($dbh->query($sql) as $cast_row) {
            $sql = 'SELECT NAME FROM VIDEO_PERSONS WHERE ID=' . $cast_row['PERSONS_ID'];
            $result = DBQuery($dbh, $sql);
            $drow[] = $result->fetch(PDO::FETCH_COLUMN);
        }
        $nmj_data['DIRECTOR'] = implode("#", $drow);

        $sql = 'SELECT VIDEOS_ID FROM SHOWS_VIDEOS WHERE SHOWS_ID=' . $showid;
        $result = DBQuery($dbh, $sql);
        $videoid = $result->fetch();

        $sql = 'SELECT FILE_NAME,LANGUAGE,TYPE FROM VIDEO_SUBTITLES WHERE VIDEOS_ID='.$videoid['VIDEOS_ID'];
        foreach ($dbh->query($sql) as $sub_row) {
            if ($sub_row['TYPE'] == 'INTERNAL')
                $srow[] = $sub_row['LANGUAGE'];
            else
                $srow[] = $sub_row['FILE_NAME'];
        }
        $nmj_data['SUBTITLE'] = implode("#", $srow);
    }

    $nmj_data['DRIVE_PATH'] = $drivepath;
    $nmj_data['VERSION'] = $version;

    return $nmj_data;
}

function arraytoHTML($movie)
{
    $html_data = "";
    for ($i = 0; $i < count($movie); $i++) {
        $href = "javascript:Form1.setItemValue('TTID','" . $movie[$i]['ID'] . "');dhtmlx.modalbox.hide(box);imdbid_updated=true;updateData('" . $movie[$i]['ID'] . "');";
        $html_data .= '<div class="result"><a href="#" onclick="' . $href . '"><img class="result" ';
        if (isset($movie[$i]['URL']) && $movie[$i]['URL'] != '')
            $html_data .= 'src="' . $movie[$i]['URL'] . '" width="62" /></a>';
        else
            $html_data .= 'src="http://cf2.themoviedb.org/assets/36af7b825516d/images/no-poster-w92.jpg" width="62" /></a>';
        $html_data .= '<span class="float"><a href="#" onclick="' . $href . '">' . $movie[$i]['NAME'] . '</a> <span class="date">';
        if (isset($movie[$i]['RELEASED'])) {
            $year = explode("-", $movie[$i]['RELEASED']);
            $html_data .= '(' . $year[0] . ')';
        }
        $html_data .= '</span><span class="aka">';
        if (isset($movie[$i]['ALTERNATIVE_NAME']) && $movie[$i]['ALTERNATIVE_NAME'] != '')
            $html_data .= 'aka &#8220;' . $movie[$i]['ALTERNATIVE_NAME'] . '&#8221;';
        $html_data .= '</span></span><div style="clear: left"></div></div>';
    }
    return $html_data;
}

function matchRegex($strContent, $strRegex, $intIndex = null)
{
    $arrMatches = null;
    preg_match_all($strRegex, $strContent, $arrMatches);
    if ($arrMatches === FALSE) return false;
    if ($intIndex != null && is_int($intIndex)) {
        if ($arrMatches[$intIndex]) {
            return $arrMatches[$intIndex][0];
        }
        return false;
    }
    return $arrMatches;
}

function clean_num($num)
{
    $pos = strpos($num, '.');
    if ($pos === false) { // it is integer number
        return $num;
    } else { // it is decimal number
        return rtrim(rtrim($num, '0'), '.');
    }
}

?>
