#!/share/Apps/lighttpd/bin/php
<?php
include "config.php";
include "functions.php";
include "preg_find.php";

if ( $argc < 2 && $argc >3 )
    die("Usage: [-debug] importMovies.sh PATH\n");

LoadPreferences();
$count=0;
$input=array($argv[1]);
$movie_names=findMovies($input);
$cnt=1;
foreach ($movie_names as $movie_name) {
    $drive_name=explode("/",$movie_name['id']);
    $drive_root="/".$drive_name[1]."/";
    $movie_name_woroot=implode("/",array_slice($drive_name, 2));
    
    if (! file_exists($drive_root.'nmj_database/media.db'))
        shell_exec("cp -pR /opt/syb/local/nmj_database '".$drive_root."';chmod -R 777 '".$drive_root."nmj_database'");
    $dbh = new PDO('sqlite:'.$drive_root.'nmj_database/media.db');
    $sql = 'SELECT VIDEO_ID FROM VIDEO WHERE PATH="'.$movie_name_woroot.'"';
    $result=$dbh->query($sql);
    $row = $result->fetch(PDO::FETCH_ASSOC);
    $movie_imported=0;
    
    if (!isset($row['VIDEO_ID'])){
        print("Processing movie ".$cnt."/".count($movie_names)."\n");
        $nfo_fullpath=dirname($movie_name['id'])."/".$movie_name['name'].".nfo";
        if (file_exists($nfo_fullpath) && filesize($nfo_fullpath) != 0) {
            $nfo_array = file($nfo_fullpath);
            // Get IMDB info from NFO
            if (count($nfo_array) == 1){
                $nfo_data = file_get_contents($nfo_fullpath);
                $count = preg_match("|http:\/\/(.*)\/title\/(.*)|", $nfo_data, $matches);
                if ($count > 0) {
                    if ($matches[2] != '')
                        $imdbid=str_replace("/","",$matches[2]);
                }
                else {
                    $count = preg_match("|tt(.*)|", $nfo_data, $matches);
                    if ($count > 0)
                        $imdbid="tt".$matches[1]; 
                }
                $movie_imported = 0;
            }
            // Import all data from NFO
            else {
                $nmj_data = readNFOFile($nfo_fullpath);
                $nmj_data = array_merge($nmj_data, getMediaInfo($movie_name['id']));
                print("Importing Information for IMBD ID '".$nmj_data['imdbid']."' from NFO File...\n");
                handleNMJData($dbh, $nmj_data, "insert");
                $movie_imported = 1;
            }
        }
        else {
            $imdbid = searchIMDB($movie_name['name']); 
        }
        if ($movie_imported == 0) {
            if ($imdbid != "" && $imdbid != "No Matches") {
                print("Getting Information for IMBD ID '".$imdbid."'\n");
                $nmj_data = getIMDBdata($imdbid); 
                $nmj_data['sstring'] = $nmj_data['title'];
            }
            else {
                $nmj_data['title'] = basename($movie_name['id']);
                $nmj_data['sstring'] = $nmj_data['title'];
                $nmj_data['release_date'] = '9999-01-01';
                $nmj_data['rating'] = 0;
                $nmj_data['mpaa'] = '0';
                $nmj_data['imdbid'] = '';
            }
            $nmj_data['drivepath'] = $drive_root;
            $nmj_data['media_location'] = $movie_name['id'];
            $nmj_data['media_location_woe'] = substr($nmj_data['media_location'],0,strrpos($nmj_data['media_location'], "."));
            $nmj_data['filepath'] = str_replace($nmj_data['drivepath'], "", $nmj_data['media_location']);
            print("Importing '".$nmj_data['title']."' into NMJ Database...\n");
            handleNMJData($dbh, $nmj_data, "insert");
        }
    }
    else
        print("Skipping movie ".$cnt."/".count($movie_names)."\n");
    $cnt++;
}
