var is_firefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
var is_android = navigator.userAgent.toLowerCase().indexOf("android") > -1;
var sourcePath = "/var/www/db/guerilla/nmj_database/media.db";
nmjObject = localStorage.getItem('nmjSource');
//localStorage.setItem("nmjSource", '');

var isChrome = !!window.chrome;              // Chrome 1+
if (typeof window.orientation !== 'undefined') {
    if (isChrome) {
        var winW = window.outerWidth;
        var realWidth = window.outerWidth;
        var availHeight = window.innerHeight;
        var realHeight = screen.height + 48;
    }
    if (winW < realHeight)
    // Vertical Orientation
        var wallColumns = 4;
    else
    // Horizontal Orientation
        var wallColumns = 6;
} else {
    if (is_firefox && is_android) {
        var winW = screen.width;
        var realHeight = screen.height + 48;
    }
    else {
        var winW = window.innerWidth;
        var realHeight = window.innerHeight;
    }
    if (winW < realHeight)
    // Vertical Orientation
        var wallColumns = 4;
    else
    // Horizontal Orientation
        var wallColumns = 6;
}
var thumbWidth = Math.round((winW - (wallColumns + 1) * 10) / wallColumns);
var defaultLoad = Math.round(realHeight / (thumbWidth * 1.5) + 4);
var movieViewMargin = (winW - ((thumbWidth + 10) * wallColumns)) / 2;

function getElementByClass(className, parent) {
    parent || (parent = document);
    var descendants = parent.getElementsByTagName('*'), i = -1, e, result = [];
    while (e = descendants[++i]) {
        ((' ' + (e['class'] || e.className) + ' ').indexOf(' ' + className + ' ') > -1) && result.push(e);
    }
    return result;
}


var sources = [
    {id: 1, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/7sTwiVaYpVDS21jYG8P265En292.jpg"},
    {id: 2, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/Ak0QAlJh05jLSmFl5zDU8c0PXyD.jpg"},
    {id: 3, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/wTNPOPKoXyYlMJyVU1CmB6roSHg.jpg"},
    {id: 4, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/8Q4mgtnS4K5gaMqNjtC6Y17uqr.jpg"},
    {id: 5, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/orTowcvqNubSV2CMr07zZNDliGp.jpg"}
]

var musicWallViewJS = {
    view: 'dataview', select: 'single', scroll: 'y',
    type: { height: 230, width: thumbWidth, padding: 0, margin: 0},
    id: 'musicWallView',
    template: function (obj) {
        return musicWallViewHTML(obj);
    }
};

function getCertificationImage(parental_rating) {
    parental_rating_img = "images/rating_ur.png";

    if (parental_rating == 'R')
        parental_rating_img = "images/common_mpaa_r.png";
    else if (parental_rating == 'PG-13')
        parental_rating_img = "images/common_mpaa_pg_13.png";
    else if (parental_rating == 'PG-15')
        parental_rating_img = "images/common_mpaa_pg_15.png";
    else if (parental_rating == 'PG')
        parental_rating_img = "images/common_mpaa_pg.png";
    else if (parental_rating == 'NC-17')
        parental_rating_img = "images/common_mpaa_nc_17.png";
    else if (parental_rating == 'G')
        parental_rating_img = "images/common_mpaa_g.png";
    else if (parental_rating == 'TV-MA')
        parental_rating_img = "images/tv_ma.png";
    else if (parental_rating == 'TV-14')
        parental_rating_img = "images/tv_14.png";
    else if (parental_rating == 'TV-PG')
        parental_rating_img = "images/tv_pg.png";
    else if (parental_rating == 'TV-G')
        parental_rating_img = "images/tv_g.png";
    else if (parental_rating == 'TV-Y')
        parental_rating_img = "images/tv_y.png";
    else if (parental_rating == 'TV-Y7')
        parental_rating_img = "images/tv_y7.png";
    else if (parental_rating == '12')
        parental_rating_img = "images/uk_12.png";
    else if (parental_rating == '12A')
        parental_rating_img = "images/uk_12a.png";
    else if (parental_rating == '15')
        parental_rating_img = "images/uk_15.png";
    else if (parental_rating == '18')
        parental_rating_img = "images/uk_18.png";
    else if (parental_rating == 'U')
        parental_rating_img = "images/uk_u.png";
    else if (parental_rating == 'R18')
        parental_rating_img = "images/uk_r18.png";
    return parental_rating_img;
}

function getRatingImage(rating) {
    rating = rating.replace(",", ".");
    var rating_img;
    if (rating == 0)
        rating_img = "images/common_star_0.png";
    if (rating <= 1 && rating > 0)
        rating_img = "images/common_star_1.png";
    else if (rating <= 2 && rating > 1)
        rating_img = "images/common_star_2.png";
    else if (rating <= 3 && rating > 2)
        rating_img = "images/common_star_3.png";
    else if (rating <= 4 && rating > 3)
        rating_img = "images/common_star_4.png";
    else if (rating <= 5 && rating > 4)
        rating_img = "images/common_star_5.png";
    else if (rating <= 6 && rating > 5)
        rating_img = "images/common_star_6.png";
    else if (rating <= 7 && rating > 6)
        rating_img = "images/common_star_7.png";
    else if (rating <= 8 && rating > 7)
        rating_img = "images/common_star_8.png";
    else if (rating <= 9 && rating > 8)
        rating_img = "images/common_star_9.png";
    else if (rating <= 10 && rating > 9)
        rating_img = "images/common_star_10.png";
    return rating_img;
}

var movieWallViewJS = {
    view: 'dataview', select: 'single', scroll: 'y',
    type: { height: Math.round(thumbWidth * 1.5), width: thumbWidth, padding: 0, margin: 5},
    id: 'movieWallView',
    template: function (obj) {
        return movieWallViewHTML(obj);
    }
};

var seasonPopupJS = {
    view: "window",
    css: "season_popup",
    head: {
        template: "",
        css: "seasonheader",
        id: "seasonHead"
    },
    body: {
        view: 'dataview',
        id: 'seasonView',
        select: 'single',
        scroll: 'x',
        css: 'season',
        animate: true,
        datatype: "json",
        type: { height: Math.round(thumbWidth * 1.5), width: thumbWidth, padding: 0, margin: 5},
        template: function (obj) {
            return seasonWallViewHTML(obj);
        },
        height: (Math.round(thumbWidth * 1.5)+40)
    },
    width: winW,
    animate: true,
    left: 0,
    hidden: true,
    id: "seasonPopup",
    padding: false
};


var wallpaper = {
    view: "window",
    head: { view: "toolbar", type: "MainBar", css: "topBar", elements: [
        {view: "label", label: "Wallpaper", align: 'left'}
    ]
    },
    body: {
        view: "pagelist",
        id: "wallpaper_pagelist",
        height: 281,
        width: 518,
        datatype: "xml",
        template: wallpaper_img,
        type: {
            css: "frame",
            height: 281,
            width: 500
        },
        panel: false
    },
    id: "wallpaper",
    css: "wallpaper",
    hidden: true,
    height: 330
};


var poster = {
    view: "window",
    head: { view: "toolbar", type: "MainBar", css: "topBar", elements: [
        {view: "label", label: "Poster", align: 'left'}
    ]
    },
    body: {
        view: "pagelist",
        id: "poster_pagelist",
        height: 342,
        width: 243,
        datatype: "xml",
        template: poster_img,
        type: {
            css: "poster2",
            height: 332,
            width: 222
        },
        panel: false
    },
    id: "poster",
    hidden: true,
    height: 340
};

function wallpaper_img(obj) {
    return '<img src="' + obj.image + '" width="500" height="281" ondragstart="return false"/>'
}

function poster_img(obj) {
    return '<img src="' + obj.image + '" width="220" height="330" ondragstart="return false"/>'
}

var popupMenu1 = {
    view: "popup",
    id: "MainMenu",
    hidden: true,
    height: 400,
    width: 200,
    css: "mainmenu",
    body: {
        view: "grouplist",
        id: "GroupMenu",
        scroll: true,
        animate: true,
        datatype: "xml",
        templateItem: "#name#",
        templateGroup: "#name#",
        templateBack: "#name#",
        select: true,
        y_count: 3
    }
};

var settingsMenuMainJSON = [
    {id: 'settings', name: 'Settings', img: 'images/overview.png'}
]

var settingsMenuMainJS = {
    view: "popup",
    id: "settingsMenuMain",
    hidden: true,
    height: (53 * 1),
    width: 165,
    css: "mainmenu",
    body: {
        view: "list",
        id: "settingsListMain",
        css: "filterList",
        scroll: true,
        animate: true,
        data: settingsMenuMainJSON,
        datatype: "json",
        template: "<img src='#img#' style='width:24px;vertical-align:middle;'></img>&nbsp;#name#",
        select: true,
        y_count: 3
    }
};

var settingsMenuDetailJSON = [
    {id: 'settings', name: 'Settings', img: 'images/overview.png'},
    {id: 'add_chapters', name: 'Add Chapters', img: 'images/chapters.png'},
    {id: 'edit', name: 'Edit', img: 'images/edit.png'},
    {id: 'identify', name: 'Identify Movie', img: 'images/search.png'},
    {id: 'delete', name: 'Delete Movie', img: 'images/delete.png'},
    {id: 'imdb', name: 'Open in IMDb', img: 'images/imdb.png'},
    {id: 'tmdb', name: 'Open in TMDb', img: 'images/tmdb.png'}
]

var settingsMenuDetailJS = {
    view: "popup",
    id: "settingsMenuDetail",
    hidden: true,
    height: (57 * 7),
    width: 180,
    css: "mainmenu",
    body: {
        view: "list",
        id: "settingsListDetail",
        css: "filterList",
        scroll: true,
        animate: true,
        data: settingsMenuDetailJSON,
        datatype: "json",
        template: "<img src='#img#' style='width:24px;vertical-align:middle;'></img>&nbsp;#name#",
        select: true,
        y_count: 3
    }
};

var filterMenuJSON = [
    {id: 'genres', name: 'Genres', img: 'images/genres.png'},
    {id: 'certification', name: 'Certification', img: 'images/certification.png'},
    {id: 'rating', name: 'Rating', img: 'images/rating.png'},
    {id: 'year', name: 'Year', img: 'images/year.png'},
    {id: 'clear', name: 'Clear Filter', img: 'images/filter.png'}
]

var filterMenuJS = {
    view: "popup",
    id: "filterMenu",
    hidden: true,
    height: (57 * 5),
    width: 165,
    css: "mainmenu",
    body: {
        view: "list",
        id: "filterList",
        css: "filterList",
        scroll: true,
        animate: true,
        datatype: "json",
        data: filterMenuJSON,
        //url: "http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getMenu&type=filter",
        template: "<img src='#img#' style='width:24px;vertical-align:middle;'></img>&nbsp;#name#",
        select: true,
        y_count: 3
    }
};

function playHTML(obj) {
    if (typeof obj.BOOKMARK_THUMBNAIL != 'undefined') {
        // Last Watched
        var Template = '<div id="last_watched" class="lastwatched" style="font-size: 16px; color: grey;position: absolute;' +
            'border-width: 0px;align: left; right:30px; bottom: 0px; font-family:Tahoma;width: 215px;height;121px;' +
            'background-image: url(images/movieinfo_last_watched_base.png);"><div class="lastwatched_scene" ' +
            'style="position: absolute; background-image: url(' + obj.BOOKMARK_THUMBNAIL + ');width:211px;' +
            'height:117px;bottom:2px;left:2px;"><div class="lastwatched_glass" onclick="';
        DRIVE = obj.DRIVE_PATH;
        if (obj.PATH.indexOf("nfs://") == -1 && obj.PATH.indexOf("smb://") == -1)
            Template += 'playMedia(\'' + DRIVE.replace("nmj_database/media.db", "") + '/' + obj.PATH + '\', \'movie\', ' +
                obj.BOOKMARK_SECONDS + ');"';
        else
            Template += 'playMedia(\'' + obj.PATH + '\', \'movie\', ' + obj.BOOKMARK_SECONDS + ');"';
        Template += ' style="position: absolute;background-image: url(images/movieinfo_last_watched_glass.png);' +
            'width:215px;height:121px;left: -2px;bottom:-2px;">' +
            '<div class="play" style="position: absolute;width: 55px;' +
            'height:55px;left: 80px;bottom: 33px;background-image: url(images/movieinfo_play_big.png);"></div></div></div>' +
            '<div style="font-family:\'Oswald\', sans-serif;font-size: 16px; color: white;left:220px;top:100px;' +
            'position:relative;">';

        if (typeof obj.BOOKMARK_TIME != 'undefined')
            Template += obj.BOOKMARK_TIME;
        Template += '</div></div>';
    }
    return Template;
}

function loadMovieDetailView(that, id) {
    var index = that.indexById(id);
    var data = that.item(id);
    $$("movieDetailView").load("http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getMovieDetails&source=" + sourcePath + "&INDEX=" + index +
        "&showid=" + data.SHOW_ID, "json", function (text, xml, http_request) {
        $$('Toolbar').showBatch('movie_detail');
        var dataobj = $$("movieDetailView").data;
        if (dataobj.FAVOURITE == '')
            $$('mark_favourite').setValue('images/fav_unsel.png');
        else
            $$('mark_favourite').setValue('images/fav_sel.png');
        $$('detailSpinner').setValue(dataobj.TITLE, "Overview");
        if (dataobj.PLAY_COUNT > 0)
            $$('watched').setValue('images/watched.png');
        else
            $$('watched').setValue('images/unwatched.png');
        $$('detailList').select("overview");
        $$('movieDetailView').show();
    });
}

var playPopupJS = {
    view: "window",
    id: "playPopup",
    hidden: true,
    width: Math.round(winW * .50),
    left: (winW - Math.round(winW * .5)) / 2,
    top: ((realHeight / 2) - ((5 * 53) / 2)),
    height: (5 * 53),
    head: {
        template: "Select last watched scene or play from beginning",
        css: "windowheader"
    },
    css: "mainmenu",
    body: {
        view: "list",
        id: "playList",
        css: "genreList",
        scroll: true,
        animate: true,
        template: function (obj) {
            if (typeof obj.SHOW_ID != 'undefined') {
                return playHTML(obj);
            }
        },
        select: true,
        y_count: 3
    }
};

var chapterPopupJS = {
    view: "window",
    id: "chapterPopup",
    hidden: true,
    width: Math.round(winW * .50),
    left: (winW - Math.round(winW * .5)) / 2,
    top: ((realHeight / 2) - (5 * 53 / 2)),
    height: (5 * 57),
    head: {
        template: "Select appropriate chapter (chapterdb.org)",
        css: "windowheader"
    },
    css: "mainmenu",
    body: {
        view: "list",
        id: "chapterList",
        css: "genreList",
        scroll: true,
        animate: true,
        datatype: "xml",
        template: "#name#",
        select: true,
        y_count: 3
    }
};

var genrePopupJS = {
    view: "window",
    id: "genrePopup",
    hidden: true,
    width: Math.round(winW * .50),
    left: (winW - Math.round(winW * .5)) / 2,
    top: ((realHeight / 2) - (5 * 53 / 2)),
    height: (5 * 57),
    head: {
        template: "Select genre",
        css: "windowheader"
    },
    css: "mainmenu",
    body: {
        view: "list",
        id: "genreList",
        css: "genreList",
        scroll: true,
        animate: true,
        datatype: "xml",
        //url: "http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getList&type=genre&source=" + sourcePath,
        template: "#name#",
        select: true,
        y_count: 3
    }
};

var certificationPopupJS = {
    view: "window",
    id: "certificationPopup",
    hidden: true,
    width: Math.round(winW * .50),
    left: (winW - Math.round(winW * .5)) / 2,
    top: ((realHeight / 2) - (5 * 53 / 2)),
    height: (5 * 57),
    head: {
        template: "Select certification",
        css: "windowheader"
    },
    css: "mainmenu",
    body: {
        view: "list",
        id: "certificationList",
        css: "genreList",
        scroll: true,
        animate: true,
        datatype: "xml",
        //url: "http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getList&type=certification&source=" + sourcePath,
        template: "#name#",
        select: true,
        y_count: 3
    }
};

function showNumMovies() {
    //alert('loaded');
    return true;

}
var yearPopupJS = {
    view: "window",
    id: "yearPopup",
    hidden: true,
    width: Math.round(winW * .50),
    left: (winW - Math.round(winW * .5)) / 2,
    top: ((realHeight / 2) - (5 * 53 / 2)),
    height: (5 * 57),
    css: "mainmenu",
    head: {
        template: "Select year",
        css: "windowheader"
    },
    body: {
        view: "list",
        id: "yearList",
        css: "genreList",
        scroll: true,
        animate: true,
        datatype: "xml",
        //url: "http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getList&type=year&source=" + sourcePath,
        template: "#name#",
        select: true,
        y_count: 3
    }
};

var ratingPopupJS = {
    view: "window",
    id: "ratingPopup",
    hidden: true,
    width: Math.round(winW * .50),
    left: (winW - Math.round(winW * .5)) / 2,
    top: ((realHeight / 2) - (5 * 53 / 2)),
    height: (5 * 57),
    css: "mainmenu",
    head: {
        template: "Select rating",
        css: "windowheader"
    },
    body: {
        view: "list",
        id: "ratingList",
        css: "genreList",
        scroll: true,
        animate: true,
        datatype: "xml",
        //url: "http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getList&type=rating&source=" + sourcePath,
        template: "#name#",
        select: true,
        y_count: 3
    }
};

var sortMenuJSON = [
    {id: 'title', name: 'Sort by title'},
    {id: 'release', name: 'Sort by release'},
    {id: 'duration', name: 'Sort by duration'},
    {id: 'rating', name: 'Sort by rating'},
    {id: 'date', name: 'Sort by date added'}
]

var sortMenuJS = {
    view: "popup",
    id: "sortMenu",
    hidden: true,
    height: (57 * 5),
    width: 190,
    css: "mainmenu",
    body: {
        view: "list",
        id: "sortList",
        css: "filterList",
        scroll: true,
        animate: true,
        datatype: "json",
        data: sortMenuJSON,
        //url: "http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getMenu&type=sort",
        template: "#name#",
        select: true,
        y_count: 3
    }
};

var mainMenuJSON = [
    {id: 'Videos', name: 'All Videos'},
    {id: 'Movies', name: 'Movies'},
    {id: 'TV Shows', name: 'TV Shows'},
    {id: 'Favorites', name: 'Favorites'},
    {id: 'Collections', name: 'Collections'},
    {id: 'Watched', name: 'Watched videos'},
    {id: 'Unwatched', name: 'Unwatched videos'},
    {id: 'Unidentified', name: 'Unidentified videos'}
]

var mainMenuJS = {
    view: "popup",
    id: "mainMenu",
    hidden: true,
    height: (57 * 8),
    width: 200,
    css: "mainmenu",
    body: {
        view: "list",
        id: "mainList",
        css: "filterList",
        scroll: true,
        animate: true,
        datatype: "json",
        data: mainMenuJSON,
        template: "#name#",
        select: true,
        y_count: 3
    }
};

var detailMenuJSON = [
    {id: 'overview', name: 'Overview'},
    {id: 'actors', name: 'Actors'}
]

var detailMenuJS = {
    view: "popup",
    id: "detailMenu",
    hidden: true,
    height: (57 * 2),
    width: 165,
    css: "mainmenu",
    body: {
        view: "list",
        id: "detailList",
        css: "filterList",
        scroll: true,
        animate: true,
        datatype: "json",
        data: detailMenuJSON,
        template: "#name#",
        select: true,
        y_count: 3
    }
};

var actorMenuJSON = [
    {id: 'biography', name: 'Biography'},
    {id: 'filmography', name: 'Filmography'}
]

var actorMenuJS = {
    view: "popup",
    id: "actorMenu",
    hidden: true,
    height: (57 * 2),
    width: 165,
    css: "mainmenu",
    body: {
        view: "list",
        id: "actorList",
        css: "filterList",
        scroll: true,
        animate: true,
        datatype: "json",
        data: actorMenuJSON,
        //url: "http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getMenu&type=actor",
        template: "#name#",
        select: true,
        y_count: 3
    }
}

var popupMenu2 = {
    view: "popup",
    id: "filterMenu",
    hidden: true,
    height: 400,
    width: 200,
    css: "mainmenu",
    body: {
        view: "list",
        id: "filterList",
        scroll: true,
        animate: true,
        datatype: "xml",
        templateItem: "#name#",
        select: true,
        y_count: 3
    }
};

function secondsToTime(secs) {
    var hours = Math.floor(secs / (60 * 60));

    var divisor_for_minutes = secs % (60 * 60);
    var minutes = Math.floor(divisor_for_minutes / 60);

    var divisor_for_seconds = divisor_for_minutes % 60;
    var seconds = Math.ceil(divisor_for_seconds);

    var obj = {
        "h": hours,
        "m": minutes,
        "s": seconds
    };
    return hours + ' hours ' + minutes + ' minutes ';
}

String.prototype.width = function (font) {
    var f = font || '12px arial',
        o = $('<div>' + this + '</div>')
            .css({'position': 'absolute', 'float': 'left', 'white-space': 'nowrap', 'visibility': 'hidden', 'font': f})
            .appendTo($('body')),
        w = o.width();

    o.remove();

    return w;
}

function reloadMusicWall(id) {
    $$("musicWallView").clearAll();
    $$("title").setValue(id.name + ": " + id.textContent);
    $$("musicWallView").load("http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getMusic&source=" + sourcePath + "&count=" + (wallColumns * 3) + "&TYPE=" + id.name + "&VALUE=" + id.textContent);
    $$('musicWallView').show();
    dhx.delay($$("Toolbar").showBatch, $$("Toolbar"), ["wall"], 550);
}

function playMedia(media, type, time) {
    XmlHttpRequest = dhx.ajax().sync().get("http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php", "xml=playMedia&type=" + type + "&media=" + media + "&time=" + time);
    hideModal();
}

function reloadMovieWall(id) {
    if (id != undefined) {
        filterBy = id.name;
        selValue = id.textContent;
    }
    $$('movieWallView').clearAll();
    $$("movieWallView").load("http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getMovies&source=" + sourcePath + "&count=" +
        (wallColumns * defaultLoad) + "&orderby=" + orderBy + "&filterby=" + filterBy +
        "&sortby=" + sortBy + "&TYPE=" + loadType + "&VALUE=" + selValue, "json", function (text, xml, http_request) {
        var dataobj = $$("movieWallView");
        if (loadType == "Movies")
            txt = " movies";
        else
            txt = " videos";
        $$("mainSpinner").setValue(loadType, dataobj.item(dataobj.idByIndex(0)).total_count + txt);
        $$("Toolbar").showBatch("wall");
        $$("movieWallView").scrollTo(0, 0);
        $$('movieWallView').show();
    });
}

function hideModal() {
    if (document.getElementById("episode_div") != null)
        document.getElementById("episode_div").style.display = 'none';
    if (document.getElementById("chapter_div") != null)
        document.getElementById("chapter_div").style.display = 'none';
    if (document.getElementById('dhx_modal_cover') != null)
        document.getElementById('dhx_modal_cover').style.display = 'none';
    if (document.getElementById('dhx_episode_cover') != null)
        document.getElementById('dhx_episode_cover').style.display = 'none';
    var list = findDivByAttribute('GroupMenu1');
    /*if (list.style.left == '0px')
        list.style.left = '-202px';*/
}

function showEpisodes() {
    document.getElementById('dhx_episode_cover').style.display = 'block';

    var list = document.getElementById("episode_div");
    if (list.style.display == 'block')
        list.style.display = 'none';
    else
        list.style.display = 'block';
}

function findDivByAttribute(attribute) {
    var elements = document.getElementsByTagName("div");
    for (var h = 0; h < elements.length; h++) {
        if (elements[h].getAttribute("view_id") == attribute)
            return elements[h];
    }
}

function showChapters(length) {
    document.getElementById('dhx_episode_cover').style.display = 'block';

    var list = document.getElementById("chapter_div");
    if (list.style.display == 'block')
        list.style.display = 'none';
    else
        list.style.display = 'block';
}

function showEpisodeDetails(track) {
    var list = document.getElementsByClassName("episode_details");
    for (var i = 0; i < list.length; i++) {
        if (track == i + 1) {
            if (list[i].style.display == 'block')
                list[i].style.display = 'none';
            else
                list[i].style.display = 'block';
        }
        else
            list[i].style.display = 'none';
    }
}

function showMusicDetails(track) {
    var list = document.getElementsByClassName("music_details");
    for (var i = 0; i < list.length; i++) {
        if (track == i + 1) {
            if (list[i].style.display == 'block')
                list[i].style.display = 'none';
            else
                list[i].style.display = 'block';
        }
        else
            list[i].style.display = 'none';
    }
}

function getElementTopLeft(id) {

    var ele = document.getElementById(id);
    var top = 0;
    var left = 0;

    while (ele.tagName != "BODY") {
        top += ele.offsetTop;
        left += ele.offsetLeft;
        ele = ele.offsetParent;
    }

    return { top: top, left: left };

}

function getOffset(el) {
    var _x = 0;
    var _y = 0;
    while (el && !isNaN(el.offsetLeft) && !isNaN(el.offsetTop)) {
        _x += el.offsetLeft - el.scrollLeft;
        _y += el.offsetTop - el.scrollTop;
        el = el.offsetParent;
    }
    return { top: _y, left: _x };
}

function getPos(el) {
    // yay readability
    for (var lx = 0, ly = 0;
         el != null;
         lx += el.offsetLeft, ly += el.offsetTop, el = el.offsetParent);
    return {x: lx, y: ly};
}

function showDiv(div) {
    if (div == 'movieinfo') {
        document.getElementById('movieinfo').style.visibility = 'visible';
        document.getElementById('synopsis').style.visibility = 'hidden';
        document.getElementById('fileinfo').style.visibility = 'hidden';
        document.getElementById('last_watched').style.visibility = 'hidden';
        document.getElementById('button_1').style.color = '#4e9fb0';
        document.getElementById('button_2').style.color = '#fdf0d3';
        if (document.getElementById('button_3').style.color != 'grey')
            document.getElementById('button_3').style.color = '#fdf0d3';
        if (document.getElementById('button_4').style.color != 'grey')
            document.getElementById('button_4').style.color = '#fdf0d3';
    }
    else if (div == 'synopsis') {
        document.getElementById('movieinfo').style.visibility = 'hidden';
        document.getElementById('synopsis').style.visibility = 'visible';
        document.getElementById('fileinfo').style.visibility = 'hidden';
        document.getElementById('last_watched').style.visibility = 'hidden';
        document.getElementById('button_2').style.color = '#4e9fb0';
        document.getElementById('button_1').style.color = '#fdf0d3';
        if (document.getElementById('button_3').style.color != 'grey')
            document.getElementById('button_3').style.color = '#fdf0d3';
        if (document.getElementById('button_4').style.color != 'grey')
            document.getElementById('button_4').style.color = '#fdf0d3';
    }
    else if (div == 'fileinfo') {
        document.getElementById('movieinfo').style.visibility = 'hidden';
        document.getElementById('synopsis').style.visibility = 'hidden';
        document.getElementById('fileinfo').style.visibility = 'visible';
        document.getElementById('last_watched').style.visibility = 'hidden';
        document.getElementById('button_3').style.color = '#4e9fb0';
        document.getElementById('button_1').style.color = '#fdf0d3';
        document.getElementById('button_2').style.color = '#fdf0d3';
        if (document.getElementById('button_4').style.color != 'grey')
            document.getElementById('button_4').style.color = '#fdf0d3';
    }
    else if (div == 'last_watched') {
        document.getElementById('movieinfo').style.visibility = 'hidden';
        document.getElementById('synopsis').style.visibility = 'hidden';
        document.getElementById('fileinfo').style.visibility = 'hidden';
        document.getElementById('last_watched').style.visibility = 'visible';
        document.getElementById('button_4').style.color = '#4e9fb0';
        document.getElementById('button_1').style.color = '#fdf0d3';
        document.getElementById('button_2').style.color = '#fdf0d3';
        document.getElementById('button_3').style.color = '#fdf0d3';
    }
}

var seasonDetailViewJS = {
    id: 'seasonDetailView',
    view: 'template',
    template: function (obj) {
        if (typeof obj.SHOW_ID != 'undefined') {
            return seasonDetailViewHTML(obj);
        }
    }
};

function showActorWallView(data) {
    if ($$('actorWallView').dataCount() == 0)
        ashowid = 0;
    else
        ashowid = $$('actorWallView').item($$('actorWallView').idByIndex(0)).show_id;
    if (ashowid != data.SHOW_ID) {
        $$('actorWallView').clearAll();
        $$("actorWallView").load("http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getActors&source=" + sourcePath +
            "&showid=" + data.SHOW_ID, "json", function (text, xml, http_request) {

            $$('Toolbar').showBatch('movie_detail');
            $$('detailSpinner').setValue(data.TITLE, "Actors");
            $$('actorWallView').show();
        });
    }
    else
        $$('actorWallView').show();
    $$('refresh_detail').hide();
    $$('mark_favourite').hide();
    $$('movie_play').hide();
    $$('watched').hide();
    $$('chapters').hide();
}

var movieDetailViewJS = {
    id: 'movieDetailView',
    view: 'template',
    template: function (obj) {
        if (typeof obj.SHOW_ID != 'undefined') {
            return movieDetailViewHTML(obj);
        }
    }
};

var actorWallViewJS = {
    view: 'dataview', select: 'single', scroll: 'y',
    type: { height: Math.round(thumbWidth * 1.5) + 40, width: thumbWidth, padding: 0, margin: 5},
    id: 'actorWallView',
    template: function (obj) {
        return actorWallViewHTML(obj);
    }
};

var actorDetailViewJS = {
    id: 'actorDetailView',
    view: 'template',
    template: function (obj) {
        if (typeof obj.name != 'undefined') {
            return actorDetailViewHTML(obj);
        }
    }
};

var actorMoviesWallViewJS = {
    view: 'dataview', select: 'single', scroll: 'y',
    type: { height: Math.round(thumbWidth * 1.5) + 40, width: thumbWidth, padding: 0, margin: 5},
    id: 'actorMoviesWallView',
    template: function (obj) {
        return actorMoviesWallViewHTML(obj);
    }
};

var musicDetailViewJS = {
    id: 'MusicDetailView',
    view: 'template',
    template: function (obj) {
        if (typeof obj.tracks != 'undefined') {
            return musicDetailViewHTML(obj);
        }
    }
};

function mainHTML(obj) {
    var output = "<div class='thumbnail_div' style='color: white;position: relative;width:" +
        Math.round(winW/5) +"px; height:"+Math.round(winW/5)+"px;";
    output += "background-image: url(\"images/A400.jpg\"); " +
        "background-size: "+Math.round(winW/5)+"px "+Math.round(winW/5)+"px;'>";
    output += "</div>";
    output += "<div style='background-color: #282828;position: relative;font-size:15px;text-align: left;" +
    "height:20px;margin-top: -2px;'>&nbsp;"+obj.name+"</div>";
    output += "</div>";
    return output;
}

//xyz = localStorage.getItem('nmjSource');
//console.log('localStorage: ', JSON.parse(xyz));


//var ipaddress = "10.0.0.6"
//var pchname = "A400";
//var port = "9999";

var nmjMachines = [
    {ip: "10.0.0.6", name: "A400", port: "9999"}
]

//var nmjMachines = localStorage.getItem('nmjSource');


var nmjSelectViewJS = {
    id: 'nmjSelectView',
    view: 'dataview', select: 'single', scroll: 'y',
    type: { height: Math.round(winW/5), width: Math.round(winW/5), padding: 0, margin: 25},
    data: nmjObject,
    datatype: "json",
    template: function (obj) {
        if (obj.ip != null)
        return mainHTML(obj);
    }
};

var sourceSelectViewJS = {
    id: 'sourceSelectView',
    view: 'list',
    //url: "http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=getDrives&type=local",
    datatype: "xml",
    select: true,
    template: "<div class='source'><img src='#image#'>" +
        "<div style='position:relative;top:-35px;left:50px;color:#fff9f2;font-family:Tahoma;'>#title#</div>" +
        "<div id='sourcepath_#title#' style='visibility: hidden;'>#drivepath#</div>" +
        "<div id='nmj_available_#title#' style='visibility: hidden;'>#jukebox#</div>" +
        "<div id='dbpath_#title#' style='visibility: hidden;'>#dbpath#</div></div>"
};

var movieViewJS = {
    id: 'MovieView',
    view: "multiview",
    scroll: true,
    cells: [
        //nmjSelectViewJS,
        sourceSelectViewJS,
        movieWallViewJS,
        musicWallViewJS,
        movieDetailViewJS,
        actorWallViewJS,
        actorDetailViewJS,
        actorMoviesWallViewJS,
        seasonDetailViewJS,
        musicDetailViewJS
    ]
};

function saveSettings() {
    //ipaddress = localStorage.getItem('ipaddress');
    //machinename = localStorage.getItem('machinename');
    //port = localStorage.getItem('port');
    machine = {};
    ipaddress = $$('field_b').getValue();
    port = $$('field_c').getValue();
    name = $$('field_a').getValue();
    var dc = $$('nmjSelectView').dataCount() ;
    $$('nmjSelectView').add({'id': dc, 'ip': ipaddress, 'name': name, 'port':port});
    machine.ip = ipaddress;
    machine.name = name;
    machine.port = port;
    machine.id=dc;
    nmjObject.push(machine);
    //nmjObject.push({ 'id': dc, 'data': {'ip' : ipaddress, 'name' :name, 'port': port}});
    localStorage.setItem("nmjSource", JSON.stringify(nmjObject));
    xyz = localStorage.getItem('nmjSource');
    console.log('localStorage: ', JSON.parse(xyz));
    ipaddress="10.0.0.9";
    //$$('field_a').setValue(ipaddress);
    //$$('myForm').setValue("machinename", machinename);
    //$$('myForm').setValue("port", port);
    $$('addNMJPopup').hide();
    $$('addNMJPopup').modal_setter($$('addNMJPopup'), false);
    //document.getElementById('dhx_episode_cover').style.display = 'none';
}

function addNMJSource(){
    $$('addNMJPopup').modal_setter($$('addNMJPopup'), true);
    $$('addNMJPopup').show();
}

var addNMJJS = {
    view: "window",
    id: "addNMJPopup",
    hidden: true,
    width: Math.round(winW * .30),
    left: (winW - Math.round(winW * .3)) / 2,
    top: ((realHeight / 2) - (5 * 53 / 2)),
    height: 230,
    css: "mainmenu",
    head: {
        template: "Add a Popcornhour (200/300/400)",
        css: "windowheader"
    },
    body: {
        view: "list",
        id: "ratingList",
        view: "form", id: "myform",   elements: [
            { view: "richselect", label: 'Machine Name:', id: 'field_a', value: 'A400', yCount: "6", data:[
                { id: 'a400', value:"A400"},
                {id: 'a410', value:"A410"},
                {id: 'a300', value:"A300"},
                {id: 'c200', value:"C200"},
                {id: 'a200', value:"A200"},
                {id: 'a210', value:"A210"}
            ]},
            { view: "text", label: 'IP Address/Hostname:', id: 'field_b', css: 'addnmj', value: '0.0.0.0'},
            { view: "text", label: 'Port', css: 'addnmj', id: 'field_c', value: '9999'},
            { view: "button", type: "form", id: 'field_d', css: 'addnmj', label: 'Save', align: "center",
                click: 'saveSettings()', inputWidth: 150 }

        ]}
};

var toolBarJS = {
    view: 'toolbar', type: 'MainBar', height: 64, css: "topBar",
    id: 'Toolbar',
    visibleBatch: "nmj",
    elements: [
        { view: "imagebutton", id: "icon", batch: "nmj", popup: "", label: "",
            width: 64, align: 'left', src: 'images/movie1.png', css: 'nmjicon'},
        { view: "imagebutton", id: "source_menu", batch: "nmj", popup: "settingsMenuMain", label: "",
            width: 64, align: 'right', src: 'images/settings.png', css: 'settings'},
        { view: "imagebutton", id: "add", batch: "nmj", align: "right", src: "images/add.png",
            width: 64, css: 'settings', click:'addNMJSource'},
        ///////
        { view: "imagebutton", id: "back", batch: "wall", popup: "", label: "",
            width: 64, align: 'left', src: 'images/movie1.png', css: 'nmjicon'},
        { view: "menuspinner", id: "mainSpinner", batch: "wall", align: "left", label1: "Videos",
            label2: "", width: (winW - 6 * 64), css: 'menuspinner', popup: "mainMenu"},
        { view: "imagebutton", id: "wall_menu", batch: "wall", popup: "settingsMenuMain", label: "",
            width: 64, align: 'right', src: 'images/settings.png', css: 'settings'},
        { view: "imagebutton", id: "refresh", batch: "wall", align: "right", src: "images/refresh.png",
            width: 64, css: 'settings'},
        { view: "imagebutton", id: "filter", batch: "wall", align: "right", src: "images/filter.png",
            width: 64, popup: "filterMenu", css: 'settings'},
        { view: "imagebutton", id: "sort_image", batch: "wall", align: "right", src: "images/sort_asc.png",
            width: 64, css: 'settings', popup: "sortMenu" },
        { view: "imagebutton", id: "search", batch: "wall", align: "right", src: "images/search.png",
            width: 64, css: 'settings'},
        //{ view: "imagebutton", id: "menu", batch: "source", popup: "", label: "",
        //    width: 48, align: 'left', src: 'images/Movie-48.png', css: 'nmjicon'},
        //{ view: "button", id: "menu", batch: "wall", popup: "MainMenu", label: "Menu",
        //   inputWidth: 80, align: 'left'},
        //{ view: "text", placeholder: 'Search', label: "", id: "search", batch: "wall", inputWidth: 300, type: "text",
        //    align: "right"},
        //{ view: "button", id: "movie_back", batch: "movie_detail", label: "Back",
        //    inputWidth: 80, align: 'left' },
        //{ view: "button", id: "season_back", batch: "season_detail", label: "Back",
        //   inputWidth: 80, align: 'left' },
        //{ view: "button", id: "music_back", batch: "music_detail", label: "Back",
        //    inputWidth: 80, align: 'left' },
        /*{ view: "button", id: "movie_prev", batch: "movie_detail1", label: "Prev",
         inputWidth: 80, align: 'left' },*/
        { view: "imagebutton", id: "detail_back", batch: "movie_detail", popup: "", label: "",
            width: 64, align: 'left', src: 'images/movie1.png', css: 'nmjicon'},
        { view: "menuspinner", id: "detailSpinner", batch: "movie_detail", align: "left", label1: "10,000 BC",
            label2: "Overview", css: 'menuspinner1', popup: "detailMenu"},
        { view: "imagebutton", id: "detail_menu", batch: "movie_detail", popup: "settingsMenuDetail", label: "",
            width: 64, align: 'right', src: 'images/settings.png', css: 'settings'},
        { view: "imagebutton", id: "refresh_detail", batch: "movie_detail", align: "right", src: "images/refresh.png",
            width: 64, css: 'settings'},
        { view: "imagebutton", id: "watched", batch: "movie_detail", align: "right", src: "images/watched.png",
            width: 64, css: 'settings', click: 'handleWatched'},
        { view: "imagebutton", id: "chapters", batch: "movie_detail", align: "right", src: "images/chapters.png",
            width: 64, css: 'settings', click: "showChapters"},
        { view: "imagebutton", id: "mark_favourite", batch: "movie_detail", align: "right", src: "images/fav_unsel.png",
            width: 64, css: 'settings', click: 'handleFavorite'},
        { view: "imagebutton", id: "movie_play", batch: "movie_detail", align: "right", src: "images/play.png",
            width: 64, css: 'settings'},
        { view: "imagebutton", id: "actor_back", batch: "actor_detail", popup: "", label: "",
            width: 64, align: 'left', src: 'images/movie1.png', css: 'nmjicon'},
        { view: "menuspinner", id: "actorSpinner", batch: "actor_detail", align: "left", label1: "",
            label2: "Biography", css: 'menuspinner1', popup: "actorMenu"},
        { view: "imagebutton", id: "source_back", batch: "source", popup: "", label: "",
            width: 64, align: 'left', src: 'images/movie1.png', css: 'nmjicon'},
        { view: "toggle", id: "togg2", batch: "source", align: "center", css: "source_toggle",
            options: [
                {label: "Local Media", value: 1},
                {label: "Network Media", value: 2}
            ]
        },
        /*{ view: "toggle", id: "togg", batch: "movie_detail", align: "center",
         options: [
         {label: "View", value: 1},
         {label: "Edit", value: 2}
         ]
         },*/
        { view: "button", id: "season_play", batch: "season_detail", label: "Play",
            inputWidth: 80, align: 'right' },
        { view: "button", id: "music_play", batch: "music_detail", label: "Play Album",
            inputWidth: 120, align: 'right' }
    ]
};

var config = {
    rows: [
        toolBarJS,
        movieViewJS
    ], css: 'mainLayout', id: 'layout', width:winW
};

/*function createModal() {
    var layoutDiv = findDivByAttribute('layout');
    if (document.getElementById('dhx_modal_cover') == null) {
        var child = layoutDiv.children[0];
        var modal_div = document.createElement('div');
        modal_div.setAttribute("id", "dhx_modal_cover");
        modal_div.style.position = 'absolute';
        modal_div.style.width = '100%';
        modal_div.style.height = '100%';
        modal_div.style.backgroundColor = '#000000';
        modal_div.style.zIndex = '1';
        modal_div.style.opacity = '.8';
        layoutDiv.insertBefore(modal_div, child);
        modal_div.addEventListener("click", hideModal, false);
    }
    else {
        document.getElementById('dhx_modal_cover').style.display = 'block';
    }
}*/

function handleFavorite() {
    var dataobj = $$('movieDetailView').data;
    if (dataobj.FAVOURITE == "")
        mode = "add";
    else
        mode = "remove";
    XmlHttpRequest = dhx.ajax().sync().get("http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=editFavorite&source=" + sourcePath + "&ttype=1&mode=" + mode +
        "&showid=" + dataobj.SHOW_ID);
    if (mode == "add")
        dataobj.FAVOURITE = 1;
    else
        dataobj.FAVOURITE = "";
    if (dataobj.FAVOURITE == '')
        $$('mark_favourite').setValue('images/fav_unsel.png');
    else
        $$('mark_favourite').setValue('images/fav_sel.png');
}

function handleWatched() {
    var dataobj = $$('movieDetailView').data;
    var dataobj_wall = $$('movieWallView').item($$('movieWallView').getSelected());
    if (dataobj.PLAY_COUNT == 0)
        mode = "add";
    else
        mode = "remove";
    XmlHttpRequest = dhx.ajax().sync().get("http://"+ipaddress+":"+port+"/NMJManagerTablet_web/getXML.php?xml=editWatched&source=" + sourcePath + "&ttype=1&mode=" + mode +
        "&showid=" + dataobj.SHOW_ID);
    if (mode == "add") {
        dataobj.PLAY_COUNT = 1;
        dataobj_wall.PLAY_COUNT = 1;
    }
    else {
        dataobj.PLAY_COUNT = 0;
        dataobj_wall.PLAY_COUNT = 0;
    }
    $$('movieDetailView').render();
    $$('movieWallView').render($$('movieWallView').getSelected(), dataobj);
    if (dataobj.PLAY_COUNT == 0)
        $$('watched').setValue('images/unwatched.png');
    else
        $$('watched').setValue('images/watched.png');
}

// Handy JavaScript to meature the size taken to render the supplied text;
// you can supply additional style information too if you have it to hand.

function measureText(pText, pFontSize, pStyle) {
    var lDiv = document.createElement('lDiv');

    document.body.appendChild(lDiv);

    if (pStyle != null) {
        lDiv.style = pStyle;
    }
    lDiv.style.fontSize = "" + pFontSize + "px";
    lDiv.style.position = "absolute";
    lDiv.style.left = -1000;
    lDiv.style.top = -1000;

    lDiv.innerHTML = pText;

    var lResult = {
        width: lDiv.clientWidth,
        height: lDiv.clientHeight
    };

    document.body.removeChild(lDiv);
    lDiv = null;

    return lResult;
}


function checkResolution() {
    if (typeof window.orientation !== 'undefined') {
        winW = window.outerWidth;
        winH = window.innerHeight;
    } else {
        winW = window.innerWidth;
        winH = window.innerHeight;
    }
}

function getWidth() {
    xWidth = null;
    if (window.screen != null)
        xWidth = window.screen.availWidth;

    if (window.innerWidth != null)
        xWidth = window.innerWidth;

    if (document.body != null)
        xWidth = document.body.clientWidth;

    return xWidth;
}

function getHeight() {
    xHeight = null;
    if (window.screen != null)
        xHeight = window.screen.availHeight;

    if (window.innerHeight != null)
        xHeight = window.innerHeight;

    if (document.body != null)
        xHeight = document.body.clientHeight;

    return xHeight;
}

function fix_layout(dir) {
    if (dir) {
        var wallColumns = 4;
        winW = realHeight;
        if (realWidth > realHeight)
            winW = realHeight;
        else
            winW = realWidth;
    }
    else {
        var wallColumns = 6;
        if (realWidth < realHeight)
            winW = realHeight;
        else
            winW = realWidth;
    }
    thumbWidth = Math.round((winW - (wallColumns + 1) * 10) / wallColumns);
    defaultLoad = Math.round(realHeight / (thumbWidth * 1.5));
    $$("movieWallView").render();
}
