#!/bin/sh

if [ -e "/nmt/apps" ]; then
	NMTAPPS_LOCATION="/nmt/apps"
else
	NMTAPPS_LOCATION="/mnt/syb8634"
fi

install()
{
    if [ ! -f "$NMTAPPS_LOCATION/server/nzb_backup" ]; then
        mv $NMTAPPS_LOCATION/server/nzb $NMTAPPS_LOCATION/server/nzb_backup
        echo "#!/bin/sh

/share/Apps/AppInit/appinit.cgi \$1 NZBget
" > $NMTAPPS_LOCATION/server/nzb
    chmod a+x $NMTAPPS_LOCATION/server/nzb
    fi
    
    #for maximum compatability remove the current config folder
    #if [ -f "/share/Apps/NZBget/.nzbget/nzbget.conf" ]; then
    #   rm -Rf -Rf /share/Apps/NZBget/.nzbget/nzbget.conf
    #fi
	
    if [ -e /share/Apps/NZBget/.nzbget/ ]; then
        if [ -e /share/Apps/NZBget/.nzbget/nzbget.conf ]; then
            chmod 666 /share/Apps/NZBget/.nzbget/nzbget.conf
			rm -Rf /share/Apps/NZBget/nzbget.conf.example
        else
            mv /share/Apps/NZBget/nzbget.conf.example /share/Apps/NZBget/.nzbget/nzbget.conf
            chmod 666 /share/Apps/NZBget/.nzbget/nzbget.conf
        fi
    else
		mkdir -p /share/Apps/NZBget/.nzbget -m 777
        mv /share/Apps/NZBget/nzbget.conf.example /share/Apps/NZBget/.nzbget/nzbget.conf
    fi

    if [ -e /share/Apps/NZBget/.nzbget/postprocess.conf ]; then
		mv /share/Apps/NZBget/.nzbget/postprocess.conf /share/Apps/NZBget/.nzbget/nzbget-postprocess.conf
    fi

    if [ -e /share/Apps/NZBget/.nzbget/nzbget-postprocess.conf ]; then
		chmod 666 /share/Apps/NZBget/.nzbget/nzbget-postprocess.conf
		rm -Rf /share/Apps/NZBget/nzbget-postprocess.conf 
	else
		mv /share/Apps/NZBget/nzbget-postprocess.conf /share/Apps/NZBget/.nzbget/nzbget-postprocess.conf
		chmod 666 /share/Apps/NZBget/.nzbget/nzbget-postprocess.conf
    fi

    if [ -e /share/Apps/NZBget/.nzbget/postprocess.sh ]; then
		rm -Rf /share/Apps/NZBget/.nzbget/postprocess.sh
    fi

    if [ -e /share/Apps/NZBget/nzbget-postprocess.sh ]; then
		mv /share/Apps/NZBget/nzbget-postprocess.sh /share/Apps/NZBget/.nzbget/nzbget-postprocess.sh
		chmod 666 /share/Apps/NZBget/.nzbget/nzbget-postprocess.sh
	fi

    if [ -e /share/Apps/NZBget/web ]; then
		rm -Rf /share/Apps/NZBget/web
	fi
	
	if [ -e /share/Apps/NZBget/postprocess.conf ]; then
		rm -Rf /share/Apps/NZBget/postprocess.conf
    fi

    if [ -e /share/Apps/NZBget/postprocess.sh ]; then
		rm -Rf /share/Apps/NZBget/postprocess.sh
    fi
	
	if grep -Fxq "SecurePort=6791" /share/Apps/NZBget/.nzbget/nzbget.conf
	then
		echo "code is found"
	else
		echo "SecurePort=6791" >> /share/Apps/NZBget/.nzbget/nzbget.conf
	fi
	
	if grep -Fxq "UnrarCmd=/share/Apps/NZBget/bin/unrar" /share/Apps/NZBget/.nzbget/nzbget.conf
	then
		echo "code is found"
	else
		echo "UnrarCmd=/share/Apps/NZBget/bin/unrar" >> /share/Apps/NZBget/.nzbget/nzbget.conf
	fi
	
	if grep -w "share/Apps/NZBget/web" /share/Apps/NZBget/.nzbget/nzbget.conf
	then
		sed -i -e "s#share/Apps/NZBget/web#share/Apps/NZBget/webui#g" /share/Apps/NZBget/.nzbget/nzbget.conf
	fi
	
	if grep -Fxq "UnrarCmd=unrar" /share/Apps/NZBget/.nzbget/nzbget.conf
	then
		sed -i "s#UnrarCmd=unrar#UnrarCmd=/share/Apps/NZBget/bin/unrar#g" /share/Apps/NZBget/.nzbget/nzbget.conf
	fi
	
	if grep -Fxq "$MAINDIR=/share/Apps/NZBget/.nzbget" /share/Apps/NZBget/.nzbget/nzbget.conf
	then
		sed -i "s#\$MAINDIR=/share/Apps/NZBget/.nzbget#MainDir=/share/Apps/NZBget/.nzbget#g" /share/Apps/NZBget/.nzbget/nzbget.conf
	fi
	
	if grep -Fxq "PostProcess=/share/Apps/NZBget/postprocess.sh" /share/Apps/NZBget/.nzbget/nzbget.conf
	then
		sed -i "s#PostProcess=/share/Apps/NZBget/postprocess.sh#PostProcess=/share/Apps/NZBget/.nzbget/nzbget-postprocess.sh#g" /share/Apps/NZBget/.nzbget/nzbget.conf
	fi
chmod 666 /share/Apps/NZBget/.nzbget/nzbget.conf
}

uninstall()
{
    if [ -f "$NMTAPPS_LOCATION/server/nzb_backup" ]; then
		rm $NMTAPPS_LOCATION/server/nzb
		sleep 1
        mv $NMTAPPS_LOCATION/server/nzb_backup $NMTAPPS_LOCATION/server/nzb
    fi
}


case "$1" in
    install)
    install
    ;;
    
    uninstall)
    uninstall
    ;;
esac
