#!/bin/sh

INSTALL_ROOT=/share/Apps/openssh
PATH=$PATH:/sbin:/usr/sbin:/bin:/usr/bin:${INSTALL_ROOT}/bin:${INSTALL_ROOT}/sbin;export PATH
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:${INSTALL_ROOT}/lib;export LD_LIBRARY_PATH
DESC="OpenSSH Server v8.4p1"
NAME=sshd
PIDFILE=/var/run/$NAME.pid
START_STOP_DAEMON="${INSTALL_ROOT}/bin/busybox start-stop-daemon"
DAEMON=$INSTALL_ROOT/sbin/$NAME

check_privsep_dir() {
    # Create the PrivSep empty dir if necessary
    if [ ! -d /var/run/sshd ]; then
        mkdir /var/run/sshd
        chmod 0755 /var/run/sshd
    fi
}

start_server() {
    if [ ! -f ${INSTALL_ROOT}/etc/ssh/ssh_host_rsa_key ]; then
        ${INSTALL_ROOT}/bin/ssh-keygen -t rsa -f ${INSTALL_ROOT}/etc/ssh/ssh_host_rsa_key -N ""
    fi

    if [ ! -f ${INSTALL_ROOT}/etc/ssh/ssh_host_dsa_key ]; then
        ${INSTALL_ROOT}/bin/ssh-keygen -t dsa -f ${INSTALL_ROOT}/etc/ssh/ssh_host_dsa_key -N ""
    fi

    if [ ! -f ${INSTALL_ROOT}/etc/ssh/ssh_host_ecdsa_key ]; then
        ${INSTALL_ROOT}/bin/ssh-keygen -t ecdsa -f ${INSTALL_ROOT}/etc/ssh/ssh_host_ecdsa_key -N ""
    fi

    if [ ! -f ${INSTALL_ROOT}/etc/ssh/ssh_host_ed25519_key ]; then
        ${INSTALL_ROOT}/bin/ssh-keygen -t ed25519 -f ${INSTALL_ROOT}/etc/ssh/ssh_host_ed25519_key -N ""
    fi

    if [ ! -d /root ] ;  then
        mkdir /root
        chmod 755 /root
    fi

    cp -f /etc/passwd /etc/passwd.sshd
    sed 's#/root:/bin/true#/root:/bin/sh#g' /etc/passwd > /etc/passwd.tmp
    mv /etc/passwd.tmp /etc/passwd
    chmod 644 /etc/passwd
    cp -f /etc/shadow /etc/shadow.sshd
    echo -e "1234\n1234"|/usr/bin/passwd root

    $START_STOP_DAEMON --start --quiet --pidfile $PIDFILE \
                --exec $DAEMON -- $SSHD_OPTS
}

stop_server() {
    $START_STOP_DAEMON --stop --retry 5 --quiet --oknodo --pidfile $PIDFILE || return 2

    if [ -f /etc/password.sshd ];then
        mv -f /etc/passwd.sshd /etc/passwd
    fi

    if [ -f /etc/shadow.sshd ];then
        mv -f /etc/shadow.sshd /etc/shadow
    fi

    sleep 1
}

status_of_proc() {
    PID=$(cat "$1")
    NO_PROCESS=$(ps |grep PID|grep -cv grep)
    if [ $NO_PROCESS -eq 1 ];then
        echo "$2 is running"
    else
        echo "$2 is not running"
    fi
}

case "$1" in
    start)
        echo "Starting $DESC" 
        check_privsep_dir
        start_server
        exit $?
        ;;
    stop)
        echo "Stopping $DESC" 
        stop_server
        exit $?
        ;;
    restart)
        stop_server
        sleep 1
        start_server
        ;;
    status)
        status_of_proc $PIDFILE $NAME
        exit 0
        ;;
    *)  
        echo "Usage: $0 {start|stop|restart|status}" >&2
        exit 2
        ;;
esac

exit 0
