if (typeof window.orientation !== 'undefined') {
    var winW = window.outerWidth;
    var winH = window.outerHeight;
}
else {
    var winW = window.innerWidth;
    var winH = window.innerHeight;
}

function getElementByClass(className, parent) {
    parent || (parent = document);
    var descendants = parent.getElementsByTagName('*'), i = -1, e, result = [];
    while (e = descendants[++i]) {
        ((' ' + (e['class'] || e.className) + ' ').indexOf(' ' + className + ' ') > -1) && result.push(e);
    }
    return result;
}

var wallColumns = Math.floor(winW / 192);
var thumbWidth = (winW - (wallColumns * 192)) / wallColumns;
thumbWidth = thumbWidth + 192;

var sources = [
    {id: 1, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/7sTwiVaYpVDS21jYG8P265En292.jpg"},
    {id: 2, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/Ak0QAlJh05jLSmFl5zDU8c0PXyD.jpg"},
    {id: 3, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/wTNPOPKoXyYlMJyVU1CmB6roSHg.jpg"},
    {id: 4, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/8Q4mgtnS4K5gaMqNjtC6Y17uqr.jpg"},
    {id: 5, img: "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w780/orTowcvqNubSV2CMr07zZNDliGp.jpg"}
]

var musicWallView = {
    view: 'dataview', select: 'single', scroll: 'y',
    type: { height: 230, width: thumbWidth, padding: 0, margin: 0},
    id: 'MusicWallView',
    template: function (obj) {
        if (typeof obj.TITLE != 'undefined') {
            if (obj.TITLE.length > 12)
                title = obj.TITLE.replace(/&apos;/g, "'").substring(0, 11) + "...";
            else
                title = obj.TITLE;
            //width = measureText(obj.NAME.length, "18", "Tahoma");
            if (obj.NAME.length > 18)
                name = obj.NAME.replace(/&apos;/g, "'").substring(0, 17) + "...";
            else
                name = obj.NAME;
            if (obj.THUMBNAIL == 'NULL')
                thumbnail = 'images/gridview_music_wall_default_thumb.jpg';
            else
                thumbnail = obj.THUMBNAIL;

            var output = "<div class='music_thumbnail_div' style='width:176px;left:" + ((thumbWidth - 176) / 2) + "px;'><img class='music_frame' src='images/gridview_music_wall_thumb_base.png'><img class='music_thumbnail' src='" + thumbnail + "' onError=\"this.src='images/gridview_music_wall_default_thumb.jpg'\" >";
            output += "<img class='music_glass_frame' src='images/gridview_music_wall_thumb_glass.png'>";
            output += "</div><div class='music_thumbnail_div2' style='left:" + ((thumbWidth - 161) / 2) + "px;'><div class='title'>" + title + "</div><div class='artist'>" + name + "</div></div></div>";
            return output;
        }
    }
};

function getCertificationImage(parental_rating) {
    parental_rating_img = "images/rating_ur.png";

    if (parental_rating == 'R')
        parental_rating_img = "images/common_mpaa_r.png";
    else if (parental_rating == 'PG-13')
        parental_rating_img = "images/common_mpaa_pg_13.png";
    else if (parental_rating == 'PG-15')
        parental_rating_img = "images/common_mpaa_pg_15.png";
    else if (parental_rating == 'PG')
        parental_rating_img = "images/common_mpaa_pg.png";
    else if (parental_rating == 'NC-17')
        parental_rating_img = "images/common_mpaa_nc_17.png";
    else if (parental_rating == 'G')
        parental_rating_img = "images/common_mpaa_g.png";
    else if (parental_rating == 'TV-MA')
        parental_rating_img = "images/tv_ma.png";
    else if (parental_rating == 'TV-14')
        parental_rating_img = "images/tv_14.png";
    else if (parental_rating == 'TV-PG')
        parental_rating_img = "images/tv_pg.png";
    else if (parental_rating == 'TV-G')
        parental_rating_img = "images/tv_g.png";
    else if (parental_rating == 'TV-Y')
        parental_rating_img = "images/tv_y.png";
    else if (parental_rating == 'TV-Y7')
        parental_rating_img = "images/tv_y7.png";
    else if (parental_rating == '12')
        parental_rating_img = "images/uk_12.png";
    else if (parental_rating == '12A')
        parental_rating_img = "images/uk_12a.png";
    else if (parental_rating == '15')
        parental_rating_img = "images/uk_15.png";
    else if (parental_rating == '18')
        parental_rating_img = "images/uk_18.png";
    else if (parental_rating == 'U')
        parental_rating_img = "images/uk_u.png";
    else if (parental_rating == 'R18')
        parental_rating_img = "images/uk_r18.png";
    return parental_rating_img;
}

function getRatingImage(rating) {
    rating = rating.replace(",", ".");
    var rating_img;
    if (rating == 0 || rating == 'NULL')
        rating_img = "images/common_star_0.png";
    if (rating <= 1 && rating > 0)
        rating_img = "images/common_star_1.png";
    else if (rating <= 2 && rating > 1)
        rating_img = "images/common_star_2.png";
    else if (rating <= 3 && rating > 2)
        rating_img = "images/common_star_3.png";
    else if (rating <= 4 && rating > 3)
        rating_img = "images/common_star_4.png";
    else if (rating <= 5 && rating > 4)
        rating_img = "images/common_star_5.png";
    else if (rating <= 6 && rating > 5)
        rating_img = "images/common_star_6.png";
    else if (rating <= 7 && rating > 6)
        rating_img = "images/common_star_7.png";
    else if (rating <= 8 && rating > 7)
        rating_img = "images/common_star_8.png";
    else if (rating <= 9 && rating > 8)
        rating_img = "images/common_star_9.png";
    else if (rating <= 10 && rating > 9)
        rating_img = "images/common_star_10.png";
    return rating_img;
}

var movieWallView = {
    view: 'dataview', select: 'single', scroll: 'y',
    type: { height: 320, width: thumbWidth, padding: 0, margin: 0},
    id: 'MovieWallView',
    template: function (obj) {
        if (typeof obj.TITLE != 'undefined') {
            if (obj.TITLE.length > 12)
                title = obj.TITLE.replace(/&apos;/g, "'").substring(0, 11) + "...";
            else
                title = obj.TITLE;
            rating = getRatingImage(obj.RATING);
            parental_rating = getCertificationImage(obj.PARENTAL_CONTROL);

            if (obj.THUMBNAIL == 'NULL')
                thumbnail = 'images/gridview_video_default_thumb.jpg';
            else
                thumbnail = obj.THUMBNAIL;

            var output = "<div class='thumbnail_div' style='width:176px;left:" + ((thumbWidth - 176) / 2) + "px;'><img class='frame' src='images/gridview_wall_thumb_base.png'><img class='thumbnail' src='" + thumbnail + "' onError=\"this.src='images/gridview_video_default_thumb.jpg'\" >";
            output += "<img class='glass_frame' src='images/gridview_wall_thumb_glass.png'>";
            if (typeof obj.PLAY_COUNT != 'undefined' && obj.PLAY_COUNT != 0)
                output += "<img class='last_watched' src='images/movieinfo_icon_watched.png'>";
            output += "</div><div class='thumbnail_div2' style='left:" + ((thumbWidth - 161) / 2) + "px;'><div class='title'>" + title + "</div><div class='rating'><img src='" + rating + "' style='width:70px;'></div><div class='year'>" + obj.YEAR + "</div><div class='parental_rating'><img src='" + parental_rating + "' style='height:15px;'></div></div></div>";
            return output;
        }
    }
};

var season = {
    view: "popup",
    css: "season_popup",
    body: {
        view: 'dataview',
        id: 'seasonView',
        select: 'single',
        scroll: 'x',
        css: 'season',
        animate: true,
        datatype: "json",
        type: { height: 350, width: thumbWidth, padding: 0, margin: 0},
        template: function (obj) {
            if (typeof obj.SEASON_TITLE != 'undefined') {
                var pos = obj.SEASON_TITLE.indexOf("Season");
                title = obj.SEASON_TITLE.substr(pos);
            }
            else
                title = obj.TITLE;

            if (title.length > 12)
                title = title.replace(/&apos;/g, "'").substring(0, 11) + "...";

            rating = getRatingImage(obj.RATING);
            parental_rating = getCertificationImage(obj.PARENTAL_CONTROL);

            if (obj.THUMBNAIL == 'NULL')
                thumbnail = 'images/gridview_video_default_thumb.jpg';
            else
                thumbnail = obj.THUMBNAIL;

            var output = "<div class='thumbnail_div' style='width:176px;left:" + ((thumbWidth - 176) / 2) + "px;'><img class='frame' src='images/gridview_wall_thumb_base.png'><img class='thumbnail' src='" + thumbnail + "'>";
            output += "<img class='glass_frame' src='images/gridview_wall_thumb_glass.png'>";
            if (typeof obj.PLAY_COUNT != 'undefined' && obj.PLAY_COUNT != 0)
                output += "<img class='last_watched' src='images/movieinfo_icon_watched.png'>";
            output += "</div><div class='thumbnail_div2' style='left:" + ((thumbWidth - 161) / 2) + "px;font-weight: normal;'><div class='title'>" + title + "</div><div class='rating'><img src='" + rating + "' style='width:70px;'></div><div class='year'>" + obj.YEAR + "</div><div class='parental_rating'><img src='" + parental_rating + "' style='height:15px;'></div></div></div>";
            return output;
        },
        height: 414
    },
    animate: true,
    left: 0,
    hidden: true,
    id: "season",
    padding: false
};

var wallpaper = {
    view: "window",
    head: { view: "toolbar", type: "MainBar", css: "topBar", elements: [
        {view: "label", label: "Wallpaper", align: 'left'}
    ]
    },
    body: {
        view: "pagelist",
        id: "wallpaper_pagelist",
        height: 281,
        width: 518,
        datatype: "xml",
        template: wallpaper_img,
        type: {
            css: "frame",
            height: 281,
            width: 500
        },
        panel: false
    },
    id: "wallpaper",
    css: "wallpaper",
    hidden: true,
    height: 330
};


var poster = {
    view: "window",
    head: { view: "toolbar", type: "MainBar", css: "topBar", elements: [
        {view: "label", label: "Poster", align: 'left'}
    ]
    },
    body: {
        view: "pagelist",
        id: "poster_pagelist",
        height: 342,
        width: 243,
        datatype: "xml",
        template: poster_img,
        type: {
            css: "poster2",
            height: 332,
            width: 222
        },
        panel: false
    },
    id: "poster",
    hidden: true,
    height: 340
};

function wallpaper_img(obj) {
    return '<img src="' + obj.image + '" width="500" height="281" ondragstart="return false"/>'
}

function poster_img(obj) {
    return '<img src="' + obj.image + '" width="220" height="330" ondragstart="return false"/>'
}


var editPopup = {
    view: "popup",
    id: "MainMenu",
    hidden: true,
    height: 400,
    width: 200,
    css: "mainmenu",
    body: {
        view: "grouplist",
        id: "GroupMenu",
        scroll: true,
        animate: true,
        datatype: "xml",
        templateItem: "#name#",
        templateGroup: "#name#",
        templateBack: "#name#",
        select: true,
        y_count: 3
    }
};

var popupMenu = {
    view: "popup",
    id: "MainMenu",
    hidden: true,
    height: 400,
    width: 200,
    css: "mainmenu",
    body: {
        view: "grouplist",
        id: "GroupMenu",
        scroll: true,
        animate: true,
        datatype: "xml",
        templateItem: "#name#",
        templateGroup: "#name#",
        templateBack: "#name#",
        select: true,
        y_count: 3
    }
};

function minutesToTime(mins)
{
        var hours = Math.floor(mins / 60);

        var divisor_for_minutes = mins % 60;
        var minutes = Math.floor(divisor_for_minutes);

        var obj = {
                "h": hours,
                "m": minutes
        };
        return hours+' hours '+minutes+' minutes';
}

function reloadMusicWall(id) {
    $$("MusicWallView").clearAll();
    $$("title").setValue(id.name + ": " + id.textContent);
    $$("MusicWallView").load("getXML.php?xml=getMusic&count=" + (wallColumns * 3) + "&TYPE=" + id.name + "&VALUE=" + id.textContent);
    $$('MusicWallView').show();
    dhx.delay($$("Toolbar").showBatch, $$("Toolbar"), ["wall"], 550);
}

function playMedia(media, type, time) {
    XmlHttpRequest = dhx.ajax().sync().get("getXML.php", "xml=playMedia&type=" + type + "&media=" + media + "&time=" + time);
    hideModal();
}

function reloadMovieWall(id) {
    //if ($$("togg").getValue() == 1) {
    xy = 0;
    $$("MovieWallView").clearAll();
    $$("title").setValue(id.name + ": " + id.textContent);
    $$("MovieWallView").load("getXML.php?xml=getMovies&count=" + (wallColumns * 3) + "&TYPE=" + id.name + "&VALUE=" + id.textContent);
    $$('MovieWallView').show();
    dhx.delay($$("Toolbar").showBatch, $$("Toolbar"), ["wall"], 550);
    /*}
     else {
     if (id.name == 'Director') {
     alert('director');
     }
     else if (id.name == 'Genre') {

     }
     else if (id.name == 'Year') {

     }
     else if (id.name == 'Cast') {

     }
     }*/
}

function seasonHTML(obj) {
    rating = getRatingImage(obj.RATING);
    parental_rating = getCertificationImage(obj.PARENTAL_CONTROL);

    if (obj.POSTER == 'NULL' || obj.POSTER == '')
        poster = 'images/movieinfo_big_video_default_thumb.jpg';
    else
        poster = obj.POSTER.replace(/\'/g, "%27");
    if (obj.WALLPAPER == '')
        wallpaper = 'images/no_wallpaper.jpg';
    else
        wallpaper = obj.WALLPAPER.replace(/\'/g, "%27");
    var Template = '<div id="dhx_episode_cover" style="position: absolute; width: 100%; height: 100%; background-color: rgb(0, 0, 0); z-index: 4; opacity: .7; display: none;" onclick="hideModal();"></div>';
    Template += '<div class="episode_div" id="episode_div" style="display:none;height: 100%;float:right;top:0px;position:relative;"><div class="dhx_scroll_cont" touch_scroll="y" style="-webkit-transform: translate3d(0px, 0px, 0); -webkit-transition: -webkit-transform 0ms; transition: -webkit-transform 0ms; -webkit-user-select: none; -webkit-transform-style: flat;height: ' + ((obj.episodes.length * 77) + 246) + 'px;">';

    for (var j = 0; j < obj.episodes.length; j++) {
        if (obj.episodes[j].TITLE.length > 45)
            title = obj.episodes[j].TITLE.replace(/&apos;/g, "'").substring(0, 44) + "...";
        else
            title = obj.episodes[j].TITLE;
        Template += '<div class="episodes" style="white-space: nowrap;width:482px;margin-top: 20px; margin-left: 80px;" onclick="showEpisodeDetails(' + (j + 1) + ');">' + title + '<br\>';
        Template += '<span class="episodes" style="white-space: nowrap;width:200px;font-size: 15px;margin-top: 10px;">Episode ' + obj.episodes[j].EPISODE + '</span><span class="episodes" style="position: relative;font-size: 15px;right: 100px;text-align:right;width:50px;float:right;">' + obj.episodes[j].RUNTIME + '</span></div>';
        Template += '<div class="episode_details" style="display:none;height: 246px;margin-left:60px;background-image: url(images/movieinfo_episode_sypnopsis_pane.9.png);">';
        Template += '<div style="font-size: 20px;line-height: 32px;text-align:left;font-family: Tahoma;text-shadow:none;font-weight:normal;color: white;left:22px;top:20px;width: 300px;position: relative;">Synopsis</div>';
        Template += '<div style="font-size: 14px;text-align:left;font-family: Tahoma;text-shadow:none;font-weight:normal;left:22px;color: white;top:20px;line-height: 24px;height: 150px; width:390px;position: relative;">' + obj.episodes[j].SYNOPSIS + '</div>';
        Template += '<div class="play" style="width:50px;"><input type="button" style="top: 27px;width: 50px; left: 350px;" onclick="';
        Template += 'playMedia(\'' + obj.episodes[j].PATH + '\', \'movie\', 0);"';
        Template += ' value="Play"></div></div>';
    }
    Template += '</div></div></div></div>';
    Template += '<div class="dhx_view dhx_multiview" view_id="MovieView" style="vertical-align: top; border-left-width: 0px; border-right-width: 0px; border-bottom-width: 0px; margin-top: -1px; width: 100%; height: 100%;position:absolute;"><div class="dhx_view" view_id="SeasonDetailView" style="border-width: 1px 0px 0px; width: 100%; height: 100%;">';
    Template += '<div class="dhx_view dhx_multiview" id="MovieView" style="vertical-align: top; border-left-width: 0px; border-right-width: 0px; border-bottom-width: 0px; margin-top: -1px;height:100%;background-size: 100%;background-image: url(\'' + wallpaper + '\');">';
    Template += '<div class="dhx_view dhx_toolbar dhx_mainbar topBar" id="detailToolbar" style="border-width: 1px 0px; vertical-align: top; margin-top: -1px; width: 100%;bottom:207px; position: absolute;"><div class="dhx_scroll_cont"><div class="dhx_view dhx_el_tabbar" view_id="tabbar1" style="border-width: 0px; float: left; width:100%; height: 49px;">';
    Template += '<div class="dhx_all_tabs" style="position: absolute;align: left;left: 270px;"><div><span id="button_1" onclick="showDiv(\'movieinfo\');" style="color: #4e9fb0;">Movie Info</span></div><div><span id="button_2" onclick="showDiv(\'synopsis\');">Synopsis</span></div><div><span id="button_3" style="color: grey;cursor: default;">File Info</span></div><div>';
    if (typeof obj.BOOKMARK_TIME != 'undefined')
        Template += '<span id="button_4" onclick="showDiv(\'last_watched\');">Last Watched</span></div>';
    else
        Template += '<span id="button_4" style="color: grey;cursor: default;">Last Watched</span></div>';
    Template += '<div class="dhx_view dhx_el_button" style="border-width: 0px;margin-left:100px;"><input type="button" style="width: 90px;height: 35px;float: right;" onclick="showEpisodes();" value="Episodes"></div>';
    Template += '</div></div></div></div>';
    Template += '<div class="dhx_view dhx_multiview" id="bottomdiv" style="position: absolute;width: 100%;height: 207px;border-width: 1px 0px 0px; margin-top: -1px;opacity: 0.8;bottom: 0px;"><div style="font-size: 30px; color: white;position: absolute;border-width: 0px;left: 280px; align: left;font-family: Tahoma;bottom: 160px;white-space: nowrap;"><div id="movietitle">' + obj.TITLE + '</div></div></div>';
    Template += '<div id="movieinfo"><div style="vertical-align: middle;font-size: 22px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom:125px;"><div id="directedby" style="white-space: nowrap;">Directed By: ';
    var isarray = 0;
    if (typeof obj.DIRECTOR != 'undefined')
        isarray = obj.DIRECTOR.indexOf('#');
    if (isarray > 0) {
        var directors = obj.DIRECTOR.split('#');
        var bullet = '&emsp;&bull;&emsp;';
        Template += '<span class="htmlselect"><a href="#" id="director" name="Director" onclick="reloadMovieWall(this);">' + directors[0] + '</a></span>';
        for (var j = 1; j < directors.length; j++) {
            Template += bullet;
            Template += '<span class="htmlselect"><a href="#" id="director" name="Director" onclick="reloadMovieWall(this);">' + directors[j] + '</a></span>';
        }
    }
    else
        Template += '<span class="htmlselect"><a href="#" id="director" name="Director" onclick="reloadMovieWall(this);">' + obj.DIRECTOR + '</a></span>';
    Template += '</div></div>';
    Template += '<div class="rating" style="position: absolute;left: 280px;bottom: 105px;"><img src="' + rating + '" style="width:50px;"></div><div style="font-size: 15px; color: grey;position: absolute;white-space: nowrap;border-width: 0px;align: left;left: 280px; bottom: 80px;"><div class="htmlselect">';
    if (typeof obj.CAST != 'undefined')
        isarray = obj.CAST.indexOf('#');
    if (isarray > 0) {
        var cast = obj.CAST.split('#');
        var bullet = '&emsp;&bull;&emsp;';
        Template += '<span><a href="#" id="cast" name="Cast" onclick="reloadMovieWall(this);">' + cast[0] + '</a></span>';
        if (cast.length >= 5)
            tot_cast = 5;
        else
            tot_cast = cast.length;
        for (var j = 1; j < tot_cast; j++) {
            Template += bullet;
            Template += '<span><a href="#" id="cast" name="Cast" onclick="reloadMovieWall(this);">' + cast[j] + '</a></span>';
        }
    }
    else
        Template += '<span><a href="#" id="cast" name="Cast" onclick="reloadMovieWall(this);">' + obj.CAST + '</a></span>';
    Template += '</div></div><div style="font-size: 15px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 55px;white-space: nowrap;"><div class="htmlselect">';
    if (typeof obj.GENRE != 'undefined')
        isarray = obj.GENRE.indexOf('#');
    if (isarray > 0) {
        var genre = obj.GENRE.split('#');
        var bullet = '&emsp;&bull;&emsp;';
        Template += '<span><a href="#" id="genre" name="Genre" onclick="reloadMovieWall(this);">' + genre[0] + '</a></span>';
        for (var j = 1; j < genre.length; j++) {
            Template += bullet;
            Template += '<span><a href="#" id="genre" name="Genre" onclick="reloadMovieWall(this);">' + genre[j] + '</a></span>';
        }
    }
    else
        Template += '<span><a href="#" id="genre" name="Genre" onclick="reloadMovieWall(this);">' + obj.GENRE + '</a></span>';
    Template += '</div></div>';
    Template += '<div style="font-size: 15px; vertical-align: middle;color: grey;position: absolute;border-width: 0px;align: left;left: 280px;';
    Template += 'white-space: nowrap;bottom: 30px;"><div class="htmlselect"><span><a href="#" id="year" name="Year" onclick="reloadMovieWall(this);">';
    Template += obj.YEAR + '</a></span>&emsp;&bull;&emsp;<span>' + minutesToTime(obj.RUNTIME) + '</span>&emsp;&bull;&emsp;';
    Template += '<span style="top: 5px;"><img  src="' + parental_rating + '" style="height:15px;"></span></div> </div></div>';
    Template += '<div id="synopsis" style="visibility: hidden;"><div style="font-size: 16px; color: grey;position: absolute;border-width: 0px;text-align: left;left: 280px; bottom: 0px; height: 150px;font-family:Tahoma;">' + obj.CONTENT + '</div></div>';
    Template += '<div id="fileinfo" style="font-family: Tahoma;visibility: hidden;"><div style="font-size: 16px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 125px;"><div style="float: left;">' + obj.PATH + '</div></div>';
    Template += "<div id='last_watched' class='lastwatched' style='visibility: hidden;font-size: 16px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 30px; font-family:Tahoma;width: 215px;height;121px;background-image: url(images/movieinfo_last_watched_base.png);'><div class='lastwatched_scene' style='position: absolute; background-image: url(";
    if (typeof obj.BOOKMARK_THUMBNAIL != 'undefined')
        Template += obj.BOOKMARK_THUMBNAIL;
    Template += ");width:211px;height:117px;bottom:2px;left:2px;'><div class='lastwatched_glass' style='position: absolute;background-image: url(images/movieinfo_last_watched_glass.png);width:215px;height:121px;left: -2px;bottom:-2px;'><div class='play' style='position: absolute;width: 55px;height:55px;left: 80px;bottom: 33px;background-image: url(images/movieinfo_play_big.png);'></div></div></div><div style='font-family: Tahoma;font-size: 16px; color: white;left:220px;top:100px;'>";
    if (typeof obj.BOOKMARK_TIME != 'undefined')
        Template += obj.BOOKMARK_TIME;
    Template += "</div></div>";
    Template += '<div style="font-size: 15px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 82px;"><div><span>Subtitle</span></div></div>';
    Template += '<div style="font-size: 16px; color: white;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 55px;"><div><span>UNKNOWN</span></span></div></div> <div style="font-size: 16px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 30px;"><div><span style="color: white;">' + obj.SYSTEM + '</span>&emsp;&bull;&emsp;<span style="color: white;">' + obj.RESOLUTION + '</span></div></div> </div></div>';
    Template += '<div class="posterframe" id="posterframe" style="background-image: url(images/movieinfo_big_thumb_base.png); position: absolute; width:222px;height:322px;bottom: 30px;"><div class="detailposter" id="detailposter" style="background-size: 220px 330px;background-image: url(\'' + poster + '\');">';
    Template += '<div class="detail_glass_frame" id="detailposter_glass" style="background-image: url(images/movieinfo_big_thumb_glass.png);"></div>';
    if (typeof obj.PLAY_COUNT != 'undefined' && obj.PLAY_COUNT != 0)
        Template += "<img class='last_watched_detail' src='images/movieinfo_icon_watched.png' style='left: 160px;top: -62px;position:relative;'>";
    Template += '</div></div></div></div></div> </div>';
    return Template;
}

function movieHTML(obj) {
    rating = getRatingImage(obj.RATING);
    parental_rating = getCertificationImage(obj.PARENTAL_CONTROL);

    if (obj.POSTER == 'NULL' || obj.POSTER == '')
        poster = 'images/movieinfo_big_video_default_thumb.jpg';
    else
        poster = obj.POSTER.replace(/\'/g, "%27");
    if (obj.WALLPAPER == '')
        wallpaper = 'images/no_wallpaper.jpg';
    else
        wallpaper = obj.WALLPAPER.replace(/\'/g, "%27");

    var no_chapters = Math.floor(obj.RUNTIME / 10) + 1;
    obj.chapters = new Array();
    for (var k = 0; k < no_chapters; k++) {
        obj.chapters[k] = new Object;
        obj.chapters[k].TITLE = 'Chapter '+(k+1);
        obj.chapters[k].EPISODE = k+1;
        obj.chapters[k].RUNTIME = 10 * k;
        obj.chapters[k].RUNTIME_TEXT = minsToHms(10 * k);
    }

    var Template = '<div id="dhx_episode_cover" style="position: absolute; width: 100%; height: 100%; background-color: rgb(0, 0, 0); z-index: 4; opacity: .7; display: none;" onclick="hideModal();"></div>';
    Template += '<div class="episode_div" id="chapter_div" style="display:none;height: 100%;float:right;top:0px;position:relative;"><div class="dhx_scroll_cont" touch_scroll="y" style="-webkit-transform: translate3d(0px, 0px, 0); -webkit-transition: -webkit-transform 0ms; transition: -webkit-transform 0ms; -webkit-user-select: none; -webkit-transform-style: flat;height: ' + ((obj.chapters.length * 73)) + 'px;">';

    for (var j = 0; j < obj.chapters.length; j++) {
        if (obj.chapters[j].TITLE.length > 45)
            title = obj.chapters[j].TITLE.replace(/&apos;/g, "'").substring(0, 44) + "...";
        else
            title = obj.chapters[j].TITLE;
        Template += '<div class="episodes" style="white-space: nowrap;width:482px;margin-top: 20px; margin-left: 80px;" onclick="';
        path = obj.PATH.replace(/\'/g, "%27");
        if (path.indexOf("nfs://") == -1 && path.indexOf("smb://") == -1)
            Template += 'playMedia(\'file://' + path + '\', \'movie\', ' + obj.chapters[j].RUNTIME + ');">';
        else
            Template += 'playMedia(\'' + path + '\', \'movie\', ' + obj.chapters[j].RUNTIME + ');">';
        Template += title + '<br\><span class="episodes" style="white-space: nowrap;width:200px;font-size: 15px;';
        Template += 'margin-top: 10px;">Chapter ' + obj.chapters[j].EPISODE + '</span><span class="episodes" ';
        Template += 'style="position: relative;font-size: 15px;right: 100px;text-align:right;width:50px;';
        Template += 'float:right;">' + obj.chapters[j].RUNTIME_TEXT + '</span></div>';
    }
    Template += '</div></div></div>';
    Template += '<div class="dhx_view dhx_multiview" view_id="MovieView" style="position: relative; vertical-align: top; border-left-width: 0px; border-right-width: 0px; border-bottom-width: 0px; margin-top: -1px; width: 100%; height: 100%;position: absolute;"><div class="dhx_view" view_id="MovieDetailView" style="border-width: 1px 0px 0px; width: 100%; height: 100%;">';
    Template += '<div class="dhx_view dhx_multiview" id="MovieView" style="position: relative; vertical-align: top; border-left-width: 0px; border-right-width: 0px; border-bottom-width: 0px; margin-top: -1px;height:100%;background-size: 100%;background-image: url(\'' + wallpaper + '\');">';
    Template += '<div class="dhx_view dhx_toolbar dhx_mainbar topBar" id="detailToolbar" style="border-width: 1px 0px; vertical-align: top; margin-top: -1px; width: 100%;bottom:207px; position: absolute;"><div class="dhx_scroll_cont"><div class="dhx_view dhx_el_tabbar" view_id="tabbar1" style="border-width: 0px; float: left; width:100%; height: 49px;">';
    Template += '<div class="dhx_all_tabs" style="position: absolute;align: left;left: 270px;"><div><span id="button_1" onclick="showDiv(\'movieinfo\');" style="color: #4e9fb0;">Movie Info</span></div><div><span id="button_2" onclick="showDiv(\'synopsis\');">Synopsis</span></div><div><span id="button_3" onclick="showDiv(\'fileinfo\');">File Info</span></div><div>';
    if (typeof obj.BOOKMARK_TIME != 'undefined')
        Template += '<span id="button_4" onclick="showDiv(\'last_watched\');">Last Watched</span></div>';
    else
        Template += '<span id="button_4" style="color: grey;cursor: default;">Last Watched</span></div>';
    Template += '<div class="dhx_view dhx_el_button" style="border-width: 0px;margin-left:100px;">';
    Template += '<input type="button" style="width: 90px;height: 35px;float: right;" onclick="showChapters(' + obj.chapters.length + ');" value="Chapters">';
    Template += '</div>';
    Template += '</div></div></div></div>';
    Template += '<div class="dhx_view dhx_multiview" id="bottomdiv" style="position: absolute;width: 100%;height: 207px;border-width: 1px 0px 0px; margin-top: -1px;opacity: 0.8;bottom: 0px;"><div style="font-size: 30px; color: white;position: absolute;border-width: 0px;left: 280px; align: left;font-family: Tahoma;bottom: 160px;white-space: nowrap;"><div id="movietitle">' + obj.TITLE + '</div></div></div>';
    Template += '<div id="movieinfo"><div style="vertical-align: middle;font-size: 22px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom:125px;"><div id="directedby" style="white-space: nowrap;">Directed By: ';
    var isarray = 0;
    if (typeof obj.DIRECTOR != 'undefined')
        isarray = obj.DIRECTOR.indexOf('#');
    if (isarray > 0) {
        var directors = obj.DIRECTOR.split('#');
        var bullet = '&emsp;&bull;&emsp;';
        Template += '<span class="htmlselect"><a href="#" id="director" name="Director" onclick="reloadMovieWall(this);">' + directors[0] + '</a></span>';
        for (var j = 1; j < directors.length; j++) {
            Template += bullet;
            Template += '<span class="htmlselect"><a href="#" id="director" name="Director" onclick="reloadMovieWall(this);">' + directors[j] + '</a></span>';
        }
    }
    else
        Template += '<span class="htmlselect"><a href="#" id="director" name="Director" onclick="reloadMovieWall(this);">' + obj.DIRECTOR + '</a></span>';
    Template += '</div></div>';
    Template += '<div class="rating" style="position: absolute;left: 280px;bottom: 105px;"><img src="' + rating + '" style="width:50px;"></div>';
    Template += '<div style="font-size: 15px; color: grey;position: absolute;white-space: nowrap;border-width: 0px;align: left;left: 280px;';
    Template += 'bottom: 80px;"><div class="htmlselect">';
    if (typeof obj.CAST != 'undefined')
        isarray = obj.CAST.indexOf('#');
    if (isarray > 0) {
        var cast = obj.CAST.split('#');
        var bullet = '&emsp;&bull;&emsp;';
        Template += '<span><a href="#" id="cast" name="Cast" onclick="reloadMovieWall(this);">' + cast[0] + '</a></span>';
        if (cast.length >= 5)
            tot_cast = 5;
        else
            tot_cast = cast.length;
        for (var j = 1; j < tot_cast; j++) {
            Template += bullet;
            Template += '<span><a href="#" id="cast" name="Cast" onclick="reloadMovieWall(this);">' + cast[j] + '</a></span>';
        }
    }
    else
        Template += '<span><a href="#" id="cast" name="Cast" onclick="reloadMovieWall(this);">' + obj.CAST + '</a></span>';
    Template += '</div></div><div style="font-size: 15px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 55px;white-space: nowrap;"><div class="htmlselect">';
    if (typeof obj.GENRE != 'undefined')
        isarray = obj.GENRE.indexOf('#');
    if (isarray > 0) {
        var genre = obj.GENRE.split('#');
        var bullet = '&emsp;&bull;&emsp;';
        Template += '<span><a href="#" id="genre" name="Genre" onclick="reloadMovieWall(this);">' + genre[0] + '</a></span>';
        for (var j = 1; j < genre.length; j++) {
            Template += bullet;
            Template += '<span><a href="#" id="genre" name="Genre" onclick="reloadMovieWall(this);">' + genre[j] + '</a></span>';
        }
    }
    else
        Template += '<span><a href="#" id="genre" name="Genre" onclick="reloadMovieWall(this);">' + obj.GENRE + '</a></span>';
    Template += '</div></div>';
    Template += '<div style="font-size: 15px; vertical-align: middle;color: grey;position: absolute;border-width: 0px;align: left;';
    Template += 'left: 280px; white-space: nowrap;bottom: 30px;"><div class="htmlselect"><span>';
    Template += '<a href="#" id="year" name="Year" onclick="reloadMovieWall(this);">' + obj.YEAR + '</a></span>&emsp;&bull;&emsp;<span>';
    Template += minutesToTime(obj.RUNTIME) + '</span>&emsp;&bull;&emsp;<span style="top: 5px;"><img src="' + parental_rating;
    Template += '" style="height:13px;"></span></div> </div></div>';
    Template += '<div id="synopsis" style="visibility: hidden;"><div style="font-size: 16px; color: grey;position: absolute;border-width: 0px;text-align: left;left: 280px; bottom: 0px; height: 150px;font-family:Tahoma;">' + obj.CONTENT + '</div></div>';
    Template += '<div id="fileinfo" style="font-family: Tahoma;visibility: hidden;"><div style="font-size: 16px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; overflow-x: hidden;right: 20px;white-space: nowrap;bottom: 125px;"><div style="float:left;">' + obj.PATH + '</div></div>';
    Template += '<div id="last_watched" class="lastwatched" style="visibility: hidden;font-size: 16px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 30px; font-family:Tahoma;width: 215px;height;121px;background-image: url(images/movieinfo_last_watched_base.png);"><div class="lastwatched_scene" style="position: absolute; background-image: url(';
    if (typeof obj.BOOKMARK_THUMBNAIL != 'undefined')
        Template += obj.BOOKMARK_THUMBNAIL;
    Template += ');width:211px;height:117px;bottom:2px;left:2px;"><div class="lastwatched_glass" onclick="';
    path = obj.PATH.replace(/\'/g, "%27");
    if (path.indexOf("nfs://") == -1 && path.indexOf("smb://") == -1)
        Template += 'playMedia(\'file://' + path + '\', \'movie\', ' + obj.BOOKMARK_SECONDS + ');"';
    else
        Template += 'playMedia(\'' + path + '\', \'movie\', ' + obj.BOOKMARK_SECONDS + ');"';
    Template += ' style="position: absolute;background-image: url(images/movieinfo_last_watched_glass.png);width:215px;height:121px;left: -2px;bottom:-2px;"><div class="play" style="position: absolute;width: 55px;height:55px;left: 80px;bottom: 33px;background-image: url(images/movieinfo_play_big.png);"></div></div></div><div style="font-family: Tahoma;font-size: 16px; color: white;left:220px;top:100px;position:relative;">';

    if (typeof obj.BOOKMARK_TIME != 'undefined')
        Template += obj.BOOKMARK_TIME;
    Template += '</div></div>';
    Template += '<div style="font-size: 15px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 82px;"><div><span>Subtitle</span></div></div>';
    Template += '<div style="font-size: 16px; color: white;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 55px;"><div><span>UNKNOWN</span></span></div></div> <div style="font-size: 16px; color: grey;position: absolute;border-width: 0px;align: left;left: 280px; bottom: 30px;"><div><span style="color: white;">' + obj.SYSTEM + '</span>&emsp;&bull;&emsp;<span style="color: white;">' + obj.RESOLUTION + '</span></div></div> </div></div>';
    Template += '<div class="posterframe" id="posterframe" style="background-image: url(images/movieinfo_big_thumb_base.png); position: absolute; width:222px;height:322px;bottom: 30px;"><div class="detailposter" id="detailposter" style="background-size: 220px 330px;background-image: url(\'' + poster + '\');">';
    Template += '<div class="detail_glass_frame" id="detailposter_glass" style="background-image: url(images/movieinfo_big_thumb_glass.png);"></div>';
    if (typeof obj.PLAY_COUNT != 'undefined' && obj.PLAY_COUNT != 0)
        Template += "<img class='last_watched_detail' src='images/movieinfo_icon_watched.png' style='left: 160px;top: -62px;position:relative;'>";
    Template += '</div></div></div></div></div> </div>';
    return Template;
}

function musicHTML(obj) {
    if (obj.POSTER == 'NULL' || obj.POSTER == '' || typeof obj.POSTER == 'undefined')
        poster = 'images/albumview_music_songlist_thumb.jpg';
    else
        poster = obj.POSTER.replace(/\'/g, "%27");
    if (typeof obj.TITLE != 'undefined') {
        if (obj.TITLE.length > 24)
            title = obj.TITLE.replace(/&apos;/g, "'").substring(0, 23) + "...";
        else
            title = obj.TITLE;
    }
    var Template = '<div class="dhx_view dhx_multiview" view_id="MovieView" style="position: relative; vertical-align: top; border-left-width: 0px; border-right-width: 0px; border-bottom-width: 0px; margin-top: -1px; width: 985px; height: 520px;">';
    Template += '<div class="musicposter_base" style="background-image: url(images/albumview_details_thumb.png); width:326px;height:409px;bottom: 70px;">';
    Template += '<div class="musicposter" style="background-image: url(' + poster + ');background-size:100%;">';
    Template += '<div class="musicposter_glass" style="background-image: url(images/albumview_details_thumb_glass.png);"></div>';
    if (typeof obj.TITLE != 'undefined') {
        Template += '<div id="movietitle" style="font-size: 30px;color: white;font-family: Tahoma;white-space:nowrap; position: relative;left: -20px;top: 10px;">' + title + '</div>';
        Template += '<div id="artist" style="position: relative;left: -20px;top: 15px;"><span class="htmlselect"><a href="#" name="Artist" onclick="reloadMusicWall(this);" style="color: #4e9fb0;font-size: 24px;">' + obj.ALBUM_ARTIST + '</a></span></div>';
        Template += '<div id="year" style="position: relative;left: -20px;top: 25px;"><span class="htmlselect"><a href="#" name="Year" onclick="reloadMusicWall(this);" style="color: #4e9fb0;font-size: 20px;">' + obj.ALBUM_YEAR + '</a></span></div>';
        Template += '<div id="year" style="font-size: 20px;font-family: Tahoma;color: grey;position: relative;left: 210px;">' + obj.tracks.length + ' Tracks</div>';
    }
    Template += '</div></div></div>';
    Template += '<div class="dhx_win_body" style="left: 350px;top:0px;width: 100%;height: 100%;background: transparent;position: absolute;">';
    Template += '<div class="songinfo" style="height: 100%;"><div class="dhx_scroll_cont" touch_scroll="y" style="-webkit-transform: translate3d(0px, 0px, 0); -webkit-transition: -webkit-transform 0ms; transition: -webkit-transform 0ms; -webkit-user-select: none; -webkit-transform-style: flat;height: ' + (((obj.tracks.length + 1) * 45) + 209) + 'px;">';

    for (var j = 0; j < obj.tracks.length; j++) {
        if (obj.tracks[j].TITLE.length > 45)
            title = obj.tracks[j].TITLE.replace(/&apos;/g, "'").substring(0, 44) + "...";
        else
            title = obj.tracks[j].TITLE;
        Template += '<div class="songs" style="white-space: nowrap;width:603px;margin-top: 20px; left: 50px;" onclick="showMusicDetails(' + (j + 1) + ');">' + title + '<div class="songs" style="right: 50px;text-align:right;width:150px;float:right;">' + obj.tracks[j].RUNTIME + '</div></div>';
        Template += '<div class="music_details" style="position: relative;display:none;height: 209px;left:10px;background-image: url(images/albumview_music_details_info_expand_pane.png);">';
        Template += '<div style="font-size: 20px;color: grey;line-height: 32px;text-align:left;font-family: Tahoma;text-shadow:none;font-weight:normal;left:30px;top:30px;width: 613px;position: relative;"><img style="vertical-align:top;" src="images/albumview_album_name.png">&nbsp;&nbsp;' + obj.tracks[j].ALBUM + '<div style="text-align:right;right:50px;float: right;position:relative;width:150px;">#' + obj.tracks[j].TRACK_NO + '</div></div>';
        Template += '<div style="font-size: 20px;white-space: nowrap;color: grey;text-align:left;font-family: Tahoma;text-shadow:none;font-weight:normal;left:30px;top:40px;line-height: 32px;width:613px;position: relative;"><img style="vertical-align:top;" src="images/albumview_composer_name.png">&nbsp;&nbsp;' + obj.tracks[j].COMPOSER + '<div style="white-space: nowrap;text-align:right;float: right;right:50px;position:relative;width:150px;"><span class="htmlselect"><a href="#" name="Genre" onclick="reloadMusicWall(this);" style="color: #4e9fb0;font-size: 20px;">' + obj.tracks[j].GENRE + '</a></span></div></div>';
        Template += '<div style="font-size: 20px;line-height: 32px;width:613px;color: grey;text-align:left;font-family: Tahoma;text-shadow:none;font-weight:normal;left:30px;top:50px;position: relative;white-space: nowrap;"><img style="vertical-align:top;" src="images/albumview_singer_name.png">&nbsp;&nbsp;<span class="htmlselect"><a href="#" name="Artist" onclick="reloadMusicWall(this);" style="color: #4e9fb0;font-size: 20px;">' + obj.tracks[j].ARTIST + '</a></span><div style="text-align:right;right:50px;float:right;position:relative;width:150px;"><img src="images/common_star_0.png" style="width:70px;"></div></div>';
        Template += '<div class="play" style="width:50px;"><input type="button" style="top: 70px;left: 550px;width:50px;" onclick="';
        if (obj.tracks[j].PATH.indexOf("nfs://") == -1 && obj.tracks[j].PATH.indexOf("smb://") == -1)
            Template += 'playMedia(\'file://' + obj.tracks[j].PATH + '\', \'music\', 0);"';
        else
            Template += 'playMedia(\'' + obj.tracks[j].PATH + '\', \'music\', 0);"';
    }
    Template += ' value="Play"></div></div></div></div></div>';
    return Template;
}

function hideModal() {
    document.getElementById('dhx_episode_cover').style.display = 'none';
    if (document.getElementById("episode_div") != null)
        document.getElementById("episode_div").style.display = 'none';
    if (document.getElementById("chapter_div") != null)
        document.getElementById("chapter_div").style.display = 'none';
}

function showEpisodes() {
    document.getElementById('dhx_episode_cover').style.display = 'block';

    var list = document.getElementById("episode_div");
    if (list.style.display == 'block')
        list.style.display = 'none';
    else
        list.style.display = 'block';
}

function findDivByAttribute(attribute) {
    var elements = document.getElementsByTagName("div");
    for (var h = 0; h < elements.length; h++) {
        if (elements[h].getAttribute("view_id") == attribute)
            return elements[h];
    }
}

function showChapters(length) {
    document.getElementById('dhx_episode_cover').style.display = 'block';

    var list = document.getElementById("chapter_div");
    if (list.style.display == 'block')
        list.style.display = 'none';
    else
        list.style.display = 'block';
}

function showEpisodeDetails(track) {
    var list = document.getElementsByClassName("episode_details");
    for (var i = 0; i < list.length; i++) {
        if (track == i + 1) {
            if (list[i].style.display == 'block')
                list[i].style.display = 'none';
            else
                list[i].style.display = 'block';
        }
        else
            list[i].style.display = 'none';
    }
}

function showMusicDetails(track) {
    var list = document.getElementsByClassName("music_details");
    for (var i = 0; i < list.length; i++) {
        if (track == i + 1) {
            if (list[i].style.display == 'block')
                list[i].style.display = 'none';
            else
                list[i].style.display = 'block';
        }
        else
            list[i].style.display = 'none';
    }
}

function getElementTopLeft(id) {

    var ele = document.getElementById(id);
    var top = 0;
    var left = 0;

    while (ele.tagName != "BODY") {
        top += ele.offsetTop;
        left += ele.offsetLeft;
        ele = ele.offsetParent;
    }

    return { top: top, left: left };

}

function getOffset(el) {
    var _x = 0;
    var _y = 0;
    while (el && !isNaN(el.offsetLeft) && !isNaN(el.offsetTop)) {
        _x += el.offsetLeft - el.scrollLeft;
        _y += el.offsetTop - el.scrollTop;
        el = el.offsetParent;
    }
    return { top: _y, left: _x };
}

function getPos(el) {
    // yay readability
    for (var lx = 0, ly = 0;
         el != null;
         lx += el.offsetLeft, ly += el.offsetTop, el = el.offsetParent);
    return {x: lx, y: ly};
}

function showDiv(div) {

    if (div == 'movieinfo') {
        document.getElementById('movieinfo').style.visibility = 'visible';
        document.getElementById('synopsis').style.visibility = 'hidden';
        document.getElementById('fileinfo').style.visibility = 'hidden';
        document.getElementById('last_watched').style.visibility = 'hidden';
        document.getElementById('button_1').style.color = '#4e9fb0';
        document.getElementById('button_2').style.color = '#fdf0d3';
        if (document.getElementById('button_3').style.color != 'grey')
            document.getElementById('button_3').style.color = '#fdf0d3';
        if (document.getElementById('button_4').style.color != 'grey')
            document.getElementById('button_4').style.color = '#fdf0d3';
    }
    else if (div == 'synopsis') {
        document.getElementById('movieinfo').style.visibility = 'hidden';
        document.getElementById('synopsis').style.visibility = 'visible';
        document.getElementById('fileinfo').style.visibility = 'hidden';
        document.getElementById('last_watched').style.visibility = 'hidden';
        document.getElementById('button_2').style.color = '#4e9fb0';
        document.getElementById('button_1').style.color = '#fdf0d3';
        if (document.getElementById('button_3').style.color != 'grey')
            document.getElementById('button_3').style.color = '#fdf0d3';
        if (document.getElementById('button_4').style.color != 'grey')
            document.getElementById('button_4').style.color = '#fdf0d3';
    }
    else if (div == 'fileinfo') {
        document.getElementById('movieinfo').style.visibility = 'hidden';
        document.getElementById('synopsis').style.visibility = 'hidden';
        document.getElementById('fileinfo').style.visibility = 'visible';
        document.getElementById('last_watched').style.visibility = 'hidden';
        document.getElementById('button_3').style.color = '#4e9fb0';
        document.getElementById('button_1').style.color = '#fdf0d3';
        document.getElementById('button_2').style.color = '#fdf0d3';
        if (document.getElementById('button_4').style.color != 'grey')
            document.getElementById('button_4').style.color = '#fdf0d3';
    }
    else if (div == 'last_watched') {
        document.getElementById('movieinfo').style.visibility = 'hidden';
        document.getElementById('synopsis').style.visibility = 'hidden';
        document.getElementById('fileinfo').style.visibility = 'hidden';
        document.getElementById('last_watched').style.visibility = 'visible';
        document.getElementById('button_4').style.color = '#4e9fb0';
        document.getElementById('button_1').style.color = '#fdf0d3';
        document.getElementById('button_2').style.color = '#fdf0d3';
        document.getElementById('button_3').style.color = '#fdf0d3';
    }
}

var seasonDetailView = {
    id: 'SeasonDetailView',
    view: 'template',
    template: function (obj) {
        if (typeof obj.OVS_ID != 'undefined') {
            return seasonHTML(obj);
        }
    }
};

var movieDetailView = {
    id: 'MovieDetailView',
    view: 'template',
    template: function (obj) {
        if (typeof obj.OVS_ID != 'undefined') {
            return movieHTML(obj);
        }
    }
};

var musicDetailView = {
    id: 'MusicDetailView',
    view: 'template',
    template: function (obj) {
        if (typeof obj.tracks != 'undefined') {
            return musicHTML(obj);
        }
    }
};

var movieView = {
    id: 'MovieView',
    view: "multiview",
    scroll: true,
    cells: [
        movieWallView,
        musicWallView,
        movieDetailView,
        seasonDetailView,
        musicDetailView
    ]
};

var toolBar = {
    view: 'toolbar', type: 'MainBar', height: 43, css: "topBar",
    id: 'Toolbar',
    visibleBatch: "wall",
    elements: [
        { view: "button", id: "menu", batch: "wall", popup: "MainMenu", label: "Menu",
            inputWidth: 80, align: 'left'},
        { view: "label", css: 'title', id: "title", batch: "wall", label: "Movie",
            align: 'center'},
        { view: "text", placeholder: 'Title Search', label: "", id: "search", batch: "wall", inputWidth: 300, type: "text",
            align: "right"},
        { view: "button", id: "movie_back", batch: "movie_detail", label: "Back",
            inputWidth: 80, align: 'left' },
        { view: "button", id: "season_back", batch: "season_detail", label: "Back",
            inputWidth: 80, align: 'left' },
        { view: "button", id: "music_back", batch: "music_detail", label: "Back",
            inputWidth: 80, align: 'left' },
        { view: "button", id: "movie_prev", batch: "movie_detail1", label: "Prev",
            inputWidth: 80, align: 'left' },
        { view: "button", id: "movie_next", batch: "movie_detail1", label: "Next",
            inputWidth: 80, align: 'right', width: 90 },
        { view: "button", id: "movie_play", batch: "movie_detail", label: "Play",
            inputWidth: 80, align: 'right', width: 90 },
        { view: "button", id: "season_play", batch: "season_detail", label: "Play",
            inputWidth: 80, align: 'right', width: 90 },
        { view: "button", id: "music_play", batch: "music_detail", label: "Play Album",
            inputWidth: 120, align: 'right', width: 90 }
    ]
};

var config = {
    rows: [
        toolBar,
        movieView
    ]
};

// Handy JavaScript to meature the size taken to render the supplied text;
// you can supply additional style information too if you have it to hand.

function measureText(pText, pFontSize, pStyle) {
    var lDiv = document.createElement('lDiv');

    document.body.appendChild(lDiv);

    if (pStyle != null) {
        lDiv.style = pStyle;
    }
    lDiv.style.fontSize = "" + pFontSize + "px";
    lDiv.style.position = "absolute";
    lDiv.style.left = -1000;
    lDiv.style.top = -1000;

    lDiv.innerHTML = pText;

    var lResult = {
        width: lDiv.clientWidth,
        height: lDiv.clientHeight
    };

    document.body.removeChild(lDiv);
    lDiv = null;

    return lResult;
}

function minsToHms(d) {
    d = Number(d);
    var h = Math.floor(d / 60);
    var m = Math.floor(d % 60);
    return ((h < 10 ? "0" + h + ":" : h + ":") + (m < 10 ? "0" + m + ":" : m + ":") + "00");
}
