#!/bin/sh

if [ -d /opt/gaya ]; then
    DIR=/nmt/syb8634/server
else
    DIR=/nmt/apps/server
fi

install()
{
    if [ -d $DIR ];then
        cd $DIR
        if [ -f php-cgi ];then
            mv php-cgi php-cgi.old
        fi
        if [ -f php ];then
            mv php php.old
        fi
        tar xvf /share/Apps/php7/php7.tar
        ln -s php7-cgi php-cgi
        ln -s php7-cli php
        ln -s php7dbg phpdbg
    else
        exit 1
    fi
}

uninstall()
{
    if [ -d $DIR ];then
        cd $DIR
        if [ -f php-cgi.old ];then
            rm -f php-cgi
            mv php-cgi.old php-cgi
        fi
        if [ -f php.old ];then
            rm -f php
            mv php.old php
        fi
        rm -f phpdbg
        cd ../etc;rm -rf php7
        cd ../lib;rm -rf php7
    else
        exit 1
    fi

}

case "$1" in
    install)
    install
    ;;

    uninstall)
    uninstall
    ;;
esac
