#!/bin/sh
#Set Paths
PATH=$PATH:/bin:/usr/local/bin:/share/Apps/local/bin:/share/Apps/local/sbin:/share/Apps/local/libexec/git-core:/nmt/apps/bin;export PATH
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/lib:opt/syb/app/lib:/nmt/app/lib:/opt/syb/sigma/lib:/usr/local/bin:/share/Apps/local/lib;export LD_LIBRARY_PATH
MANPATH=$MANPATH:/usr/local/share/man:/share/Apps/local/share/man;export MANPATH

# Package
PACKAGE="sickbeard"
DNAME="sickbeard"

# Others
SSDAEMON="/share/Apps/local/sbin/start-stop-daemon"
APP_PATH="/share/Apps/${DNAME}"
PYTHON_DIR="/share/Apps/local/bin"
RUNAS="root"
PYTHON="${PYTHON_DIR}/python2.7"
PID_FILE="/var/sickbeard.pid"
SICKBEARD="${APP_PATH}/SickBeard.py "
LOG_FILE="${APP_PATH}/Logs/sickbeard.log"
CFG_FILE="${APP_PATH}/config.ini"

#check hosts
if [ -d /opt/gaya ]; then
    name1=$(cat /etc/hostname)
    if grep -q "$name1" /etc/hosts;	then
	    echo "Host name has been added already"
    else
	    echo "Host name added to list"
	    echo "127.0.0.1 localhost localhost.images localhost.drives $name1" >/share/Apps/CouchpotatoV2/hosts
	    cp /share/Apps/CouchpotatoV2/hosts /etc/hosts
    fi
fi

start_daemon()
{
rm -rf $PID_FILE || return 1
#echo "$SSDAEMON -c root --start --background --pidfile $PID_FILE --exec $PYTHON -- $SICKBEARD --daemon --pidfile=$PID_FILE --config=$CFG_FILE"
$SSDAEMON -c root --start --background --pidfile $PID_FILE --exec $PYTHON -- $SICKBEARD --daemon --pidfile=$PID_FILE --config=$CFG_FILE
} 

is_running() {
    [ -r "$PID_FILE" ] && pid=`cat $PID_FILE`
    [ -n "$pid" -a -r "/proc/$pid" ] && return 0 || return 1
}

stop() {
    if is_running ; then : ; else
        echo "${DNAME} not running"
		rm -f $PID_FILE
        return
    fi

    kill $pid
    while [ -r "/proc/$pid" ] ; do sleep 1 ; done
    rm -f $PID_FILE
    echo "${DNAME} stopped"
}



#Main
case $1 in
    start)
        if is_running ; then
            echo "${DNAME} already running, pid $pid"
            exit 1
        fi
        start_daemon
        ;;
    stop)
        stop
        ;;
    status)
        if daemon_status; then
echo ${DNAME} is running
            exit 0
        else
echo ${DNAME} is not running
            exit 1
        fi
        ;;
    log)
        echo ${LOG_FILE}
        ;;
    *)
        exit 1
        ;;
esac