#!/bin/sh
#Set Paths
PATH=$PATH:/bin:/usr/local/bin:/share/Apps/local/bin:/share/Apps/local/libexec/git-core:/nmt/apps/bin;export PATH
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/lib:opt/syb/app/lib:/nmt/app/lib:/opt/syb/sigma/lib:/usr/local/bin:/share/Apps/local/lib;export LD_LIBRARY_PATH
MANPATH=$MANPATH:/usr/local/share/man:/share/Apps/local/share/man;export MANPATH

LOCAL=/share/Apps/local
OPKG=$LOCAL/bin/opkg

install()
{
    if [ -d /opt/gaya ]; then
        MODEL=a110
	else
		CHIPSET=`/opt/syb/sigma/bin/gbus_read_uint32 0x0002fee8 2>&-`
		if [ $CHIPSET = "0x00008911" ];then
            MODEL=a400
		elif [ $CHIPSET = "0x00008647" -o $CHIPSET = "0x00008643" ];then
            MODEL=c200
		fi
    fi

    # Check opkg installation
    if [ ! -f $OPKG ]; then
        echo "Required dependency, opkg (local) is not installed, Forcing install"
        cd /share
        wget -q http://sourceforge.net/projects/nmtcsi/files/opkg_${MODEL}_latest.zip
        unzip opkg_${MODEL}_latest.zip
        if [ -f opkg.tar ];then
            /share/Apps/AppInit/appinit.cgi install opkg.tar
            rm opkg.tar opkg_${MODEL}_latest.zip
        fi
    else
        echo "Required dependency, opkg (local) is installed."
    fi

	$OPKG update
	
    # install python2.7
    if [ -f /share/Apps/local/bin/python2.7 ]; then
    	echo "Required dependency, python is installed."
    else
    	echo "Installing dependency, python2.7"
    	$OPKG install python2.7 --force-depends --force-overwrite --force-reinstall
    fi
	
    # install expat
    if [ -f /share/Apps/local/lib/python2.7/xml/parsers/expat.py ]; then
    	echo "Required dependency, expat is installed."
    else
    	echo "Installing dependency, expat"
    	$OPKG install expat --force-depends --force-overwrite --force-reinstall
    fi
	
	# install git
    if [ -f /share/Apps/local/bin/git ]; then
    	echo "Required dependency, git is installed."
    else
    	echo "Installing dependency, git"
    	$OPKG install git --force-depends --force-overwrite --force-reinstall
    fi
	
    # install coreutils
    if [ -f /share/Apps/local/bin/tr ]; then
    	echo "Required dependency, coreutils is installed."
    else
    	echo "Installing dependency, coreutils"
    	$OPKG install coreutils --force-depends --force-overwrite --force-reinstall
    fi
	
	# install start-stop-daemon
    if [ -f /share/Apps/local/sbin/start-stop-daemon ]; then
    	echo "Required dependency, start-stop-daemon is installed."
    else
    	echo "Installing dependency, start-stop-daemon"
    	$OPKG install start-stop-daemon --force-depends --force-overwrite --force-reinstall
    fi
	
	#install Cheetah
    if [ -d /share/Apps/local/lib/python2.7/site-packages/Cheetah ] ; then     
	    echo "Cheetah is installed"
    else
	    cd /share/Apps/sickbeard/
	    wget http://pypi.python.org/packages/source/C/Cheetah/Cheetah-2.4.4.tar.gz --no-check-certificate
	    tar -zxvf Cheetah-2.4.4.tar.gz
	    cd Cheetah-2.4.4
	    /share/Apps/local/bin/python2.7 setup.py install
		cd /
		rm -Rf /share/Apps/sickbeard/Cheetah-2.4.4
		rm -Rf /share/Apps/sickbeard/Cheetah-2.4.4.tar.gz
    fi


	# install sickbeard
	if [ -d /share/Apps/sickbeard/autoProcessTV ] ; then 
		echo "sickbeard is installed"
	else
		chmod -R 777 /share/Apps/sickbeard
		mkdir /share/tmp
		cd /share/tmp
		/share/Apps/local/bin/git clone git://github.com/midgetspy/Sick-Beard.git -b development SB
		cp -Ra SB/. /share/Apps/sickbeard
		chmod -R 777 /share/Apps/sickbeard
		cd
		rm -Rf /share/tmp
		rm -Rf /share/Apps/sickbeard/.git
	fi

	$OPKG upgrade
}

uninstall()
{
    if [ -d /share/Apps/sickbeard ]; then
		rm -R /share/Apps/sickbeard
    fi
}


case "$1" in
    install)
    install
    ;;
    
    uninstall)
    uninstall
    ;;
esac