#!/bin/sh

start()
{	
    if [ -n "`ps | grep '/share/Apps/Transmission/bin/transmission-daemon' | grep -v 'grep'`" ]; then
        #don't start it twice
		echo "Transmission CSI already running"
        exit 0
    fi
	
    if [ -n "`ps | grep "transmission-daemon" | grep -v "Apps" | grep -v "grep"`" ]; then
        /nmt/apps/server/clutch stop >/dev/null 2>&1

        i=0
        while [ -n "`ps | grep "transmission-daemon" | grep -v "Apps" | grep -v "grep"`" ] && [ $i -le 5 ]; do
            i=$(( $i + 1 ))
            sleep 1
        done

        kill -9 `pidof transmission-daemon` >/dev/null 2>/dev/null
        sleep 2
    fi

    # Make sure we aren't already running
    ps | grep transmission-daemon | grep -v grep
    if [  "$?" != "1" ]; then
        echo "Can't stop existing running transmission."
        exit 1;
    fi
	
    if [ ! -e /share/Download ]; then
        mkdir /share/Download -m 777
    fi

    if [ ! -e /share/Apps/Transmission/config/ ]; then
        mkdir /share/Apps/Transmission/config/ -m 777
    fi

	chmod +x /share/Apps/Transmission/bin/transmission-daemon
	
    if [ ! -f "/share/Apps/Transmission/config/settings.json" ]; then
        /share/Apps/Transmission/bin/transmission-daemon -a "127.0.0.1, *.*.*.*" -w /share/Download -p 9091 -ep -L 100 -l 20 -d 2> /share/Apps/Transmission/config/settings.json
        chmod 777 /share/Apps/Transmission/config/settings.json
    fi

	# Kernel optimalizations
	echo 524288 > /proc/sys/net/core/rmem_default
	echo 524288 > /proc/sys/net/core/rmem_max
	echo "16384 87380 87380" > /proc/sys/net/ipv4/tcp_rmem
	
	# Set ownerships
	chown -R nmt /share/Download
	chown -R nmt /share/Apps/Transmission
	
	# Set WebUI home
	export TRANSMISSION_WEB_HOME=/share/Apps/Transmission/transmission_web
	
	/share/Apps/Transmission/bin/start-stop-daemon -c nmt -x /share/Apps/Transmission/bin/transmission-daemon -S -- -g /share/Apps/Transmission/config -e /share/Apps/Transmission/daemon.log --log-error
	
	if [ $? -eq 0 ] ; then
		if [ "`pflash get btpdserv`" = "0" ] ; then
			pflash set btpdserv 1
		fi		
	else
		echo "Failed to start daemon."
	fi
}

stop()
{	
    if [ "`pflash get btpdserv`" == "1" ]; then
        pflash set btpdserv 0
    fi

    killall transmission-daemon 1>/dev/null 2>/dev/null

    i=0
    while [ -n "`ps | grep "transmission-daemon" | grep -v "grep"`" ] && [ $i -le 30 ]; do
        i=$(( $i + 1 ))
        sleep 1
    done

    if [ -n "`ps | grep "transmission-daemon" | grep -v "grep"`" ]; then
        kill -9 `pidof transmission-daemon` >/dev/null 2>/dev/null
        sleep 2
    fi
	
	if [ -f "/share/Apps/Transmission/config/settings.json" ] ; then
		chmod 666 "/share/Apps/Transmission/config/settings.json"
	fi
}

case "$1" in
	start)
	start
	;;

	stop)
	stop
	;;

	restart)
	stop
	sleep 1
	start
esac
