<?php

/***************************************************************

	This file is part of Transmission Web/Gaya GUI
	File created by: Ger Teunis
	File updated by: Shurup <shurup@gmail.com>

	Transmission Web/Gaya GUI is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Transmission Web/Gaya GUI is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Transmission Web/Gaya GUI; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


****************************************************************/

/*
 * Generic RPC Request
 */
function tr_rpcRequest($_request)
{
	$request = json_encode($_request);
	$URI = "/transmission/rpc";
	$Host = "localhost";
	$Port = 9091;
	$ReqHeader =
		"POST $URI HTTP/1.1\r\n".
		"Host: $Host\r\n".
		"X-Transmission-Session-Id: ".$GLOBALS["X-Transmission-Session-Id"]."\r\n".
		"Connection: Close\r\n".
		"Content-Type: json\r\n".
		"Accept: application/json, text/javascript, *.*\r\n".
		"Content-Length: ".strlen($request)."\r\n\r\n".
		"$request";
	$socket = fsockopen($Host, $Port, $errno, $errstr);
	if( !$socket ) return array("errno" => $errno, "errstr" => $errstr, "result" => "Unable to open Socked");

	$idx = 0;
	$skip = 1;
	$fullbody = $body = "";
	fputs($socket, $ReqHeader);
	while( !feof($socket) )
	{
		$responce[$idx] = fgets($socket, 128);
		$fullbody .= $responce[$idx];
		if( $skip == 1 && ereg("^{", $responce[$idx]) ) $skip = 0;
		if( !$skip ) $body .= $responce[$idx];
		$idx++;
	}
	fclose($socket);

	//#####################################################################
	//check for 409
	//#####################################################################

	if( preg_match("/http\/\d\.\d\s+409\s+conflict/si", $fullbody) )
	{
		if( preg_match("/x\-transmission\-session\-id\:\s+([a-z0-9]{48})/si", $fullbody, $matches) )
		{
			$GLOBALS["X-Transmission-Session-Id"] = $matches[1];
			return tr_rpcRequest($_request);
		}
	}
	
	//#####################################################################
	//#####################################################################
	
	return json_decode($body, TRUE);
}

/*
 * 3.1 Torrent Action Requests
 * request arguments: ids, if ommited applys to all
 * responce arguments: none
 */
function tr_torrentActionRequest($method, $ids = array()) {
	$request = array('method' => $method);
	if(count($ids))
		$request['arguments']['ids'] = $ids;
	$r = tr_rpcRequest($request);
	// var_dump(json_encode($request));
	return($r['result'] == 'success');
}

function tr_torrentRemove($ids = array()) {
	return tr_torrentActionRequest('torrent-remove', $ids);
}

function tr_torrentStart($ids = array()) {
	return tr_torrentActionRequest('torrent-start', $ids);
}

function tr_torrentStop($ids = array()) {
	return tr_torrentActionRequest('torrent-stop', $ids);
}

function tr_torrentVerify($ids = array()) {
	return tr_torrentActionRequest('torrent-verify', $ids);
}

function tr_torrentRemoveAll() {
	return tr_torrentActionRequest('torrent-remove');
}

function tr_torrentStartAll() {
	return tr_torrentActionRequest('torrent-start');
}

function tr_torrentStopAll() {
	return tr_torrentActionRequest('torrent-stop');
}

/*
 * 3.2 Torrent Mutators
 * request arguments: ids, field of strings
 * responce arguments: none
 */
function tr_torrentMutator($fields, $ids = array()) {
	$request = array('method' => 'torrent-set', 'arguments' => $fields);
	if(count($ids))
		$request['arguments']['ids'] = $ids;
	$r = tr_rpcRequest($request);
	return($r['result'] == 'success');
}

/*
 * 3.3 Torrent Accessors
 * request arguments: required "fields", optional "ids"
 * responce arguments: a "torrents" array of objects, containing "fields"
 */

function tr_torrentAccessor($fields, $ids = array()) {
	$request = array('method' => 'torrent-get',
	                 'arguments' => array('fields' => $fields));
	if(count($ids))
		$request['arguments']['ids'] = $ids;
	$r = tr_rpcRequest($request);
  
  usort($r['arguments']['torrents'], "sort_on_ratio");
  
	return($r['result'] == 'success' ? $r['arguments']['torrents'] : FALSE);
}

function sort_on_ratio($a, $b) {
    $ratio_a = $a["uploadedEver"] / $a["totalSize"];
    $ratio_b = $b["uploadedEver"] / $b["totalSize"];
    
    if ($ratio_a == $ratio_b) {
        return 0;
    }
    return ($ratio_a > $ratio_b) ? -1 : 1;
}

/*
 * 3.4 Adding a Torrent
 * Must have either filename or metainfo
 */


function tr_torrentAdd($file, $arguments = array()) {
	if(!($content = file_get_contents($file)))
		return FALSE;
	$request = array('method' => 'torrent-add');
	if(count($arguments))
		$request['arguments'] = $arguments;
	$request['arguments']['metainfo'] = base64_encode($content);
	$r = tr_rpcRequest($request);
	return($r['result'] == 'success' ? $r['arguments']['torrents'] : FALSE);
}

function tr_sessionSet($arguments) {
}

function tr_sessionGet($arguments) {
}

function tr_sessionStats() {
	global $tr_savedSessionStats;
	if(isset($tr_savedSessionStats))
		return $tr_savedSessionStats;

	$request = array('method' => 'session-stats');
	$r = tr_rpcRequest($request);
	if($r['result'] == 'success') {
		$tr_savedSessionStats = $r['arguments'];
		return $tr_savedSessionStats;
	}
	return FALSE;
}

/*
 * 4.1.2.  Session Accessors
 * Request arguments: none
 * Response arguments: all of 4.1's arguments
 */

function tr_sessionAccessor($fields) {
	$request = array('method' => 'session-get',
	                 'arguments' => array('fields' => $fields));
	$r = tr_rpcRequest($request);
	return($r['result'] == 'success' ? $r['arguments'] : FALSE);
}

/*
 * 4.1.1.  Session Mutators
 * Request arguments: one or more of 4.1's arguments, except "version"
 * Response arguments: none
 */

function tr_sessionMutator($fields) {
	$request = array('method' => 'session-set', 'arguments' => $fields);
	$r = tr_rpcRequest($request);
	return($r['result'] == 'success');
}

?>