#!/bin/sh
#Set Paths
PATH=$PATH:/bin:/usr/local/bin:/share/Apps/local/bin:/share/Apps/local/libexec/git-core:/nmt/apps/bin;export PATH
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/lib:/opt/syb/app/lib:/nmt/app/lib:/opt/syb/sigma/lib:/usr/local/bin:/share/Apps/local/lib;export LD_LIBRARY_PATH
MANPATH=$MANPATH:/usr/local/share/man:/share/Apps/local/share/man;export MANPATH
DIR=/nmt/apps

configid=$(genxenv2 l /tmp/lrro.xenv 2>/dev/null | grep -e " lrro.configid" | sed -e's/.*lrro.configid\s*//' | sed 's/\ //g'| sed 's/0x//g')
install()
{
# Check opkg installation
if [ -f /share/Apps/local/bin/opkg ]; then
	echo "Required dependency, opkg (local) is installed."
else
	echo "Required dependency, opkg (local) is not installed, Forcing install"
	mkdir /share/tmp
	cd /share/tmp
	if [ -e "/nmt/apps" ]; then
		if [[ "$configid" = *8911* ]]; then
			echo "Popcorn Hour A-400"
			wget https://raw.githubusercontent.com/vaidyasr/nmtcsi/master/csi/csi-packages/opkg_a400_latest.zip
			unzip opkg_a400_latest.zip
		elif [[ "$configid" = *8757* ]]; then
			echo "Popcorn Hour VTEN"
			wget https://raw.githubusercontent.com/vaidyasr/nmtcsi/master/csi/csi-packages/opkg_vten_latest.zip
			unzip opkg_vten_latest.zip
		elif [[ "$configid" = *8758* ]]; then
			echo "Popcorn Hour A-500"
			wget https://raw.githubusercontent.com/vaidyasr/nmtcsi/master/csi/csi-packages/opkg_vten_latest.zip
			unzip opkg_vten_latest.zip
		else
			echo "Popcorn Hour 200/300 series"
			wget https://raw.githubusercontent.com/vaidyasr/nmtcsi/master/csi/csi-packages/opkg_c200_latest.zip
			unzip opkg_c200_latest.zip
		fi
	else
		echo "Popcorn Hour A-1xx/B-110"
		wget https://raw.githubusercontent.com/vaidyasr/nmtcsi/master/csi/csi-packages/opkg_a110_latest.zip
		unzip opkg_a110_latest.zip
	fi
	mkdir /share/Apps/local
	chmod -R 777 /share/Apps/local
	tar xvf opkg.tar -C /share/Apps/local
	cd /
	/share/Apps/AppInit/appinit.cgi start local >/dev/null
	rm -r /share/tmp
fi
 
# Update opkg installation
opkg update

# install transmission-daemon
opkg install transmission-daemon -force-depends -force-overwrite -force-reinstall

# install transmission-cli
opkg install transmission-cli -force-depends -force-overwrite -force-reinstall

# install busybox
opkg install busybox -force-depends -force-overwrite -force-reinstall
 
# install Transmission
if [ -L /share/Apps/Transmission/bin/transmission-daemon ] ; then 
	echo "Transmission is installed"
else
    cd /share/Apps/Transmission/bin/;ln -s /share/Apps/local/bin/transmission-* .
fi

    if [ -d $DIR ];then
        cd $DIR/server;./clutch stop
        mv clutch clutch.org
        cp /share/Apps/Transmission/clutch.sh clutch
        chmod 777 clutch
        killall btpd_monitor
        cd $DIR
        if [ -d "clutch5" ];then
            mv clutch5 clutch5.org
            tar xvf /share/Apps/Transmission/clutch5.tar
        fi
        cd $DIR/server;./clutch start
    else
        exit 1
    fi
}

uninstall()
{
    if [ -d /share/Apps/Transmission ]; then
	rm -R /share/Apps/Transmission
    fi
    if [ -d $DIR ];then
        cd $DIR/server;./clutch stop
        mv clutch.org clutch
        killall btpd_monitor
        cd $DIR
        if [ -d "clutch5.org" ];then
            rm -rf clutch5
            mv clutch5.org clutch5
        fi
        cd $DIR/server;./clutch start
    else
        exit 1
    fi
}

case "$1" in
    install)
    install
    ;;
    
    uninstall)
    uninstall
    ;;
esac
