#!/bin/sh
CONFPATH="/nmt/apps/server/php5server"
APPPATH="/nmt/apps/bin"
LOCALPATH="/share/Apps/local/bin"
DLPATH="/share/Download"
LD_LIBRARY_PATH=/nmt/apps/lib:$LD_LIBRARY_PATH

export TRANSMISSION_WEB_HOME=/nmt/apps/clutch5

case "$1" in
  start)
	chmod 777 /tmp
	rm -f $CONFPATH/error.log
	cd /nmt/apps/server/

	crontab /nmt/apps/etc/root.cron
	if [ -e /share/.transmission/btschlist ]; then
		schnum=`cat /share/.transmission/btschnum`
		cat /share/.transmission/btschlist >> /var/spool/cron/crontabs/root
		sed -i '1c\\#-'${schnum} /var/spool/cron/crontabs/root
		crontab /var/spool/cron/crontabs/root
	fi

	echo -n "Start Transmission BT : "
	export HOME=/share/

	if [ ! -e /share/Download ]; then
		mkdir /share/Download -m 777
	fi

	umask 0000
	if [ -e /share/.transmission/ ]; then
		chmod -R 777 /share/.transmission/

		if [ ! -e /share/.transmission/daemon ]; then
			mkdir /share/.transmission/daemon
			cp /nmt/apps/bin/state /share/.transmission/daemon/
			cp /nmt/apps/clutch5/unrar.sh /share/.transmission
			chmod 777 /share/.transmission/unrar.sh
			$LOCALPATH/transmission-daemon -d 2> /share/.transmission/settings.json
			chmod 777 /share/.transmission/settings.json
		fi

		$LOCALPATH/transmission-daemon -g /share/.transmission -w $DLPATH
		if [ "$?" = "0" ]; then
			echo "[  OK  ]"
			sleep 1
			sleep 1
			/nmt/apps/etc/checkbandwidthscheduler-script
		else
			echo "[FAILED]";
		fi
	else
		mkdir /share/.transmission/ -m 777
		mkdir /share/.transmission/daemon
		cp /nmt/apps/bin/state /share/.transmission/daemon/
		cp /nmt/apps/clutch5/unrar.sh /share/.transmission
		chmod 777 /share/.transmission/unrar.sh
		$LOCALPATH/transmission-daemon -d 2> /share/.transmission/settings.json
		chmod 777 /share/.transmission/settings.json
		$LOCALPATH/transmission-daemon -g /share/.transmission -w $DLPATH
		if [ "$?" = "0" ]; then
			echo "[  OK  ]"
			sleep 1
			$LOCALPATH/transmission-remote -w $DLPATH
		else
			echo "[FAILED]";
		fi
	fi

##	/opt/sybhttpd/default/webservices.cgi cmd=RelPG_0

	cd -
	;;
  start_xapache)
	chmod 777 /tmp
	rm -f $CONFPATH/error.log
	cd /nmt/apps/server/

	crontab /nmt/apps/etc/root.cron
	if [ -e /share/.transmission/btschlist ]; then
		schnum=`cat /share/.transmission/btschnum`
		cat /share/.transmission/btschlist >> /var/spool/cron/crontabs/root
		sed -i '1c\\#-'${schnum} /var/spool/cron/crontabs/root
		crontab /var/spool/cron/crontabs/root
	fi

	echo -n "Start Transmission BT : "
	export HOME=/share/

	if [ ! -e /share/Download ]; then
		mkdir /share/Download -m 777
	fi

	umask 0000
	if [ -e /share/.transmission/ ]; then
		chmod -R 777 /share/.transmission/

		if [ ! -e /share/.transmission/daemon ]; then
			mkdir /share/.transmission/daemon
			cp /nmt/apps/bin/state /share/.transmission/daemon/
			cp /nmt/apps/clutch5/unrar.sh /share/.transmission
			chmod 777 /share/.transmission/unrar.sh
			$LOCALPATH/transmission-daemon -d 2> /share/.transmission/settings.json
			chmod 777 /share/.transmission/settings.json
		fi

		$LOCALPATH/transmission-daemon -g /share/.transmission -w $DLPATH
		if [ "$?" = "0" ]; then
			echo "[  OK  ]"
			sleep 1
			#chmod 777 /share/.transmission/daemon/socket
		else
			echo "[FAILED]";
		fi
	else
		mkdir /share/.transmission/ -m 777
		mkdir /share/.transmission/daemon
		cp /nmt/apps/bin/state /share/.transmission/daemon/
		cp /nmt/apps/clutch5/unrar.sh /share/.transmission
		chmod 777 /share/.transmission/unrar.sh
		$LOCALPATH/transmission-daemon -d 2> /share/.transmission/settings.json
		chmod 777 /share/.transmission/settings.json
		$LOCALPATH/transmission-daemon -g /share/.transmission -w $DLPATH
		if [ "$?" = "0" ]; then
			echo "[  OK  ]"
			sleep 1
			#chmod 777 /share/.transmission/daemon/socket
			$LOCALPATH/transmission-remote -w $DLPATH
		else
			echo "[FAILED]";
		fi
	fi

	cd -
	;;
  stop)
	cd /nmt/apps/server/

	crontab /etc/cron/root.cron
	if [ -e /share/.transmission/btschlist ]; then
		schnum=`cat /share/.transmission/btschnum`
		cat /share/.transmission/btschlist >> /var/spool/cron/crontabs/root
		sed -i '1c\\#-'${schnum} /var/spool/cron/crontabs/root
		crontab /var/spool/cron/crontabs/root
	fi

	echo -n "Stop Transmission Daemon : "
	kill -15 `pidof transmission-daemon`
	echo "[  OK  ]";

	#btpd_monitor will keep on pidof transmission-daemon until it exit then will refresh webservices,setup html
	killall btpd_monitor
	/nmt/apps/bin/btpd_monitor &
	rm /tmp/bt_data

	cd -
	;;
	forcestop)
	cd /nmt/apps/server/

	crontab /etc/cron/root.cron

	echo -n "Stop Transmission Daemon : "
	kill -15 `pidof transmission-daemon`
	echo "[  OK  ]";

	killall btpd_monitor
	rm /tmp/bt_data


	cd -
	;;
  *)
	echo "Usage: $0 {start|stop}"
	exit 1
esac

exit 0
